import 'package:card_swiper/card_swiper.dart';
import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/dio/api.dart';

import '../model/banner_list_bo.dart';

//layouts swiper
class CardSwiper extends StatefulWidget {
  const CardSwiper({super.key, required this.bannerList});

  final List<Data>? bannerList;

  @override
  _CardSwiperState createState() => _CardSwiperState();
}

class _CardSwiperState extends State<CardSwiper> {
  // List<Map> banner = [
  //   {"url": "assets/banner/banner1.jpg"},
  //   {"url": "assets/banner/banner2.jpg"},
  //   {"url": "assets/banner/banner1.jpg"}
  // ];

  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: 230,
      child: Swiper(
          itemBuilder: (BuildContext context, int index) {
            // return Image.asset(
            //   widget.bannerList[index].advertisUrl,
            //   fit: BoxFit.fill,
            // );
            return Image.network(
              '${Api.URL}special${widget.bannerList![index].advertisUrl!}',
              fit: BoxFit.fill,
              errorBuilder: (context, error, stackTrace) {
                return Image.asset('assets/day/no_data_icon.png');
              },
            );
          },
          onTap: (index) {
            print(index);
          },
          itemCount: widget.bannerList!.length,
          pagination: const SwiperPagination(
              builder: DotSwiperPaginationBuilder(
                  color: Color(0xFFD39C7F), activeColor: Color(0xFFFF4646))),
          // loop: false,
          autoplay: true,
          duration: 2000,
          autoplayDelay: 5000
          // viewportFraction: 0.8,
          // scale: 0.9,
          ),
    );
  }
}
