import 'package:flutter/material.dart';

class SlideAppBarWidget extends StatelessWidget implements PreferredSizeWidget {
  const SlideAppBarWidget(
      {super.key,
      required this.chlid,
      required this.controller,
      required this.visible});

  final PreferredSizeWidget chlid;
  final AnimationController controller;
  final bool visible;

  @override
  // TODO: implement preferredSize
  Size get preferredSize => chlid.preferredSize;

  @override
  Widget build(BuildContext context) {
    visible ? controller.forward() : controller.reverse();
    return SlideTransition(
        position: Tween<Offset>(
          begin: Offset.zero,
          end: const Offset(0, -1),
        ).animate(
            CurvedAnimation(parent: controller, curve: Curves.fastOutSlowIn)),
        child: chlid);
  }
}
