// ignore_for_file: prefer_typing_uninitialized_variables, must_be_immutable

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:special_equipment_flutter/common/color_const.dart';

///全局统一appbar
class AppBarCustom extends StatelessWidget implements PreferredSizeWidget {
  Widget? leading;

  ///标题内容
  var text;

  ///标题颜色
  var textColor;

  ///背景色
  var bgColor;

  ///icon颜色
  var iconColor;

  double height;

  List<Widget>? actions = [];

  PreferredSizeWidget? bottom;

  AppBarCustom(
      {super.key,
      this.leading,
      this.text,
      this.textColor,
      this.bgColor,
      this.iconColor,
      required this.height,
      this.bottom,
      this.actions});

  @override
  Widget build(BuildContext context) {
    return buildAppBar(context);
  }

  AppBar buildAppBar(BuildContext context) {
    return AppBar(
      backgroundColor: bgColor ?? ColorConst.blueColor,
      leading: leading,
      elevation: 0,
      shadowColor: ColorConst.greyF8Color,
      actions: actions,

      /// 这里设置标题的左边距为零
      titleSpacing: 0.0,
      title: Container(
        alignment: Alignment.centerLeft,
        child: Text(
          text,
          style: TextStyle(
              color: textColor ?? ColorConst.whiteColor, fontSize: 18),
        ),
      ),
      bottom: bottom,
    );
  }

  @override
  Size get preferredSize => Size(100, height); //写啥没差，自动采用子视图尺寸
}
