import 'package:flutter/material.dart';
import 'package:flutter_treeview/flutter_treeview.dart';
import 'package:special_equipment_flutter/model/city_address_bo.dart';

class TreeDataUtil {
  static List<Node> createNodeList(
      List<CityAddressBo> cityAddressBoList, String parentId) {
    List<Node> nodeList = [];

    for (final item in cityAddressBoList) {
      if (item.parent == parentId) {
        List<Node> children =
            createNodeList(cityAddressBoList, item.id.toString());
        nodeList.add(
          Node(
            expanded: item.parent == '#',
            key:
                '${item.parent.toString()}-*-${item.id.toString()}-*-${item.name}',
            // key: item.id.toString(),
            label: item.name.toString(),
            children: children,
            parent: children.isNotEmpty,
            /*icon: children.isEmpty ? Icons.star : Icons.location_city*/
          ),
        );
      }
    }
    return nodeList;
  }

  static List<Node> loadNodes(List<CityAddressBo> cityAddressBoList) {
    return createNodeList(cityAddressBoList, '#');
  }
}
