class StringUtils {
  static String filterNullString(String originalStr) {
    if (originalStr.isEmpty ||
        originalStr == "<null>" ||
        originalStr == "null") {
      return "";
    } else {
      return originalStr;
    }
  }

  static bool isEmpty(String? input) {
    if (input == null) {
      return false;
    }

    if (input.isEmpty) {
      return false;
    }

    return true;
  }

  static bool strIsEmpty(String originalStr) {
    if (originalStr.isEmpty ||
        originalStr == "<null>" ||
        originalStr == "null") {
      return true;
    } else {
      return false;
    }
  }

  ///将字符串日期中的“T”替换成空格
  static strDateDeleteT(String value) {
    if (!strIsEmpty(value)) {
      if (value.contains("T")) {
        return value.replaceAll("T", " ");
      } else {
        return value;
      }
    }
    return "";
  }

  ///将字符串日期中的“T”替换成空格
  static strDateOnly(String value) {
    if (!strIsEmpty(value)) {
      if (value.contains("T")) {
        return value.split("T")[0];
      } else if (value.length > 10) {
        return value.substring(0, 10);
      } else {
        return value;
      }
    }
    return "";
  }

  /// 计算分页总页数
  /// @param count    总条数
  /// @param pageSize 一页几条
  /// @return
  static int totalPage(int? count, int? pageSize) {
    //向上取整（返回int）
    var pageTotle = (count! / pageSize!).ceil();
    return pageTotle;
  }

  ///11 位数字 1 开头或6 位-20 位数字字母组合
  static bool isValidLoginName(String input) {
    RegExp regex =
        RegExp(r'^(1\d{10}|(?![0-9]+$)(?![a-zA-Z]+$)[0-9a-zA-Z]{6,20})$');
    return regex.hasMatch(input);
  }

  ///字母+数字组合和纯字母，大于等于 6
  static bool isValidName(String input) {
    RegExp regex = RegExp(r'^[a-zA-Z0-9]{6,20}$');
    return regex.hasMatch(input);
  }

  ///字母+数字组合和纯字母，大于等于 6
  static bool isValidPassword(String input) {
    RegExp regex = RegExp(
        r'^(?![A-Za-z0-9]+$)(?![a-z0-9_@#*.]+$)(?![A-Za-z_@#*.]+$)(?![A-Z0-9_@#*.]+$)[a-zA-Z0-9_@#*.]{8,20}$');
    return regex.hasMatch(input);
  }
}
