import 'dart:convert';

import 'package:get_storage/get_storage.dart';
import 'package:special_equipment_flutter/model/user_bo.dart';
import 'package:special_equipment_flutter/utils/string_utils.dart';

class SpKeys {
  static const USER_NAME = "spUserName";
  static const PASSWORD = "spPassword";
  static const NAME = "spName";
  static const JSESSION_ID = "spJsessionId";
  static const USER_ID = "spUserId";
  static const OFFICE_ID = "spOfficeId";
  static const OFFICE_NAME = "spOfficeName";
  static const OFFICE_TYPE = "spOfficeType";
  static const ROLE_NAMES = "spRoleNames";

  static const VERSION_CODE = "spVersionCode";

  ///切换单位状态
  static const UNIT_STATUS = "unitStatus";

  ///拍照位置
  static const CAMERA_ADDRESS = "camera_address";

  static const ACCOUNT_NUMBER = "account_number";
  static const ACCOUNT = "account";
  static const PASSWORDS = "password";
}

class StorageUtil {
  static StorageUtil? _singleton;
  GetStorage? _box;

  /// 获取单例对象
  static StorageUtil getInstance() {
    _singleton ??= StorageUtil._();
    return _singleton!;
  }

  StorageUtil._();

  /// 初始化GetStorge
  Future<void> init() async {
    await GetStorage.init();
    _box = GetStorage();
  }

  /// 存储数据
  void set(String key, var value) {
    _box?.write(key, value);
  }

  // void setUnitList(String key, List<Unit> list) {
  //   _box?.write(key, list);
  // }

  // List<Unit> getUnitList() {
  //   return _box?.read(SpKeys.UNIT_LIST);
  // }

  /// 读取数据
  dynamic get(String key) {
    return _box?.read(key);
  }

  /// 删除数据
  void remove(String key) {
    _box?.remove(key);
  }

  /// 删除所有数据
  void clearAll() {
    _box?.erase();
  }

  /// 检查数据是否存在
  hasData(String key) {
    return _box?.hasData(key) ?? false;
  }

  T getUserName<T>() {
    var userId = get(SpKeys.USER_NAME);
    return userId;
  }

  T getPassword<T>() {
    var password = get(SpKeys.PASSWORD);
    return password;
  }

  T getName<T>() {
    var nickName = get(SpKeys.NAME);
    return nickName;
  }

  T getJsessionId<T>() {
    var userName = get(SpKeys.JSESSION_ID);
    return userName;
  }

  T getUserId<T>() {
    var userId = get(SpKeys.USER_ID);
    return userId;
  }

  T getOfficeName<T>() {
    var userName = get(SpKeys.OFFICE_NAME);
    return userName;
  }

  T getOfficeType<T>() {
    var officeType = get(SpKeys.OFFICE_TYPE);
    return officeType;
  }

  T getOfficeId<T>() {
    var userName = get(SpKeys.OFFICE_ID);
    return userName;
  }

  T getVersionCode<T>() {
    var versionCode = get(SpKeys.VERSION_CODE);
    return versionCode;
  }

  T getUnitStatus<T>() {
    var unitStatus = get(SpKeys.UNIT_STATUS);
    return unitStatus;
  }

  T getRoleNames<T>() {
    var roleNames = get(SpKeys.ROLE_NAMES);
    return roleNames;
  }

  T getCameraAddress<T>() {
    var cameraAddress = get(SpKeys.CAMERA_ADDRESS);
    return cameraAddress ?? '';
  }

  bool isLogin() {
    if (!StringUtils.isEmpty(getJsessionId())) {
      return true;
    } else {
      return false;
    }
  }

  ///删掉单个账号
  // delUser(UserBo user) {
  //   List<UserBo> list = getUsers();
  //   list.remove(user);
  //   saveUsers(list);
  // }

  ///保存账号，如果重复，就将最近登录账号放在第一个
  saveUser(UserBo user) {
    List<UserBo>? userList = get(SpKeys.ACCOUNT_NUMBER);
    userList ??= [];
    bool isFlag = true;
    for (int i = 0; i < userList.length; i++) {
      if (userList[i].account == user.account) {
        userList.removeAt(i);
        isFlag = false;
      }
    }
    if (isFlag) {
      userList.add(user);
    } else {
      userList.insert(0, user);
    }
    set(SpKeys.ACCOUNT_NUMBER, userList);
  }

  getUserList<T>() {
    List<UserBo>? userList = get(SpKeys.ACCOUNT_NUMBER);
    userList ??= [];

    return userList;
  }
}
