// ignore_for_file: constant_identifier_names

import 'dart:convert';

import 'package:shared_preferences/shared_preferences.dart';
import 'package:special_equipment_flutter/utils/string_utils.dart';

class SKeys {
  static const USER_NAME = "spUserName";
  static const NAME = "spName";
  static const JSESSION_ID = "spJsessionId";
  static const USER_ID = "spUserId";
  static const OFFICE_ID = "spOfficeId";
  static const OFFICE_NAME = "spOfficeName";
  static const OFFICE_TYPE = "spOfficeType";
  static const ROLE_NAMES = "spRoleNames";

  static const VERSION_CODE = "spVersionCode";

  ///切换单位状态
  static const UNIT_STATUS = "unitStatus";
  static const UNIT_LIST = "unitList";
}

class SPUtil {
  //创建工厂方法
  static SPUtil? _instance;

  factory SPUtil() => _instance ??= SPUtil._initial();
  SharedPreferences? _preferences;

  static Future inits() async {
    await SPUtil.perInit();
  }

  //创建命名构造函数
  SPUtil._initial() {
    //为什么在这里需要新写init方法 主要是在命名构造中不能使用async/await
    init();
  }

  //初始化SharedPreferences
  void init() async {
    _preferences ??= await SharedPreferences.getInstance();
  }

  //到这里还没有完 有时候会遇到使用时提示 SharedPreferences 未初始化,所以还需要提供一个static 的方法
  static Future<SPUtil?> perInit() async {
    if (_instance == null) {
      //静态方法不能访问非静态变量所以需要创建变量再通过方法赋值回去
      SharedPreferences preferences = await SharedPreferences.getInstance();
      _instance = SPUtil._pre(preferences);
    }
    return _instance;
  }

  SPUtil._pre(SharedPreferences prefs) {
    _preferences = prefs;
  }

  ///设置String类型的
  void setString(key, value) {
    _preferences?.setString(key, value);
  }

  ///设置setStringList类型的
  void setStringList(key, value) {
    _preferences?.setStringList(key, value);
  }

  ///设置setBool类型的
  void setBool(key, value) {
    _preferences?.setBool(key, value);
  }

  ///设置setDouble类型的
  void setDouble(key, value) {
    _preferences?.setDouble(key, value);
  }

  ///设置setInt类型的
  void setInt(key, value) {
    _preferences?.setInt(key, value);
  }

//  ///存储Json类型的
//  void setJson(key, value) {
//    value = jsonEncode(value);
//    _preferences?.setString(key, value);
//  }

  ///通过泛型来获取数据
  T? get<T>(key) {
    var result = _preferences?.get(key);
    if (result != null) {
      return result as T;
    }
    return null;
  }

  ///获取JSON
//  Map<String, dynamic>? getJson(key) {
//    String? result = _preferences?.getString(key);
//    if (StringUtil.isNotEmpty(result)) {
//      return jsonDecode(result!);
//    }
//    return null;
//  }

  ///移除某一个
  void remove(key) {
    _preferences?.remove(key);
  }

  T getUserName<T>() {
    var userId = get(SKeys.USER_NAME);
    return userId;
  }

  T getName<T>() {
    var nickName = get(SKeys.NAME);
    return nickName;
  }

  T getJsessionId<T>() {
    var userName = get(SKeys.JSESSION_ID);
    return userName;
  }

  T getUserId<T>() {
    var userId = get(SKeys.USER_ID);
    return userId;
  }

  T getOfficeName<T>() {
    var userName = get(SKeys.OFFICE_NAME);
    return userName;
  }

  T getOfficeId<T>() {
    var userName = get(SKeys.OFFICE_ID);
    return userName;
  }

//  T getOfficeType<T>() {
//    var userName = get(SKeys.OFFICE_TYPE);
//    return userName;
//  }

  T getVersionCode<T>() {
    var versionCode = get(SKeys.VERSION_CODE);
    return versionCode;
  }

  T getUnitStatus<T>() {
    var unitStatus = get(SKeys.UNIT_STATUS);
    return unitStatus;
  }

  T getUnitList<T>() {
    var unitList = json.decode(get(SKeys.UNIT_LIST));
    return unitList;
  }

  bool isLogin() {
    if (!StringUtils.isEmpty(getJsessionId())) {
      return true;
    } else {
      return false;
    }
  }

  ///清除本地所有存储数据
  void clearAll() {
    _preferences?.clear();
  }
}
