import 'package:flutter/material.dart';
import 'package:permission_handler/permission_handler.dart';

Future<bool?> checkCameraPermission(context) async {
  var camera = await Permission.camera.status;
  var storage = await Permission.storage.status;

  ///判断摄像头权限是否已开启
  if (!camera.isGranted) {
    /// 如果未开启摄像头权限则弹出提示框
    showDialog(
        context: context,
        builder: (BuildContext context) {
          return AlertDialog(
            title: const Text('摄像头权限被禁用'),
            content: const SingleChildScrollView(
              child: ListBody(
                children: <Widget>[
                  Text('请在系统设置中允许使用摄像头权限'),
                ],
              ),
            ),
            actions: <Widget>[
              TextButton(
                child: const Text('去设置'),
                onPressed: () {
                  //跳转到应用设置页面
                  openAppSettings();
                },
              ),
            ],
          );
        });
  }else{
    return true;
  }
}
