// ignore_for_file: unnecessary_null_comparison

import 'package:flutter/cupertino.dart';

class CacheUtils {
  ///加载缓存
  static Future<String> loadCache() async {
    ImageCache imageCache = PaintingBinding.instance.imageCache;
    int value = imageCache.currentSizeBytes;
    return computeFileCount(value);
  }

  static Future<void> clearCache() async {
    ImageCache imageCache = PaintingBinding.instance.imageCache;
    imageCache.clear();
    return;
  }

  static String computeFileCount(int value) {
    if (value == null) {
      return '';
    }
    if (value >= 1024 && value < 1024 * 1024) {
      return "${(value.toDouble() / 1024).toStringAsFixed(2)}K";
    } else if (value >= 1024 * 1024) {
      return "${(value.toDouble() / (1024 * 1024)).toStringAsFixed(2)}M";
    } else {
      return "${value.toStringAsFixed(2)}K";
    }
  }
}
