import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/model/equipment_bo.dart';
import 'package:special_equipment_flutter/model/office_device.dart';

///用户设置：安全总监【使用单位】、【生产单位】设备列表
class GridViewAQZJList extends StatefulWidget {
  List<OfficeDtoLists>? equipmentSYBoList, equipmentSCBoList;
  bool? isVisbliy;
  Function(int index)? onTap;

  GridViewAQZJList(
      {super.key,
      this.isVisbliy,
      this.equipmentSYBoList,
      this.equipmentSCBoList,
      this.onTap});

  @override
  State<GridViewAQZJList> createState() => _GridViewAQZJListState();
}

class _GridViewAQZJListState extends State<GridViewAQZJList> {
  List<OfficeDtoLists>? equipmentSYBoList = [];
  List<OfficeDtoLists>? equipmentSCBoList = [];

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    equipmentSYBoList = widget.equipmentSYBoList;
    equipmentSCBoList = widget.equipmentSCBoList;
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        color: Colors.grey[100],
        borderRadius: BorderRadius.circular(5.0),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          if (widget.isVisbliy!) ...[
            if (equipmentSYBoList!.isNotEmpty) ...[
              Container(
                // padding: const EdgeInsets.only(top: 5),
                margin: const EdgeInsets.only(top: 5),
                decoration: BoxDecoration(
                  color: Colors.grey[100],
                  borderRadius: BorderRadius.circular(5.0),
                ),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Container(
                        margin: const EdgeInsets.only(left: 10, right: 10),
                        child: const Text('使用单位',
                            style: TextStyle(fontWeight: FontWeight.bold))),
                    GridView.builder(
                      itemCount: equipmentSYBoList!.length,
                      shrinkWrap: true,
                      physics: const NeverScrollableScrollPhysics(),
                      padding: const EdgeInsets.only(
                          top: 10, left: 5, right: 5, bottom: 10),
                      gridDelegate:
                          const SliverGridDelegateWithFixedCrossAxisCount(
                              crossAxisCount: 3, // 每行显示的列数
                              crossAxisSpacing: 3.0, // 列之间的间距
                              childAspectRatio: 2 / 0.5,
                              mainAxisSpacing: 8.0 // 行之间的间距
                              ),
                      itemBuilder: (BuildContext context, int index) {
                        return GestureDetector(
                          // 点击每个Grid Item时切换选中状态
                          onTap: () {
                            setState(() {
                              equipmentSYBoList![index].isChecked =
                                  !equipmentSYBoList![index].isChecked!;
                            });
                          },
                          child: Container(
                            decoration: BoxDecoration(
                              color: equipmentSYBoList![index].isChecked!
                                  ? Colors.blue[50]
                                  : Colors.transparent,
                              border: Border.all(
                                  color: equipmentSYBoList![index].isChecked!
                                      ? Colors.blue
                                      : ColorConst.greyD2Color,
                                  width: 1),
                              borderRadius: BorderRadius.circular(3),
                            ),
                            alignment: Alignment.center,
                            child: Text(
                              equipmentSYBoList![index].name!,
                              style: TextStyle(
                                  fontSize: 12,
                                  color: equipmentSYBoList![index].isChecked!
                                      ? Colors.blue
                                      : Colors.black),
                            ),
                          ),
                        );
                      },
                    ),
                  ],
                ),
              )
            ],
            if (equipmentSCBoList!.isNotEmpty) ...[
              Container(
                padding: const EdgeInsets.only(top: 5),
                margin: const EdgeInsets.only(top: 0),
                decoration: BoxDecoration(
                  color: Colors.grey[100],
                  borderRadius: BorderRadius.circular(5.0),
                ),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Container(
                        margin: const EdgeInsets.only(left: 10, right: 10),
                        child: const Text('生产单位',
                            style: TextStyle(fontWeight: FontWeight.bold))),
                    GridView.builder(
                      itemCount: equipmentSCBoList!.length,
                      shrinkWrap: true,
                      physics: const NeverScrollableScrollPhysics(),
                      padding: const EdgeInsets.only(
                          top: 10, left: 5, right: 5, bottom: 10),
                      gridDelegate:
                          const SliverGridDelegateWithFixedCrossAxisCount(
                              crossAxisCount: 3, // 每行显示的列数
                              crossAxisSpacing: 2, // 列之间的间距
                              childAspectRatio: 2 / 0.5,
                              mainAxisSpacing: 8.0 // 行之间的间距
                              ),
                      itemBuilder: (BuildContext context, int index) {
                        return GestureDetector(
                          // 点击每个Grid Item时切换选中状态
                          onTap: () {
                            setState(() {
                              equipmentSCBoList![index].isChecked =
                                  !equipmentSCBoList![index].isChecked!;
                            });
                          },
                          child: Container(
                            decoration: BoxDecoration(
                              color: equipmentSCBoList![index].isChecked!
                                  ? Colors.orange[50]
                                  : Colors.transparent,
                              border: Border.all(
                                  color: equipmentSCBoList![index].isChecked!
                                      ? Colors.orange
                                      : ColorConst.greyD2Color,
                                  width: 1),
                              borderRadius: BorderRadius.circular(3),
                            ),
                            alignment: Alignment.center,
                            child: Text(
                              equipmentSCBoList![index].name!,
                              style: TextStyle(
                                  fontSize: 12,
                                  color: equipmentSCBoList![index].isChecked!
                                      ? Colors.orange
                                      : Colors.black),
                            ),
                          ),
                        );
                      },
                    ),
                  ],
                ),
              )
            ]
          ],
        ],
      ),
    );
  }
}
