import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/model/equipment_bo.dart';
import 'package:special_equipment_flutter/model/office_device.dart';

///设备选择列表
class EquipmentGridViewList extends StatefulWidget {
  List<OfficeDtoLists>? equipmentSYBoList, equipmentSCBoList;
  bool? isSYVisbliy, isSCVisbliy;
  Function(int index)? onTap;

  EquipmentGridViewList(
      {super.key,
      this.isSYVisbliy,
      this.isSCVisbliy,
      this.equipmentSYBoList,
      this.equipmentSCBoList,
      this.onTap});

  @override
  State<EquipmentGridViewList> createState() => _EquipmentGridViewListState();
}

class _EquipmentGridViewListState extends State<EquipmentGridViewList> {
  List<OfficeDtoLists>? equipmentSYBoList = [];
  List<OfficeDtoLists>? equipmentSCBoList = [];

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    equipmentSYBoList = widget.equipmentSYBoList;
    equipmentSCBoList = widget.equipmentSCBoList;
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        if (widget.isSYVisbliy!) ...[
          Container(
            padding: const EdgeInsets.only(top: 5),
            margin: const EdgeInsets.only(top: 0),
            decoration: BoxDecoration(
              color: Colors.grey[100],
              borderRadius: BorderRadius.circular(5.0),
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Container(
                    margin: const EdgeInsets.only(left: 10, right: 10),
                    child: const Text('使用单位',
                        style: TextStyle(
                            fontSize: 14,
                            color: Colors.black,
                            fontWeight: FontWeight.bold))),
                GridView.builder(
                  itemCount: equipmentSYBoList!.length,
                  shrinkWrap: true,
                  physics: const NeverScrollableScrollPhysics(),
                  padding: const EdgeInsets.only(
                      top: 10, left: 5, right: 5, bottom: 10),
                  gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
                      crossAxisCount: 3, // 每行显示的列数
                      crossAxisSpacing: 3.0, // 列之间的间距
                      childAspectRatio: 2 / 0.5,
                      mainAxisSpacing: 8.0 // 行之间的间距
                      ),
                  itemBuilder: (BuildContext context, int index) {
                    return GestureDetector(
                      // 点击每个Grid Item时切换选中状态
                      onTap: () {
                        setState(() {
                          equipmentSYBoList![index].isChecked =
                              !equipmentSYBoList![index].isChecked!;
                        });
                      },
                      child: Container(
                        decoration: BoxDecoration(
                          color: equipmentSYBoList![index].isChecked!
                              ? Colors.blue[50]
                              : Colors.transparent,
                          border: Border.all(
                              color: equipmentSYBoList![index].isChecked!
                                  ? Colors.blue
                                  : ColorConst.greyD2Color,
                              width: 1),
                          borderRadius: BorderRadius.circular(3),
                        ),
                        alignment: Alignment.center,
                        child: Text(
                          equipmentSYBoList![index].name!,
                          style: TextStyle(
                              fontSize: 12,
                              color: equipmentSYBoList![index].isChecked!
                                  ? Colors.blue
                                  : Colors.black),
                        ),
                      ),
                    );
                  },
                ),
              ],
            ),
          )
        ],
        if (widget.isSCVisbliy!) ...[
          Container(
            padding: const EdgeInsets.only(top: 5),
            margin: const EdgeInsets.only(top: 10),
            decoration: BoxDecoration(
              color: Colors.grey[100],
              borderRadius: BorderRadius.circular(5.0),
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Container(
                    margin: const EdgeInsets.only(left: 10, right: 10),
                    child: const Text('生产单位',
                        style: TextStyle(
                            fontSize: 14,
                            color: Colors.black,
                            fontWeight: FontWeight.bold))),
                GridView.builder(
                  itemCount: equipmentSCBoList!.length,
                  shrinkWrap: true,
                  physics: const NeverScrollableScrollPhysics(),
                  padding: const EdgeInsets.only(
                      top: 10, left: 5, right: 5, bottom: 10),
                  gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
                      crossAxisCount: 3, // 每行显示的列数
                      crossAxisSpacing: 2, // 列之间的间距
                      childAspectRatio: 2 / 0.5,
                      mainAxisSpacing: 8.0 // 行之间的间距
                      ),
                  itemBuilder: (BuildContext context, int index) {
                    return GestureDetector(
                      // 点击每个Grid Item时切换选中状态
                      onTap: () {
                        setState(() {
                          equipmentSCBoList![index].isChecked =
                              !equipmentSCBoList![index].isChecked!;
                        });
                      },
                      child: Container(
                        decoration: BoxDecoration(
                          color: equipmentSCBoList![index].isChecked!
                              ? Colors.orange[50]
                              : Colors.transparent,
                          border: Border.all(
                              color: equipmentSCBoList![index].isChecked!
                                  ? Colors.orange
                                  : ColorConst.greyD2Color,
                              width: 1),
                          borderRadius: BorderRadius.circular(3),
                        ),
                        alignment: Alignment.center,
                        child: Text(
                          equipmentSCBoList![index].name!,
                          style: TextStyle(
                              fontSize: 12,
                              color: equipmentSCBoList![index].isChecked!
                                  ? Colors.orange
                                  : Colors.black),
                        ),
                      ),
                    );
                  },
                ),
              ],
            ),
          )
        ]
      ],
    );
  }
}
