import 'package:flutter/material.dart';
import 'package:flutter_easyrefresh/easy_refresh.dart';
import 'package:special_equipment_flutter/common/edgeInsets_const.dart';
import 'package:special_equipment_flutter/dio/http_utils.dart';
import 'package:special_equipment_flutter/model/device_list_bo.dart';
import 'package:special_equipment_flutter/ui/common/data.dart';
import 'package:special_equipment_flutter/widgets/divider_custom.dart';
import 'package:special_equipment_flutter/widgets/emptyI_img_widget.dart';
import 'package:special_equipment_flutter/widgets/first_refresh_widget.dart';

///设备列表(生产单位)
class EquipmentListSCPage extends StatefulWidget {
  const EquipmentListSCPage({super.key});

  @override
  State<EquipmentListSCPage> createState() => _EquipmentListSCPageState();
}

class _EquipmentListSCPageState extends State<EquipmentListSCPage> {
  final EasyRefreshController _controller = EasyRefreshController();
  List<Data> list = [];

  @override
  void initState() {
    super.initState();
    getData();
  }

  void getData() {
    ///生产单位
    HttpUtils.doDeviceList(context, '1', '2', onSuccess: (value) {
      DeviceListBo deviceListBo = value;
      if (mounted) {
        setState(() {
          list.clear();
          list.addAll(deviceListBo.data!);
          _controller.finishRefresh();
        });
      }
    });

    // HttpUtils.getSCDeviceList(context, '1', '2').then((value) {
    //   ScDeviceListBo listBo = value;
    //   if (mounted) {
    //     setState(() {
    //       list.clear();
    //       list.addAll(listBo.body!.data!);
    //       _controller.finishRefresh();
    //     });
    //   }
    // });
  }

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        Container(
          margin: EdgeInsets.only(top: 20),
          child: EasyRefresh(
            firstRefresh: true,
            enableControlFinishRefresh: true,
            // enableControlFinishLoad: true,
            firstRefreshWidget: const FirstRefreshWidget(),

            emptyWidget: list.isEmpty
                ? EmptyImgWidget(
                    title: '暂无数据,点击刷新',
                    onTap: () {
                      getData();
                    })
                : null,
            controller: _controller,
            onRefresh: () async {
              // page = 1;
              getData();
            },
//                onLoad: () async {
//                  page++;
//                  getList();
//                },
            child: buildBody(),
          ),
        ),
        Container(
          alignment: Alignment.centerLeft,
          height: 25,
          margin: const EdgeInsets.only(left: 10, right: 10, top: 5),
          padding: const EdgeInsets.only(left: 5, right: 5, top: 3, bottom: 3),
          decoration: BoxDecoration(
            color: Colors.orange[50],
            borderRadius: const BorderRadius.only(
                topLeft: Radius.circular(5),
                topRight: Radius.circular(5),
                bottomLeft: Radius.circular(5),
                bottomRight: Radius.circular(5)),
          ),
          child: const Text(
            softWrap: true,
            '小提示：生产单位无需【新建设备】.',
            style: TextStyle(color: Colors.orange, fontSize: 12),
          ),
        ),
      ],
    );
  }

  ListView buildBody() {
    return ListView.separated(
      shrinkWrap: true,
      padding: const EdgeInsets.symmetric(
          horizontal: EdgeInsetsConst.padding_horizontal),
      physics: const NeverScrollableScrollPhysics(),
      itemBuilder: (BuildContext context, int index) {
        return buildItem(index, context);
      },
      itemCount: list.length,
      separatorBuilder: (BuildContext context, int index) {
        return const SizedBox(
          height: 0,
        );
      },
    );
  }

  GestureDetector buildItem(int index, BuildContext context) {
    return GestureDetector(
        onTap: () {},
        child: Card(
          elevation: 3,
          margin: const EdgeInsets.only(left: 0, right: 0, top: 15, bottom: 0),
          color: Colors.white,
          shape: const RoundedRectangleBorder(
            borderRadius: BorderRadius.all(Radius.circular(5)),
          ),
          child: Padding(
            padding: const EdgeInsets.all(10.0),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Row(
                  children: [
                    Container(
                      // margin: const EdgeInsets.fromLTRB(0, 10, 0, 0),
                      padding: const EdgeInsets.fromLTRB(10, 1, 10, 2),
                      decoration: BoxDecoration(
                        color: typeColor(list[index]!.name!),
                        borderRadius: const BorderRadius.only(
                            topLeft: Radius.circular(10),
                            topRight: Radius.circular(3),
                            bottomLeft: Radius.circular(3),
                            bottomRight: Radius.circular(10)),
                      ),
                      child: Text(list[index].name!,
                          style: const TextStyle(
                              fontSize: 13, color: Colors.white)),
                    ),
                    Container(
                      margin: const EdgeInsets.only(left: 10),
                      child: const Text('',
                          style: TextStyle(
                              fontSize: 16,
                              color: Colors.black,
                              fontWeight: FontWeight.bold)),
                    )
                  ],
                ),
                DividerCustom(Colors.grey[400], 10, 0, 0, 0),
                Container(
                  margin: const EdgeInsets.only(top: 5),
                  child: Row(
                    children: [
                      Container(
                          margin: const EdgeInsets.only(top: 3, right: 2),
                          child: const Icon(Icons.cloud_done,
                              size: 14, color: Colors.black38)),
                      Text.rich(TextSpan(children: [
                        const TextSpan(
                            text: '类型状态：',
                            style:
                                TextStyle(fontSize: 13, color: Colors.black87)),
                        TextSpan(
                            text: list[index].curType == '1' ? '停产' : '正常',
                            style: TextStyle(
                                fontSize: 13,
                                color: list[index].curType == '1'
                                    ? Colors.red
                                    : Colors.grey)),
                      ])),
                    ],
                  ),
                ),
                Container(
                  margin: const EdgeInsets.only(top: 5),
                  child: Row(
                    children: [
                      Container(
                          margin: const EdgeInsets.only(top: 3, right: 2),
                          child: const Icon(Icons.date_range,
                              size: 14, color: Colors.black38)),
                      Text.rich(TextSpan(children: [
                        const TextSpan(
                            text: '日管控初始时间：',
                            style:
                                TextStyle(fontSize: 13, color: Colors.black87)),
                        TextSpan(
                            text: list[index].dayBeginDate,
                            style: TextStyle(
                                fontSize: 13,
                                color: list[index].curType == '1'
                                    ? Colors.red
                                    : Colors.black54)),
                      ])),
                    ],
                  ),
                ),
                Container(
                  margin: const EdgeInsets.only(top: 5),
                  child: Row(
                    children: [
                      Container(
                          margin: const EdgeInsets.only(top: 3, right: 2),
                          child: const Icon(Icons.date_range,
                              size: 14, color: Colors.black38)),
                      Text.rich(TextSpan(children: [
                        const TextSpan(
                            text: '周排查初始时间：',
                            style:
                                TextStyle(fontSize: 13, color: Colors.black87)),
                        TextSpan(
                            text: list[index].weekBeginDate,
                            style: TextStyle(
                                fontSize: 13,
                                color: list[index].curType == '1'
                                    ? Colors.red
                                    : Colors.black54)),
                      ])),
                    ],
                  ),
                ),
                Container(
                  margin: const EdgeInsets.only(top: 5),
                  child: Row(
                    children: [
                      Container(
                          margin: const EdgeInsets.only(top: 3, right: 2),
                          child: const Icon(Icons.date_range,
                              size: 14, color: Colors.black38)),
                      Text.rich(TextSpan(children: [
                        const TextSpan(
                            text: '月调度初始时间：',
                            style:
                                TextStyle(fontSize: 13, color: Colors.black87)),
                        TextSpan(
                            text: list[index].monthBeginDate,
                            style: TextStyle(
                                fontSize: 13,
                                color: list[index].curType == '1'
                                    ? Colors.red
                                    : Colors.black54)),
                      ])),
                    ],
                  ),
                ),
              ],
            ),
          ),
        ));
  }
}
