// ignore_for_file: prefer_typing_uninitialized_variables, must_be_immutable, avoid_types_as_parameter_names

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/dio/http_utils.dart';
import 'package:special_equipment_flutter/model/office_device.dart';
import 'package:special_equipment_flutter/ui/unit/equipment/sc_equipment_list_page.dart';
import 'package:special_equipment_flutter/ui/unit/equipment/sy_equipment_list_page.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';
import 'package:special_equipment_flutter/widgets/app_bar/custom_app_bar.dart';

/// 设备设置 tabs
class EquipmentTabPage extends StatefulWidget {
  var arguments = Get.arguments;

  EquipmentTabPage({super.key});

  @override
  State<EquipmentTabPage> createState() => _EquipmentTabPageState();
}

class _EquipmentTabPageState extends State<EquipmentTabPage> {
  var type = [];

  @override
  void initState() {
    super.initState();
    type = widget.arguments;
    // type = StorageUtil.getInstance().getOfficeType().toString().split(',');
    // getData();
  }

  // getData() async {
  // HttpUtils.getOfficeDevice(context).then((value) {
  //   if (value != null) {
  //     OfficeDevice officeDeviceItem = value;
  //     setState(() {
  //       type = officeDeviceItem!.office!.type!.split(',');
  //     });
  //   }
  // });
  // }

  @override
  Widget build(BuildContext context) {
    return buildDefaultTabController();
  }

  DefaultTabController buildDefaultTabController() {
    return DefaultTabController(
      length: type.length,
      child: Scaffold(
        appBar: AppBarCustom(text: '设备设置', height: 100, bottom: tabBar()),
        body: GestureDetector(
          child: TabBarView(
            children: [
              if (type.length == 2) ...[
                const EquipmentListSYPage(),
                const EquipmentListSCPage(),
              ] else ...[
                if (type[0] == '1') ...[
                  const EquipmentListSYPage(),
                ],
                if (type[0] == '2') ...[
                  const EquipmentListSCPage(),
                ]
              ],
            ],
          ),
        ),
      ),
    );
  }

  TabBar tabBar() {
    return TabBar(
      unselectedLabelColor: ColorConst.whiteColor,
      unselectedLabelStyle:
          TextStyle(fontWeight: FontWeight.normal, fontSize: 14),
      labelColor: ColorConst.whiteColor,
      labelStyle: TextStyle(fontWeight: FontWeight.bold, fontSize: 16),
      labelPadding: EdgeInsets.only(left: 35, right: 35, top: 0, bottom: 0),
      isScrollable: true,
      padding: EdgeInsets.all(0.0),
      indicatorWeight: 3,
      indicatorPadding: EdgeInsets.all(8.0),
      indicatorSize: TabBarIndicatorSize.label,
      tabs: [
        if (type.length == 2) ...[
          const Tab(
            child: Align(
              alignment: Alignment.center,
              child: Text('使用单位'),
            ),
          ),
          const Tab(
            child: Align(
              alignment: Alignment.center,
              child: Text('生产单位'),
            ),
          ),
        ] else ...[
          if (type[0] == '1') ...[
            const Tab(
              child: Align(
                alignment: Alignment.center,
                child: Text('使用单位'),
              ),
            ),
          ],
          if (type[0] == '2') ...[
            const Tab(
              child: Align(
                alignment: Alignment.center,
                child: Text('生产单位'),
              ),
            ),
          ]
        ],
      ],
    );
  }
}
