// ignore_for_file: prefer_typing_uninitialized_variables, must_be_immutable, avoid_types_as_parameter_names

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/dio/http_utils.dart';
import 'package:special_equipment_flutter/model/count_bo.dart';
import 'package:special_equipment_flutter/ui/sy/list/test_inspect_list_sy_page.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';

import '../../widgets/app_bar/custom_app_bar.dart';
import 'list/completed_list_sy_page.dart';
import 'list/inspect_list_sy_page.dart';
import 'list/risk_list_sy_page.dart';

/// 使用单位 tabs
class SyTabPage extends StatefulWidget {
  SyTabPage({Key? key}) : super(key: key);

  ///区分  日管控、周排查、月调度
  var args = Get.arguments;

  @override
  State<SyTabPage> createState() => _SyTabPageState();
}

class _SyTabPageState extends State<SyTabPage> {
  var titleName, num1, num2, num3, type, unitStatus, tabIndex;

  @override
  void initState() {
    super.initState();
    titleName = widget.args['titleName'];
    type = widget.args['type'];
    tabIndex = widget.args['tabIndex'];
    unitStatus = StorageUtil.getInstance().getUnitStatus();
    getData();
  }

  void getData() {
    switch (type) {
      case '1':
        getDayData();
        break;
      case '2':
        getWeekData();
        break;
      case '3':
        getMonthData();
        break;
    }
  }

  @override
  Widget build(BuildContext context) {
    return buildDefaultTabController();
  }

  DefaultTabController buildDefaultTabController() {
    return DefaultTabController(
      length: 3,
      initialIndex: tabIndex,
      //配置顶部tab的数量
      child: WillPopScope(
        onWillPop: () async {
          Get.back(result: true);
          return true; // 控制是否可以侧滑返回，true为允许，false为不允许
        },
        child: Scaffold(
          appBar: AppBarCustom(
            text: titleName,
            height: 100,
            bottom: tabBar(titleName),
          ),
          body: TabBarView(
            children: [
              // 将处理数据的方法作为参数传递给子组件
              InspectListSyPage(widget.args, onDataChanged: (data) {
                setState(() {
                  num1 = data;
                });
              }),
              // TestInspectListSyPage(widget.args, onDataChanged: (data) {
              //   setState(() {
              //     num1 = data;
              //   });
              // }),
              RiskListSyPage(widget.args, onDataChanged: (data) {
                setState(() {
                  num2 = data;
                });
              }),

              CompletedListSyPage(widget.args, onDataChanged: (data) {
                setState(() {
                  num3 = data;
                });
              }),
            ],
          ),
        ),
      ),
    );
  }

  ///日管控、风险整改、已完成列表
  void getDayData() {
    HttpUtils.doCount(context, '0', '1').then((value) {
      CountBo countBo = value;
      if (mounted) {
        setState(() {
          num1 = countBo.userAllTaskDayCount.toString();
        });
      }
    });
    HttpUtils.doCount(context, '2', '1').then((value) {
      CountBo countBo = value;
      if (mounted) {
        setState(() {
          num2 = countBo.userAllTaskDayCount.toString();
        });
      }
    });
  }

  ///周排查、风险整改、已完成
  void getWeekData() {
    HttpUtils.doCount(context, '0', '2').then((value) {
      CountBo countBo = value;
      if (mounted) {
        setState(() {
          num1 = countBo.userAllTaskWeekCount.toString();
        });
      }
    });
    HttpUtils.doCount(context, '2', '2').then((value) {
      CountBo countBo = value;
      if (mounted) {
        setState(() {
          num2 = countBo.userAllTaskWeekCount.toString();
        });
      }
    });
  }

  ///月调度、风险整改、已完成
  void getMonthData() {
    HttpUtils.doCount(context, '0', '3').then((value) {
      CountBo countBo = value;
      if (mounted) {
        setState(() {
          num1 = countBo.userAllTaskMonthCount.toString();
        });
      }
    });
    HttpUtils.doCount(context, '2', '3').then((value) {
      CountBo countBo = value;
      if (mounted) {
        setState(() {
          num2 = countBo.userAllTaskMonthCount.toString();
        });
      }
    });
  }

  TabBar tabBar(titleName) {
    return TabBar(
      unselectedLabelColor: ColorConst.whiteColor,
      unselectedLabelStyle:
          const TextStyle(fontWeight: FontWeight.normal, fontSize: 14),
      labelColor: ColorConst.whiteColor,
      labelStyle: const TextStyle(fontWeight: FontWeight.bold, fontSize: 16),
      labelPadding:
          const EdgeInsets.only(left: 30, right: 30, top: 0, bottom: 0),
      isScrollable: true,
      padding: const EdgeInsets.all(0.0),
      indicatorWeight: 3,
      indicatorPadding: const EdgeInsets.all(8.0),
      indicatorSize: TabBarIndicatorSize.label,
      tabs: [
        Tab(
          child: Stack(
            alignment: Alignment.topRight,
            children: [
              Align(
                alignment: Alignment.center,
                child: Text(' $titleName '),
              ),
              badge(num1 ?? '0')
            ],
          ),
        ),
        Tab(
          child: Stack(
            alignment: Alignment.topRight,
            children: [
              const Align(
                alignment: Alignment.center,
                child: Text("  风险整改 "),
              ),
              badge(num2 ?? '0')
            ],
          ),
        ),
        const Tab(
          child: Align(
            alignment: Alignment.center,
            child: Text("已完成"),
          ),
        ),
      ],
    );
  }

  Positioned badge(num) {
    return Positioned(
      right: 0,
      top: 3,
      child: Badge(
        backgroundColor: Colors.red,
        padding: const EdgeInsets.all(3),
        isLabelVisible: true,
        label: Text(
          num,
          style: const TextStyle(fontSize: 10),
        ),
      ),
    );
  }
}
