// ignore_for_file: avoid_print, must_be_immutable, library_private_types_in_public_api, prefer_typing_uninitialized_variables

import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/common/edgeInsets_const.dart';
import 'package:special_equipment_flutter/dio/http_utils.dart';
import 'package:special_equipment_flutter/model/day_submit_bo.dart';
import 'package:special_equipment_flutter/model/detail/week/task_week_check_dto_list.dart';
import 'package:special_equipment_flutter/model/detail/week/week_detail_bo.dart';
import 'package:special_equipment_flutter/model/system_time.dart';
import 'package:special_equipment_flutter/model/week_submit_bo.dart';
import 'package:special_equipment_flutter/ui/common/basic_information_page.dart';
import 'package:special_equipment_flutter/ui/common/data.dart';
import 'package:special_equipment_flutter/ui/common/text_editing_controller.dart';
import 'package:special_equipment_flutter/utils/log_util.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';
import 'package:special_equipment_flutter/utils/toast_utils.dart';
import 'package:special_equipment_flutter/widgets/app_bar/custom_app_bar.dart';
import 'package:special_equipment_flutter/widgets/custom_button.dart';
import 'package:special_equipment_flutter/widgets/divider_custom.dart';
import 'package:special_equipment_flutter/widgets/number_to_chinese.dart';

class RadioModel {
  bool isSelected;
  final String text;

  RadioModel(this.isSelected, this.text);
}

///使用单位
///周排查
///风险整改提交页面
class WeekRiskSubmitSyPage extends StatefulWidget {
  ///区分  日管控、周排查、月调度
  var argsBundle = Get.arguments;

  WeekRiskSubmitSyPage({super.key});

  @override
  _WeekRiskSubmitSyPageState createState() => _WeekRiskSubmitSyPageState();
}

class _WeekRiskSubmitSyPageState extends State<WeekRiskSubmitSyPage> {
  ///type=1（日管控）type=2（周排查）type=3（月调度）
  var type, unitStatus;
  late var taskDayBo;
  List<TaskWeekCheckDtoList> taskDayCheckList = [];

  @override
  void initState() {
    super.initState();
    type = widget.argsBundle['argsData']['type'];
    taskDayBo = widget.argsBundle['listBo'];
    unitStatus = StorageUtil.getInstance().getUnitStatus();
    getData();
  }

  ///获取数据
  void getData() {
    HttpUtils.getFindRiskTaskWeekCheck(context, taskDayBo.id).then((value) {
      WeekDetailBo detailSyBo = value;
      if (mounted) {
        setState(() {
          taskDayCheckList.addAll(detailSyBo.taskWeekCheckDtoList!);
        });
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.grey[100],
      appBar: AppBarCustom(text: '风险整改', height: 50),
      body: CustomScrollView(
        shrinkWrap: true,
        slivers: <Widget>[
          SliverToBoxAdapter(
            child: Column(
              children: [
                ///注：请整改人员按要求认真整改
                buildNote(),

                ///基本信息
                buildBasicInformation(),

                ///检查项
                buildCheckItem(),

                ///提交任务
                buildSubmit(),
              ],
            ),
          ),
        ],
      ),
    );
  }

  List<RadioModel> sampleData = <RadioModel>[];

  ///检查项
  Card buildCheckItem() {
    return Card(
        color: Colors.white,
        margin: const EdgeInsets.only(left: 15, top: 0, right: 15, bottom: 0),
//          shadowColor: ColorConst.blueColor,
        elevation: 0,
        shape: const RoundedRectangleBorder(
          borderRadius: BorderRadius.all(Radius.circular(10)),
        ),
        child: Container(
          padding:
              const EdgeInsets.only(left: 10, top: 10, right: 10, bottom: 20),
          child: Column(
            children: <Widget>[
              ///标题
              buildTitle('检查项', Icons.event_note, true),

              ///提示
              Container(
                alignment: Alignment.centerLeft,
                margin: const EdgeInsets.only(left: 30),
                child: Text(
                  '注：至少选择一项风险内容进行整改',
                  style: TextStyle(fontSize: 12, color: Colors.grey[500]),
                ),
              ),

              ///分割线
              DividerCustom(Colors.grey[300], 10, 0, 20, 0),

              ///ListView在苹果手机顶部\底部出现空白间距的解决方案
              MediaQuery.removePadding(
                  context: context,
                  removeBottom: true,
                  removeTop: true,

                  ///检查项
                  child: ListView.builder(
                    shrinkWrap: true,
                    physics: const NeverScrollableScrollPhysics(),
                    padding: const EdgeInsets.only(top: 0, left: 25, bottom: 0),
                    itemCount: taskDayCheckList.length,
                    itemBuilder: (BuildContext context, int index) {
                      ///检查项item内容
                      return buildItem(index);
                    },
                  )),

              ///分割线
              const DividerCustom(Colors.grey, 15, 15, 0, 0),

              ///检查人
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  ///标题
                  buildTitle('检查人', Icons.people, true),
                  Text(
                    StorageUtil.getInstance().getName(),
                    style: const TextStyle(fontSize: 14, color: Colors.grey),
                  ),
                ],
              ),
            ],
          ),
        ));
  }

  ///检查项item内容
  Column buildItem(int index) {
    return Column(
      children: <Widget>[
        ///风险管控措施标题
        buildSeclectRiskControlMeasuresAcquiesce(index),

        ///二级列表
        ListView.builder(
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
          itemCount: taskDayCheckList[index].childTaskWeekList!.length,
          itemBuilder: (context, subIndex) {
            return Container(
              margin: const EdgeInsets.only(bottom: 5),
              decoration: BoxDecoration(
                color: taskDayCheckList[index]
                            .childTaskWeekList![subIndex]
                            .taskWeekCheck!
                            .result ==
                        '2'
                    ? ColorConst.red4BgColor
                    : ColorConst.green1Color,
                borderRadius: const BorderRadius.all(Radius.circular(5)),
//                                    border: Border.all(
//                                        width: 0.5,
//                                        color: ColorConst.red1BgColor),
              ),
              child: Padding(
                padding: const EdgeInsets.all(5),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    const SizedBox(
                      height: 5,
                    ),

                    ///检查项内容、风险管控措施
                    buildCheckItemContent(index, subIndex, context),

                    ///间距
                    const SizedBox(
                      height: 5,
                    ),
                    if (taskDayCheckList[index]
                            .childTaskWeekList![subIndex]
                            .taskWeekCheck!
                            .result ==
                        '4') ...[
                      const DividerCustom(ColorConst.whiteColor, 5, 5, 20, 20),
                      Container(
                        margin: const EdgeInsets.only(left: 20),
                        child: Text.rich(
                            softWrap: true,
                            TextSpan(children: [
                              const TextSpan(
                                  text: '风险内容: ',
                                  style: TextStyle(
                                      fontSize: 14, color: Colors.black87)),
                              TextSpan(
                                text: taskDayCheckList[index]
                                    .childTaskWeekList![subIndex]
                                    .taskWeekCheck!
                                    .riskContent!,
                                style: const TextStyle(
                                    fontSize: 14, color: Colors.black54),
                              ),
                            ])),
                      ),
                      Container(
                        margin: const EdgeInsets.only(top: 5, left: 20),
                        child: Text.rich(
                            softWrap: true,
                            TextSpan(children: [
                              const TextSpan(
                                  text: "整改内容: ",
                                  style: TextStyle(
                                      fontSize: 14, color: Colors.black87)),
                              TextSpan(
                                text: taskDayCheckList[index]
                                    .childTaskWeekList![subIndex]
                                    .taskWeekCheck!
                                    .rectContent!,
                                style: const TextStyle(
                                    fontSize: 13, color: Colors.black54),
                              ),
                            ])),
                      ),
                      Container(
                        margin:
                            const EdgeInsets.only(top: 5, left: 20, bottom: 5),
                        child: Text.rich(
                            softWrap: true,
                            TextSpan(children: [
                              const TextSpan(
                                  text: "整改人: ",
                                  style: TextStyle(
                                      fontSize: 14, color: Colors.black87)),
                              TextSpan(
                                text: taskDayCheckList[index]
                                    .childTaskWeekList![subIndex]
                                    .taskWeekCheck!
                                    .rectUserName!,
                                style: const TextStyle(
                                    fontSize: 14, color: Colors.black54),
                              ),
                            ])),
                      ),
                      Container(
                        margin:
                            const EdgeInsets.only(top: 5, left: 20, bottom: 5),
                        child: Text.rich(
                            softWrap: true,
                            TextSpan(children: [
                              const TextSpan(
                                  text: "整改时间: ",
                                  style: TextStyle(
                                      fontSize: 14, color: Colors.black87)),
                              TextSpan(
                                text: taskDayCheckList[index]
                                    .childTaskWeekList![subIndex]
                                    .taskWeekCheck!
                                    .rectTime!,
                                style: const TextStyle(
                                    fontSize: 14, color: Colors.black54),
                              ),
                            ])),
                      ),
                    ],
                    if (taskDayCheckList[index]
                            .childTaskWeekList![subIndex]
                            .taskWeekCheck!
                            .result ==
                        '2') ...[
                      const DividerCustom(ColorConst.whiteColor, 5, 10, 20, 20),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          const SizedBox(width: 20),
                          Expanded(
                            child: Text.rich(
                                softWrap: true,
                                TextSpan(children: [
                                  const TextSpan(
                                      text: '风险内容: ',
                                      style: TextStyle(
                                          fontSize: 14, color: Colors.black54)),
                                  TextSpan(
                                    text: taskDayCheckList[index]
                                        .childTaskWeekList![subIndex]
                                        .taskWeekCheck!
                                        .riskContent!,
                                    style: const TextStyle(
                                        fontSize: 14, color: Colors.black87),
                                  ),
                                ])),
                          ),
                          Padding(
                            padding: const EdgeInsets.all(8.0),
                            child: InkWell(
                                highlightColor: ColorConst.blueColor,
                                child: Text(
                                  taskDayCheckList[index]
                                      .childTaskWeekList![subIndex]
                                      .taskWeekCheck!
                                      .hiddenText!,
                                  style: const TextStyle(
                                      color: ColorConst.red1BgColor,
                                      fontSize: 14),
                                ),
                                onTap: () {
                                  setState(() {
                                    if (taskDayCheckList[index]
                                            .childTaskWeekList![subIndex]
                                            .taskWeekCheck!
                                            .hiddenText ==
                                        '去整改') {
                                      taskDayCheckList[index]
                                          .childTaskWeekList![subIndex]
                                          .taskWeekCheck!
                                          .hiddenText = '取消整改';
                                    } else {
                                      taskDayCheckList[index]
                                          .childTaskWeekList![subIndex]
                                          .taskWeekCheck!
                                          .hiddenText = '去整改';
                                      taskDayCheckList[index]
                                          .childTaskWeekList![subIndex]
                                          .taskWeekCheck!
                                          .hiddenContent = '';
                                    }
                                  });
                                }),
                          ),
                          // const SizedBox(width: 5),
                        ],
                      ),
                      if (taskDayCheckList[index]
                              .childTaskWeekList![subIndex]
                              .taskWeekCheck!
                              .hiddenText ==
                          '取消整改') ...[
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Container(
                              margin: const EdgeInsets.only(
                                  top: 5, bottom: 5, left: 20, right: 5),
                              child: const Text(
                                softWrap: true,
                                '整改内容:',
                                style: TextStyle(
                                    color: Colors.black54, fontSize: 14),
                              ),
                            ),
                            Container(
                              decoration: const BoxDecoration(
                                color: ColorConst.greyF2Color,
                                borderRadius:
                                    BorderRadius.all(Radius.circular(5)),
                              ),
                              margin: const EdgeInsets.only(
                                  top: 0, bottom: 5, left: 20, right: 10),
                              padding: const EdgeInsets.only(
                                  top: 10, bottom: 5, right: 5),
                              child: TextField(
                                maxLength: 200,
                                decoration: const InputDecoration(
                                  hintText: '请输入整改内容...',
                                  isCollapsed: true,
                                  hintStyle: TextStyle(
                                      color: Colors.grey, fontSize: 14),
                                  border: InputBorder.none,
                                  contentPadding:
                                      EdgeInsets.fromLTRB(10, 0, 0, 0),
                                ),
                                //动态设置补充项内容
                                onChanged: (text) {
                                  taskDayCheckList[index]
                                      .childTaskWeekList![subIndex]
                                      .taskWeekCheck!
                                      .hiddenContent = text;
                                },
                                controller: buildController(
                                    taskDayCheckList[index]
                                            .childTaskWeekList![subIndex]
                                            .taskWeekCheck!
                                            .hiddenContent ??
                                        ''),
                                maxLines: null,
                                style: const TextStyle(
                                    fontSize: 14, color: Colors.black87),
                              ),
                            ),
                          ],
                        ),
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Container(
                              margin: const EdgeInsets.only(
                                  top: 0, bottom: 5, left: 20, right: 5),
                              child: const Text(
                                softWrap: true,
                                '整改人:',
                                style: TextStyle(
                                    color: Colors.black54, fontSize: 14),
                              ),
                            ),
                            Container(
                              decoration: const BoxDecoration(
                                color: ColorConst.greyF2Color,
                                borderRadius:
                                    BorderRadius.all(Radius.circular(5)),
                              ),
                              margin: const EdgeInsets.only(
                                  top: 0, bottom: 5, left: 20, right: 10),
                              padding: const EdgeInsets.only(
                                  top: 10, bottom: 5, right: 5),
                              child: TextField(
                                maxLength: 20,
                                decoration: const InputDecoration(
                                  hintText: '请输入整改人...',
                                  isCollapsed: true,
                                  hintStyle: TextStyle(
                                      color: Colors.grey, fontSize: 14),
                                  border: InputBorder.none,
                                  contentPadding:
                                      EdgeInsets.fromLTRB(10, 0, 0, 0),
                                ),
                                //动态设置补充项内容
                                onChanged: (text) {
                                  taskDayCheckList[index]
                                      .childTaskWeekList![subIndex]
                                      .taskWeekCheck!
                                      .hiddenName = text;
                                },
                                controller: buildController(
                                    taskDayCheckList[index]
                                            .childTaskWeekList![subIndex]
                                            .taskWeekCheck!
                                            .hiddenName ??
                                        ''),
                                maxLines: null,
                                style: const TextStyle(
                                    fontSize: 14, color: Colors.black87),
                              ),
                            ),
                          ],
                        ),
                      ]
                    ]
                  ],
                ),
              ),
            );
          },
        ),
      ],
    );
  }

  var status = '1';

  ///设置检查项-默认：风险管控措施标题
  Container buildSeclectRiskControlMeasuresAcquiesce(int index) {
    return Container(
      alignment: Alignment.centerLeft,
      margin: const EdgeInsets.only(top: 8, bottom: 5),
      child: Text(
        '${ConvertNumberToChineseMoneyWords.toChinese(index)}、${taskDayCheckList[index].deviceRisk!.name}',
        style: const TextStyle(
            fontSize: 14, color: Colors.black54, fontWeight: FontWeight.bold),
      ),
    );
  }

  ///检查项内容、风险管控措施
  Row buildCheckItemContent(int index, int subIndex, BuildContext context) {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Flexible(
          flex: 1,
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                '\t${subIndex + 1}、',
                style:
                    const TextStyle(color: ColorConst.blackColor, fontSize: 14),
              ),
              Expanded(
                child: Text.rich(
                    softWrap: true,
                    TextSpan(children: [
                      TextSpan(
                          text: deviceRiskName(index, subIndex),
                          style: const TextStyle(
                              fontSize: 14, color: Colors.black)),
                      TextSpan(
                        text:
                            '(${resultStatusDay(taskDayCheckList[index].childTaskWeekList![subIndex].taskWeekCheck!.result)})',
                        style: TextStyle(
                            fontSize: 14,
                            color: resultColor(taskDayCheckList[index]
                                .childTaskWeekList![subIndex]
                                .taskWeekCheck!
                                .result),
                            fontWeight: FontWeight.bold),
                      ),
                    ])),
              ),
            ],
          ),
        ),
        InkWell(
          onTap: () {
            showDialog(
              context: context,
              builder: (BuildContext context) {
                return AlertDialog(
                  title: const Text('风险管控措施'),
                  content: Text(taskDayCheckList[index]
                      .childTaskWeekList![subIndex]
                      .deviceRisk!
                      .riskMeasure!),
                  actions: <Widget>[
                    MaterialButton(
                      child: const Text(
                        '我知道了',
                        style: TextStyle(color: ColorConst.blueColor),
                      ),
                      onPressed: () {
                        Navigator.of(context).pop();
                      },
                    ),
                  ],
                );
              },
            );
          },
          child: taskDayCheckList[index]
                      .childTaskWeekList![subIndex]
                      .deviceRisk!
                      .riskMeasure !=
                  null
              ? const Icon(
                  Icons.help,
                  color: ColorConst.dark9Color,
                  size: EdgeInsetsConst.single_choice_icon_size,
                )
              : const SizedBox(),
        )
      ],
    );
  }

  String deviceRiskName(int index, int subIndex) {
    var childTaskDayList = taskDayCheckList[index].childTaskWeekList![subIndex];
    if (childTaskDayList.deviceRisk!.id!.isNotEmpty) {
      return taskDayCheckList[index]
          .childTaskWeekList![subIndex]
          .deviceRisk!
          .name!;
    } else {
      return taskDayCheckList[index]
          .childTaskWeekList![subIndex]
          .taskWeekCheck!
          .name!;
    }
  }

  ///标题
  Stack buildTitle(text, image, isVis) {
    return Stack(
      alignment: Alignment.bottomLeft,
      children: [
        Container(
          color: ColorConst.blue3Color,
          width: text.toString().length == 3
              ? 83
              : isVis
                  ? 97
                  : 93,
          height: 10,
        ),
        Row(
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Icon(
              image,
              size: 18,
              color: ColorConst.blueColor,
            ),
            Container(
              margin: const EdgeInsets.only(left: 5),
              child: Text.rich(
                  softWrap: true,
                  TextSpan(children: [
                    if (isVis) ...[
                      const TextSpan(
                          text: '*',
                          style: TextStyle(
                              fontSize: 14, color: ColorConst.red1BgColor)),
                    ],
                    TextSpan(
                      text: text,
                      style: const TextStyle(fontSize: 16, color: Colors.black),
                    ),
                  ])),
            )
          ],
        )
      ],
    );
  }

  ///基本信息
  Card buildBasicInformation() {
    return Card(
        color: Colors.white,
        margin: const EdgeInsets.only(left: 15, top: 10, right: 15, bottom: 10),
        elevation: 0,
        shape: const RoundedRectangleBorder(
          borderRadius: BorderRadius.all(Radius.circular(10)),
        ),
        child: Container(
          padding: const EdgeInsets.all(10),
          child: Stack(
            children: [
              Column(
                children: <Widget>[
                  ///基本信息
                  buildTitle('基本信息', Icons.message_rounded, false),

                  ///分割线
                  DividerCustom(Colors.grey[300], 8, 8, 20, 0),
                  //周
                  BasicInformationPage(
                      informationDataList: DataConfig.syWeekInformationData(
                          '2', true, taskDayBo))
                ],
              )
            ],
          ),
        ));
  }

  //item布局
  Container buildBasicInformationItem(var asset, var title, var content,
      [content2]) {
    return Container(
      alignment: Alignment.centerLeft,
      margin: const EdgeInsets.fromLTRB(10, 0, 0, 7),
      child: Stack(
        alignment: Alignment.centerLeft,
        children: [
          Image.asset(asset,
              height: EdgeInsetsConst.icon_size12,
              width: EdgeInsetsConst.icon_size12),
          Container(
              margin: const EdgeInsets.fromLTRB(18, 0, 0, 0),
              child: Text.rich(
                  softWrap: true,
                  TextSpan(children: [
                    TextSpan(
                        text: title,
                        style: const TextStyle(
                            fontSize: 12, color: Colors.black87)),
                    TextSpan(
                      text: content,
                      style: TextStyle(fontSize: 12, color: Colors.grey[600]),
                    ),
                    if (content2 != null && content2 != "") ...[
                      TextSpan(
                        text: content2,
                        style: const TextStyle(
                            fontSize: 12, color: ColorConst.red1BgColor),
                      )
                    ]
                  ])))
        ],
      ),
    );
  }

  ///注：请点检人员按要求认证检查
  Container buildNote() {
    return Container(
      alignment: Alignment.centerLeft,
      margin: const EdgeInsets.only(left: 15, top: 10),
      child: const Text(
        "注：请整改人员按要求认真整改",
        style: TextStyle(fontSize: 12, color: Colors.black54),
      ),
    );
  }

  ///提交任务
  InkWell buildSubmit() {
    return InkWell(
      onTap: () {},
      child: Container(
        margin: const EdgeInsets.only(top: 20, bottom: 60),
        child: GradientButton(
          tapCallback: () {
            var isHiddenText = false;
            for (var item in taskDayCheckList) {
              for (var item1 in item.childTaskWeekList!) {
                if (item1.taskWeekCheck!.result == '2') {
                  if (item1.taskWeekCheck!.hiddenText == '取消整改') {
                    isHiddenText = true;
                    break;
                  }
                }
              }
              if (isHiddenText) {
                break;
              }
            }
            if (!isHiddenText) {
              ToastUtils.showCenter('至少选择一项整改内容');
              return;
            }
            var isHiddenContent = false;

            for (var item in taskDayCheckList) {
              for (var item1 in item.childTaskWeekList!) {
                if (item1.taskWeekCheck!.result == '2') {
                  if (item1.taskWeekCheck!.hiddenContent!.isNotEmpty &&
                      item1.taskWeekCheck!.hiddenName!.isNotEmpty) {
                    isHiddenContent = true;
                    break;
                  }
                }
              }
              if (isHiddenContent) {
                break;
              }
            }

            if (!isHiddenContent) {
              ToastUtils.showCenter('整改内容和整改人不能为空');
              return;
            }

            String? results;
            for (var item in taskDayCheckList) {
              for (var item1 in item.childTaskWeekList!) {
                if (item1.taskWeekCheck!.result == '2') {
                  if (item1.taskWeekCheck!.hiddenContent!.isEmpty) {
                    results = '2';
                    break;
                  } else {
                    results = '3';
                  }
                }
              }
              if (results == '2') {
                break;
              }
            }

            Get.dialog(AlertDialog(
              title: const Text("周排查《风险整改》"),
              content: const Text("您确定要提交当前内容吗？"),
              actionsPadding:
                  const EdgeInsets.only(left: 0, top: 0, bottom: 10, right: 20),
              contentPadding: const EdgeInsets.only(
                  left: 20, top: 0, bottom: 10, right: 20),
              titlePadding: const EdgeInsets.only(
                  left: 20, top: 20, bottom: 10, right: 20),
              shape: const RoundedRectangleBorder(
                  // 这里设置shape属性
                  borderRadius: BorderRadius.all(Radius.circular(10.0))),
              actions: <Widget>[
                TextButton(
                  child: const Text("取消", style: TextStyle(fontSize: 16)),
                  onPressed: () {
                    Get.back();
                  },
                ),
                TextButton(
                  child: const Text("确定", style: TextStyle(fontSize: 16)),
                  onPressed: () {
                    buildUpdate(results);
                    Get.back();
                  },
                ),
              ],
            ));
          },
          width: 180,
          height: 40,
          borderRadius: const BorderRadius.only(
              topLeft: Radius.circular(10),
              topRight: Radius.circular(20),
              bottomLeft: Radius.circular(20),
              bottomRight: Radius.circular(10)),
          disable: false,
          colors: const [ColorConst.blueColor, ColorConst.blue1Color],
          child: const Text(
            "提交",
            style: TextStyle(fontSize: 14, color: ColorConst.whiteColor),
          ),
        ),
      ),
    );
  }

  Future<Null> buildUpdate(String? results) {
    return HttpUtils.doTime(context).then((value) {
      SystemTime systemTime = value;
      if (mounted) {
        DateTime date = DateTime.fromMillisecondsSinceEpoch(systemTime.time!);
        List<TaskWeekCheckLists> checkLists = [];
        for (var parentItem in taskDayCheckList) {
          var parentId = parentItem.deviceRisk!.id;
          for (var childItem in parentItem.childTaskWeekList!) {
            DeviceRiskParents deviceRiskParent =
                DeviceRiskParents(id: parentId!);
            DeviceRisks deviceRisks =
                DeviceRisks(id: childItem.deviceRisk!.id!);
            TaskWeeks taskDays = TaskWeeks(id: taskDayBo.id!); //列表id
            var childResults;
            if (childItem.taskWeekCheck!.result == '2') {
              if (childItem.taskWeekCheck!.hiddenContent!.isNotEmpty) {
                childResults = '4';
              } else {
                childResults = childItem.taskWeekCheck!.result;
              }
            } else {
              childResults = childItem.taskWeekCheck!.result;
            }

            TaskWeekCheckLists taskDayCheck = TaskWeekCheckLists(
              name: childItem.deviceRisk!.id!.isNotEmpty
                  ? childItem.deviceRisk!.name!
                  : childItem.taskWeekCheck!.name!,
              result: childResults,
              sort: childItem.sort!,
              deviceRiskParent: deviceRiskParent,
              deviceRisk: deviceRisks,
              taskWeek: taskDays,
              riskContent: childItem.taskWeekCheck!.riskContent!,
              rectHave: '',
              rectContent: childItem.taskWeekCheck!.result == '2'
                  ? childItem.taskWeekCheck!.hiddenContent!
                  : childItem.taskWeekCheck!.rectContent ?? '',
              rectUserName: childItem.taskWeekCheck!.result == '2'
                  ? childItem.taskWeekCheck!.hiddenName!
                  : childItem.taskWeekCheck!.rectUserName ?? '',
              rectTime: childItem.taskWeekCheck!.result == '2'
                  ? date.toString().substring(0, 19)
                  : childItem.taskWeekCheck!.rectTime ?? '',
              id: childItem.taskWeekCheck!.id!,
            );
            checkLists.add(taskDayCheck);
          }
        }

        WeekSubmitBo daySubmitBo = WeekSubmitBo(
            result: results!,
            checkTime: taskDayBo.checkTime!,
            taskState: results,
            prictures: '',
            checkUser: CheckUser(id: taskDayBo.checkUser!.id!),
            taskWeekCheckList: checkLists,
            id: taskDayBo.id!);
        printLog("《周排查-风险整改》提交json数据----->${json.encode(daySubmitBo)}");
        getWeekSubmitData(daySubmitBo);
      }
    });
  }

  ///周排查：提交数据
  void getWeekSubmitData(WeekSubmitBo daySubmitBo) {
    HttpUtils.getWeekTaskSave(context, daySubmitBo).then((value) {
      if (mounted) {
        setState(() {
          ToastUtils.showCenter('提交成功');
          Get.back(result: true);
        });
      }
    });
  }
}
