// ignore_for_file: library_private_types_in_public_api, must_be_immutable, avoid_print, prefer_typing_uninitialized_variables

import 'dart:convert';
import 'dart:io';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/common/edgeInsets_const.dart';
import 'package:special_equipment_flutter/dio/http_utils.dart';
import 'package:special_equipment_flutter/model/day_submit_bo.dart';
import 'package:special_equipment_flutter/model/detail/month/child_task_month_list.dart';
import 'package:special_equipment_flutter/model/detail/month/month_detail_bo.dart';
import 'package:special_equipment_flutter/model/detail/month/task_month_check_dto_list.dart';
import 'package:special_equipment_flutter/model/month_submit_bo.dart';
import 'package:special_equipment_flutter/model/system_time.dart';
import 'package:special_equipment_flutter/ui/common/basic_information_page.dart';
import 'package:special_equipment_flutter/ui/common/data.dart';
import 'package:special_equipment_flutter/ui/common/text_editing_controller.dart';
import 'package:special_equipment_flutter/utils/log_util.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';
import 'package:special_equipment_flutter/utils/toast_utils.dart';
import 'package:special_equipment_flutter/widgets/app_bar/custom_app_bar.dart';
import 'package:special_equipment_flutter/widgets/divider_custom.dart';
import 'package:special_equipment_flutter/widgets/number_to_chinese.dart';

import '../../../../model/detail/device_risk.dart';
import '../../../../widgets/custom_button.dart';
import '../../../../widgets/dialog/custom_bottom_sheet1.dart';

class RiskControlMeasuresModel {
  String id;
  String name;

  RiskControlMeasuresModel(this.id, this.name);
}

///使用单位
///月调度
///检查提交页面
class MonthInspectSubmitSyPage extends StatefulWidget {
  ///区分  日管控、周排查、月调度
  var argsBundle = Get.arguments;
  var type;

  MonthInspectSubmitSyPage({super.key});

  @override
  _MonthInspectSubmitSyPageState createState() =>
      _MonthInspectSubmitSyPageState();
}

class _MonthInspectSubmitSyPageState extends State<MonthInspectSubmitSyPage> {
  ///检查项默认数据长度
  int acquiesceLength = 0;

  ///选择照片最大数量
  final imageCount = 3;

  ///检查照片
  final List<File>? waterList = [];

  late List<RiskControlMeasuresModel> riskControlMeasuresList = [];

  List<CustomBottomSheetTitleModel> modelList = [
    CustomBottomSheetTitleModel('相册'),
    CustomBottomSheetTitleModel('拍照'),
  ];

  ///type=1（日管控）type=2（周排查）type=3（月调度）
  var type, unitStatus;
  late var taskDayBo;
  List<TaskMonthCheckDtoList> taskList = [];
  List<String>? picturesList = [];

  @override
  void initState() {
    super.initState();
    type = widget.argsBundle['argsData']['type'];
    taskDayBo = widget.argsBundle['listBo'];
    unitStatus = StorageUtil.getInstance().getUnitStatus();
    getData();
  }

  ///获取数据
  void getData() {
    HttpUtils.getFindTaskMonthCheck(context, taskDayBo.id).then((value) {
      MonthDetailBo detailSyBo = value;
      if (mounted) {
        setState(() {
          for (var item in detailSyBo.taskMonthCheckDtoList!) {
            riskControlMeasuresList.add(RiskControlMeasuresModel(
                item.deviceRisk!.id!, item.deviceRisk!.name!));
            if (item.deviceRisk!.isShow != '0') {
              taskList.add(item);
              // for (var childItem in item.childTaskMonthList!) {
              //   focusNodeList.add(FocusNode());
              // }
            }
          }
          if (taskList.isNotEmpty) {
            acquiesceLength = taskList.length;
          }
        });
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.grey[100],
      appBar: AppBarCustom(text: '月调度', height: 50),
      body: CustomScrollView(
        shrinkWrap: true,
        slivers: <Widget>[
          SliverToBoxAdapter(
            child: Column(
              children: [
                ///注：请点检人员按要求认证检查
                buildNote(),

                ///基本信息
                buildBasicInformation(),

                ///检查项
                buildCheckItem(),

                ///提交任务
                buildSubmit(),
              ],
            ),
          ),
        ],
      ),
    );
  }

  ///检查项
  Card buildCheckItem() {
    return Card(
        color: Colors.white,
        margin: const EdgeInsets.only(left: 15, top: 0, right: 15, bottom: 0),
//          shadowColor: ColorConst.blueColor,
        elevation: 0,
        shape: const RoundedRectangleBorder(
          borderRadius: BorderRadius.all(Radius.circular(10)),
        ),
        child: Container(
          padding:
              const EdgeInsets.only(left: 10, top: 10, right: 10, bottom: 20),
          child: Column(
            children: <Widget>[
              ///标题
              buildTitle('检查项', Icons.event_note, true),

              ///提示
              Container(
                alignment: Alignment.centerLeft,
                margin: const EdgeInsets.only(left: 30),
                child: Text(
                  '注：不符合？请描述风险内容',
                  style: TextStyle(fontSize: 12, color: Colors.grey[500]),
                ),
              ),

              ///分割线
              DividerCustom(Colors.grey[300], 10, 0, 20, 0),

              ///ListView在苹果手机顶部\底部出现空白间距的解决方案
              MediaQuery.removePadding(
                  context: context,
                  removeBottom: true,
                  removeTop: true,

                  ///检查项
                  child: ListView.builder(
                    shrinkWrap: true,
                    physics: const NeverScrollableScrollPhysics(),
                    padding: const EdgeInsets.only(top: 0, left: 25, bottom: 0),
                    itemCount: taskList.length,
                    itemBuilder: (BuildContext context, int index) {
                      ///检查项item内容
                      return buildItem(index);
                    },
                  )),

              ///分割线
              const DividerCustom(Colors.grey, 15, 15, 0, 0),

              ///检查人
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  ///标题
                  buildTitle('检查人', Icons.people, true),
                  Text(
                    StorageUtil.getInstance().getName(),
                    style: const TextStyle(fontSize: 14, color: Colors.grey),
                  ),
                ],
              ),
            ],
          ),
        ));
  }

  int num = 100;

  int? getSort() {
    return num++;
  }

  ///检查项item内容
  Column buildItem(int index) {
    return Column(
      children: <Widget>[
        ///补充项 - 判断显示内容
        if (taskList[index].deviceRisk!.isCategory!) ...[
          ///检查项-补充项：选择风险管控措施
          buildSeclectRiskControlMeasuresNew(index),
        ] else ...[
          ///设置检查项-默认：风险管控措施标题
          buildSeclectRiskControlMeasuresAcquiesce(index),
        ],

        ///二级列表
        ListView.builder(
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
          itemCount: taskList[index].childTaskMonthList!.length,
          itemBuilder: (context, subIndex) {
            return Container(
              margin: const EdgeInsets.only(bottom: 5),
              decoration: BoxDecoration(
                color: taskList[index]
                            .childTaskMonthList![subIndex]
                            .deviceRisk!
                            .isChecked! ==
                        '2'
                    ? ColorConst.red4BgColor
                    : ColorConst.green1Color,
                borderRadius: const BorderRadius.all(Radius.circular(5)),
//                                    border: Border.all(
//                                        width: 0.5,
//                                        color: ColorConst.red1BgColor),
              ),
              child: Padding(
                padding: const EdgeInsets.all(5),
                child: Column(
                  children: [
                    const SizedBox(
                      height: 5,
                    ),

                    ///检查项内容、风险管控措施
                    buildCheckItemContent(index, subIndex, context),

                    ///间距
                    const SizedBox(
                      height: 5,
                    ),

                    ///单选
                    buildSingleChoice(index, subIndex),

                    ///间距
                    const SizedBox(
                      height: 5,
                    ),

                    ///选项有风险显示风险填写内容
                    buildCheckRiskyVisibilityContent(index, subIndex),
                  ],
                ),
              ),
            );
          },
        ),
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            if ((index + 1) == acquiesceLength) ...[
              Container(
                margin: const EdgeInsets.only(left: 5, bottom: 5),
                alignment: Alignment.centerLeft,
                child: const Text.rich(
                    softWrap: true,
                    TextSpan(children: [
                      TextSpan(
                          text: '补充项 ',
                          style: TextStyle(
                              fontSize: 14,
                              color: Colors.black54,
                              fontWeight: FontWeight.bold)),
                      TextSpan(
                        text: '(注：检查人可补充的检查项)',
                        style: TextStyle(fontSize: 12, color: Colors.grey),
                      ),
                    ])),
              ),
              InkWell(
                onTap: () {
                  setState(() {
                    if (taskList.isEmpty) {
                      return;
                    }
                    for (var itemParent in taskList) {
                      ///如果是补充项项目
                      if (itemParent.deviceRisk!.isCategory!) {
                        if (itemParent.deviceRisk!.name!.isEmpty) {
                          ToastUtils.showCenter('请先完善当前《补充项》');
                          return;
                        }
                        for (var itemChild in itemParent.childTaskMonthList!) {
                          if (itemChild.deviceRisk!.name!.isEmpty) {
                            ToastUtils.showCenter('请先完善当前《补充项》');
                            return;
                          }
                          if (itemChild.deviceRisk!.isChecked == '2') {
                            if (itemChild.deviceRisk!.riskcontent!.isEmpty) {
                              ToastUtils.showCenter('请先完善当前《补充项》');
                              return;
                            }
                          }
                        }
                      }
                    }

                    List<ChildTaskMonthList> childTaskList = [];
                    ChildTaskMonthList childTaskWeekList = ChildTaskMonthList(
                        deviceRisk: DeviceRisk(
                            id: '',
                            name: '',
                            sort: getSort(),
                            riskMeasure: '',
                            inspectType: '',
                            isShow: '',
                            parentId: '',
                            isChecked: '1',
                            isEnabled: true,
                            isCategory: true,
                            riskcontent: '',
                            focusNode1: FocusNode(),
                            focusNode2: FocusNode()),
                        sort: getSort());
                    childTaskList.add(childTaskWeekList);

                    TaskMonthCheckDtoList taskListBo = TaskMonthCheckDtoList(
                        deviceRisk: DeviceRisk(
                            id: '',
                            name: '',
                            sort: getSort(),
                            riskMeasure: '',
                            inspectType: '',
                            isShow: '',
                            parentId: '',
                            isChecked: '1',
                            isEnabled: true,
                            isCategory: true,
                            riskcontent: '',
                            focusNode1: FocusNode(),
                            focusNode2: FocusNode()),
                        sort: getSort(),
                        childTaskMonthList: childTaskList);
                    taskList.add(taskListBo);
                  });
                },
                child: const Padding(
                  padding: EdgeInsets.all(10.0),
                  child: Row(
                    children: [
                      Icon(
                        Icons.add_circle_outline,
                        size: 15,
                        color: ColorConst.themeBgColor,
                      ),
                      SizedBox(
                        width: 5,
                      ),
                      Text(
                        '新增',
                        style: TextStyle(
                          fontSize: 14.0,
                          color: ColorConst.themeBgColor,
                        ),
                      )
                    ],
                  ),
                ),
              )
            ],
          ],
        ),
      ],
    );
  }

  ///设置检查项-默认：风险管控措施标题
  Container buildSeclectRiskControlMeasuresAcquiesce(int index) {
    return Container(
      alignment: Alignment.centerLeft,
      margin: const EdgeInsets.only(top: 8, bottom: 5),
      child: Text(
        '${ConvertNumberToChineseMoneyWords.toChinese(index)}、${taskList[index].deviceRisk!.name}',
        style: const TextStyle(
            fontSize: 14, color: Colors.black54, fontWeight: FontWeight.bold),
      ),
    );
  }

  ///检查项-补充项：选择风险管控措施
  Container buildSeclectRiskControlMeasuresNew(int index) {
    return Container(
      alignment: Alignment.centerLeft,
      margin: const EdgeInsets.only(top: 5, bottom: 3, left: 0),
      child: PopupMenuButton<int>(
        elevation: 10,
        shadowColor: ColorConst.themeBgColor,
        offset: const Offset(-15, 25),
        shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.circular(10),
//                                  side: BorderSide(
//                                    width: 1,
//                                    color: ColorConst.themeBgColor,
//                                    style: BorderStyle.solid,
//                                  ),
        ),
        child: Row(
          children: [
            Container(
              padding:
                  const EdgeInsets.only(left: 5, top: 0, right: 0, bottom: 0),
              decoration: BoxDecoration(
                border: Border.all(color: Colors.black26, width: 0.5),
                borderRadius: BorderRadius.circular(5),
              ),
              child: Row(
                children: [
                  Text(
                      taskList[index].deviceRisk!.name!.isEmpty
                          ? '请选择风险类别'
                          : taskList[index].deviceRisk!.name!,
                      style:
                          const TextStyle(fontSize: 14, color: Colors.black54)),
                  const Icon(Icons.arrow_drop_down)
                ],
              ),
            ),
          ],
        ),
        itemBuilder: (context) => [
          for (var i = 0; i < riskControlMeasuresList.length; i++) ...[
            PopupMenuItem(
              height: 35,
              padding:
                  const EdgeInsets.only(left: 15, right: 0, top: 5, bottom: 5),
              value: i,
              child: Row(
                children: [
                  Container(
                    alignment: Alignment.center,
                    width: 18,
                    height: 18,
                    decoration: BoxDecoration(
                      color: ColorConst.themeBgColor,
                      borderRadius: BorderRadius.circular(50),
                    ),
                    child: Text(
                      (i + 1).toString(),
                      style: const TextStyle(color: Colors.white, fontSize: 12),
                    ),
                  ),
                  Text('  ${riskControlMeasuresList[i].name}',
                      style: const TextStyle(color: Colors.black, fontSize: 14))
                ],
              ),
            ),
          ],
        ],
        onSelected: (value) {
          setState(() {
            taskList[index].deviceRisk!.name =
                riskControlMeasuresList[value].name;
            taskList[index].deviceRisk!.id = riskControlMeasuresList[value].id;
          });
        },
      ),
    );
  }

  int? index1, index2, subIndex1, subIndex2;

  @override
  void didChangeDependencies() {
    super.didChangeDependencies();

    ///收起键盘后，TextField失去焦点
    if ((WidgetsFlutterBinding.ensureInitialized()
                .platformDispatcher
                .views
                .first
                .viewInsets
                .bottom ??
            0.0) <=
        0.0) {
      if (index1 != null && subIndex1 != null) {
        try {
          taskList[index1!]
              .childTaskMonthList![subIndex1!]
              .deviceRisk!
              .focusNode1!
              .unfocus();
        } catch (e) {
          e.printError();
        }
      }
      if (index2 != null && subIndex2 != null) {
        try {
          taskList[index2!]
              .childTaskMonthList![subIndex2!]
              .deviceRisk!
              .focusNode2!
              .unfocus();
        } catch (e) {
          e.printError();
        }
      }
    }
  }

  ///选项有风险显示风险填写内容
  Visibility buildCheckRiskyVisibilityContent(int index, int subIndex) {
    return Visibility(
        visible: taskList[index]
                    .childTaskMonthList![subIndex]
                    .deviceRisk!
                    .isChecked ==
                '2'
            ? true
            : false,
        child: Column(
          children: [
            const DividerCustom(Colors.white, 10, 0, 0, 0),
            TextField(
              maxLength: 200,
              focusNode: taskList[index]
                  .childTaskMonthList![subIndex]
                  .deviceRisk!
                  .focusNode1,
              decoration: const InputDecoration(
                hintText: '请描述风险内容...',
                isCollapsed: true,
                hintStyle: TextStyle(color: Colors.red, fontSize: 14),
                border: InputBorder.none,
                contentPadding:
                    EdgeInsets.only(left: 10, top: 15, bottom: 15, right: 5),
              ),
              //动态设置补充项内容
              onChanged: (text) {
                taskList[index]
                    .childTaskMonthList![subIndex]
                    .deviceRisk!
                    .riskcontent = text;
                index1 = index;
                subIndex1 = subIndex;
                // print(index1);
                // print(subIndex1);
              },
              controller: buildController(taskList[index]
                      .childTaskMonthList![subIndex]
                      .deviceRisk!
                      .riskcontent ??
                  ''),
              maxLines: null,
              style:
                  const TextStyle(fontSize: 14, color: ColorConst.black2Color),
            ),
          ],
        ));
  }

  ///检查项内容、风险管控措施
  Row buildCheckItemContent(int index, int subIndex, BuildContext context) {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Flexible(
          flex: 1,
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                taskList[index]
                        .childTaskMonthList![subIndex]
                        .deviceRisk!
                        .isEnabled!
                    ? '\t\t\t\t\t'
                    : '\t${subIndex + 1}、',
                style:
                    const TextStyle(color: ColorConst.blackColor, fontSize: 14),
              ),
              Expanded(
                  child: TextField(
                maxLength: 200,
                focusNode: taskList[index]
                    .childTaskMonthList![subIndex]
                    .deviceRisk!
                    .focusNode2,
                maxLines: null,
                //动态设置补充项内容
                onChanged: (text) {
                  taskList[index]
                      .childTaskMonthList![subIndex]
                      .deviceRisk!
                      .name = text;
                  index2 = index;
                  subIndex2 = subIndex;
                  print(index2);
                  print(subIndex2);
                },
                //禁止编辑
                enabled: taskList[index]
                    .childTaskMonthList![subIndex]
                    .deviceRisk!
                    .isEnabled,
                //禁止复制
                enableInteractiveSelection: false,
                controller: buildController(taskList[index]
                        .childTaskMonthList![subIndex]
                        .deviceRisk!
                        .name ??
                    ''),
                decoration: const InputDecoration(
                  hintText: '请输入检查内容...',
                  isCollapsed: true,
                  hintStyle: TextStyle(color: Colors.grey),
                  border: InputBorder.none,
                  contentPadding: EdgeInsets.fromLTRB(0, 0, 0, 0),
                ),
                style:
                    const TextStyle(fontSize: 14, color: ColorConst.blackColor),
              ))
            ],
          ),
        ),
        InkWell(
          onTap: () {
            if (taskList[index]
                .childTaskMonthList![subIndex]
                .deviceRisk!
                .isEnabled!) {
              setState(() {
                taskList.removeAt(index);
              });
            } else {
              showDialog(
                context: context,
                builder: (BuildContext context) {
                  return AlertDialog(
                    title: const Text('风险管控措施'),
                    content: Text(taskList[index]
                        .childTaskMonthList![subIndex]
                        .deviceRisk!
                        .riskMeasure!),
                    actions: <Widget>[
                      MaterialButton(
                        child: const Text(
                          '我知道了',
                          style: TextStyle(color: ColorConst.blueColor),
                        ),
                        onPressed: () {
                          Navigator.of(context).pop();
                        },
                      ),
                    ],
                  );
                },
              );
            }
          },
          child: Icon(
            taskList[index].childTaskMonthList![subIndex].deviceRisk!.isEnabled!
                ? Icons.do_disturb_on
                : Icons.help,
            color: taskList[index]
                    .childTaskMonthList![subIndex]
                    .deviceRisk!
                    .isEnabled!
                ? ColorConst.red1BgColor
                : ColorConst.dark9Color,
            size: EdgeInsetsConst.single_choice_icon_size,
          ),
        )
      ],
    );
  }

  ///标题
  Stack buildTitle(text, image, isVis) {
    return Stack(
      alignment: Alignment.bottomLeft,
      children: [
        Container(
          color: ColorConst.blue3Color,
          width: text.toString().length == 3
              ? 83
              : isVis
                  ? 97
                  : 93,
          height: 10,
        ),
        Row(
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Icon(
              image,
              size: 18,
              color: ColorConst.blueColor,
            ),
            Container(
              margin: const EdgeInsets.only(left: 5),
              child: Text.rich(
                  softWrap: true,
                  TextSpan(children: [
                    if (isVis) ...[
                      const TextSpan(
                          text: '*',
                          style: TextStyle(
                              fontSize: 14, color: ColorConst.red1BgColor)),
                    ],
                    TextSpan(
                      text: text,
                      style: const TextStyle(fontSize: 16, color: Colors.black),
                    ),
                  ])),
            )
          ],
        )
      ],
    );
  }

  ///单选
  Row buildSingleChoice(int index, int subIndex) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceAround,
      children: [
        ///符合
        InkWell(
          splashColor: ColorConst.green1Color,
          onTap: () {
            setState(() {
              ///如果选择了不符合填写了风险内容，需要清除内容
              taskList[index]
                  .childTaskMonthList![subIndex]
                  .deviceRisk!
                  .riskcontent = '';
              taskList[index]
                  .childTaskMonthList![subIndex]
                  .deviceRisk!
                  .isChecked = '1';
            });
          },
          child: Row(
            children: [
              Icon(
                  taskList[index]
                              .childTaskMonthList![subIndex]
                              .deviceRisk!
                              .isChecked! ==
                          '1'
                      ? Icons.check_circle
                      : Icons.panorama_fisheye,
                  color: taskList[index]
                              .childTaskMonthList![subIndex]
                              .deviceRisk!
                              .isChecked! ==
                          '1'
                      ? ColorConst.greenColor
                      : ColorConst.greyC2Color,
                  size: EdgeInsetsConst.single_choice_icon_size),
              const SizedBox(
                width: 5,
              ),
              Text('符合',
                  style: TextStyle(
                      fontSize: 14,
                      color: taskList[index]
                                  .childTaskMonthList![subIndex]
                                  .deviceRisk!
                                  .isChecked! ==
                              '1'
                          ? ColorConst.greenColor
                          : Colors.black))
            ],
          ),
        ),

        ///不符合
        InkWell(
          splashColor: ColorConst.blue1Color,
          onTap: () {
            setState(() {
              taskList[index]
                  .childTaskMonthList![subIndex]
                  .deviceRisk!
                  .isChecked = '2';
            });
          },
          child: Row(
            children: [
              Icon(
                  taskList[index]
                              .childTaskMonthList![subIndex]
                              .deviceRisk!
                              .isChecked ==
                          '2'
                      ? Icons.cancel
                      : Icons.panorama_fisheye,
                  color: taskList[index]
                              .childTaskMonthList![subIndex]
                              .deviceRisk!
                              .isChecked ==
                          '2'
                      ? ColorConst.red1BgColor
                      : ColorConst.greyC2Color,
                  size: EdgeInsetsConst.single_choice_icon_size),
              const SizedBox(
                width: 5,
              ),
              Text('不符合',
                  style: TextStyle(
                      fontSize: 14,
                      color: taskList[index]
                                  .childTaskMonthList![subIndex]
                                  .deviceRisk!
                                  .isChecked ==
                              '2'
                          ? ColorConst.red1BgColor
                          : Colors.black))
            ],
          ),
        ),
      ],
    );
  }

  ///基本信息
  Card buildBasicInformation() {
    return Card(
        color: Colors.white,
        margin: const EdgeInsets.only(left: 15, top: 10, right: 15, bottom: 10),
        elevation: 0,
        shape: const RoundedRectangleBorder(
          borderRadius: BorderRadius.all(Radius.circular(10)),
        ),
        child: Container(
          padding: const EdgeInsets.all(10),
          child: Stack(
            children: [
              Column(
                children: <Widget>[
                  ///基本信息
                  buildTitle('基本信息', Icons.message_rounded, false),

                  ///分割线
                  DividerCustom(Colors.grey[300], 8, 8, 20, 0),
                  BasicInformationPage(
                      informationDataList: DataConfig.syMonthInformationData(
                          '1', true, taskDayBo))
                ],
              )
            ],
          ),
        ));
  }

  //item布局
  Container buildBasicInformationItem(var asset, var title, var content,
      [content2]) {
    return Container(
      alignment: Alignment.centerLeft,
      margin: const EdgeInsets.fromLTRB(10, 0, 0, 7),
      child: Stack(
        alignment: Alignment.centerLeft,
        children: [
          Image.asset(asset,
              height: EdgeInsetsConst.icon_size12,
              width: EdgeInsetsConst.icon_size12),
          Container(
              margin: const EdgeInsets.fromLTRB(18, 0, 0, 0),
              child: Text.rich(
                  softWrap: true,
                  TextSpan(children: [
                    TextSpan(
                        text: title,
                        style: const TextStyle(
                            fontSize: 12, color: Colors.black87)),
                    TextSpan(
                      text: content,
                      style: TextStyle(fontSize: 12, color: Colors.grey[600]),
                    ),
                    if (content2 != null && content2 != "") ...[
                      TextSpan(
                        text: content2,
                        style: const TextStyle(
                            fontSize: 12, color: ColorConst.greenColor),
                      )
                    ]
                  ])))
        ],
      ),
    );
  }

  ///注：请点检人员按要求认证检查
  Container buildNote() {
    return Container(
      alignment: Alignment.centerLeft,
      margin: const EdgeInsets.only(left: 15, top: 10),
      child: const Text(
        "注：请检查人员按要求认真检查",
        style: TextStyle(fontSize: 12, color: Colors.black54),
      ),
    );
  }

  ///提交任务
  Container buildSubmit() {
    return Container(
      margin: const EdgeInsets.only(top: 20, bottom: 60),
      child: GradientButton(
        tapCallback: () {
          for (var item in taskList) {
            var isCategory = item.deviceRisk!.isCategory;
            if (isCategory!) {
              var name = item.deviceRisk!.name;
              var childName = item.childTaskMonthList![0].deviceRisk!.name;
              var isChecked = item.childTaskMonthList![0].deviceRisk!.isChecked;

              if (name!.isEmpty) {
                ToastUtils.showCenter('(补充项)请选择风险类别');
                return;
              }
              if (childName!.isEmpty) {
                ToastUtils.showCenter('(补充项)请输入检查内容');
                return;
              }

              if (isChecked!.isEmpty) {
                ToastUtils.showCenter('(补充项)请勾选：无风险、有风险、无此项');
                return;
              }
            }
            for (var item1 in item.childTaskMonthList!) {
              var isChecked = item1.deviceRisk!.isChecked;
              if (isChecked == '2') {
                var riskcontent = item1.deviceRisk!.riskcontent;
                if (riskcontent!.isEmpty) {
                  if (isCategory) {
                    ToastUtils.showCenter('(补充项)请描述风险内容');
                    return;
                  } else {
                    ToastUtils.showCenter('请描述风险内容');
                    return;
                  }
                }
              }
            }
          }

          List<TaskMonthCheckLists> checkLists = [];
          for (var parentItem in taskList) {
            var parentId = parentItem.deviceRisk!.id;
            for (var childItem in parentItem.childTaskMonthList!) {
              DeviceRiskParents deviceRiskParent =
                  DeviceRiskParents(id: parentId!);
              DeviceRisks deviceRisks =
                  DeviceRisks(id: childItem.deviceRisk!.id!);
              TaskMonths taskDays = TaskMonths(id: taskDayBo.id!); //列表id
              var isChecked = childItem.deviceRisk!.isChecked;
              String childResults;

              ///选择《有风险》状态为1
              if (isChecked == '1') {
                childResults = '1';
              } else {
                childResults = "2";
              }
              TaskMonthCheckLists taskDayCheck = TaskMonthCheckLists(
                name: childItem.deviceRisk!.name!,
                result: childResults,
                sort: childItem.deviceRisk!.sort!,
                deviceRiskParent: deviceRiskParent,
                deviceRisk: deviceRisks,
                taskMonth: taskDays,
                riskContent: childItem.deviceRisk!.riskcontent ?? "",
                rectHave: '',
                rectContent: '',
                rectUserName: '',
                rectTime: '',
                id: '',
              );
              checkLists.add(taskDayCheck);
            }
          }

          String? results;
          for (var item in taskList) {
            for (var item in item.childTaskMonthList!) {
              if (item.deviceRisk!.isChecked == '2') {
                results = '2';
                break;
              } else {
                results = '1';
              }
            }
            if (results == '2') {
              break;
            }
          }
          Get.dialog(AlertDialog(
            title: const Text("月调度《检查》"),
            content: const Text("您确定要提交当前内容吗？"),
            actionsPadding:
                const EdgeInsets.only(left: 0, top: 0, bottom: 10, right: 20),
            contentPadding:
                const EdgeInsets.only(left: 20, top: 0, bottom: 10, right: 20),
            titlePadding:
                const EdgeInsets.only(left: 20, top: 20, bottom: 10, right: 20),
            shape: const RoundedRectangleBorder(
                // 这里设置shape属性
                borderRadius: BorderRadius.all(Radius.circular(10.0))),
            actions: <Widget>[
              TextButton(
                child: const Text("取消", style: TextStyle(fontSize: 16)),
                onPressed: () {
                  Get.back();
                },
              ),
              TextButton(
                child: const Text("确定", style: TextStyle(fontSize: 16)),
                onPressed: () {
                  buildUpdate(results, checkLists);
                  Get.back();
                },
              ),
            ],
          ));
        },
        width: 180,
        height: 40,
        borderRadius: const BorderRadius.only(
            topLeft: Radius.circular(10),
            topRight: Radius.circular(20),
            bottomLeft: Radius.circular(20),
            bottomRight: Radius.circular(10)),
        disable: false,
        colors: const [ColorConst.blueColor, ColorConst.blue1Color],
        child: const Text(
          "提交",
          style: TextStyle(fontSize: 14, color: ColorConst.whiteColor),
        ),
      ),
    );
  }

  Future<Null> buildUpdate(
      String? results, List<TaskMonthCheckLists> checkLists) {
    return HttpUtils.doTime(context).then((value) {
      SystemTime systemTime = value;
      if (mounted) {
        DateTime date = DateTime.fromMillisecondsSinceEpoch(systemTime.time!);
        MonthSubmitBo daySubmitBo = MonthSubmitBo(
            result: results!,
            checkTime: date.toString().substring(0, 19),
            taskState: results,
            prictures: picturesList!.isNotEmpty ? picturesList!.join(',') : '',
            checkUser: CheckUser(id: StorageUtil.getInstance().getUserId()),
            taskMonthCheckList: checkLists,
            id: taskDayBo.id!);
        printLog("《月调度-检查》提交json数据----->${json.encode(daySubmitBo)}");
        getMonthSubmitData(daySubmitBo);
      }
    });
  }

  ///月：提交数据
  void getMonthSubmitData(MonthSubmitBo daySubmitBo) {
    HttpUtils.getMonthTaskSave(context, daySubmitBo).then((value) {
      if (mounted) {
        setState(() {
          ToastUtils.showCenter('提交成功');
          Get.back(result: true);
        });
      }
    });
  }
}
