import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_easyrefresh/easy_refresh.dart';
import 'package:get/get.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/common/route_string.dart';
import 'package:special_equipment_flutter/dio/http_utils.dart';
import 'package:special_equipment_flutter/model/base/base_model.dart';
import 'package:special_equipment_flutter/model/exam/eq_question_bo.dart';
import 'package:special_equipment_flutter/model/exam/equipment_list_bo.dart';
import 'package:special_equipment_flutter/model/exam/exam_setting_submit_bo.dart';
import 'package:special_equipment_flutter/model/exam/exam_unit_list.dart';
import 'package:special_equipment_flutter/model/exam/find_question_num.dart';
import 'package:special_equipment_flutter/model/exam/unit_person_list_bo.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';
import 'package:special_equipment_flutter/utils/toast_utils.dart';
import 'package:special_equipment_flutter/widgets/custom_button.dart';
import 'package:special_equipment_flutter/widgets/custom_textfield.dart';
import 'package:special_equipment_flutter/widgets/first_refresh_widget.dart';

///监察人设置考核机构、考核题信息
class OverseerSettingsPages extends StatefulWidget {
  const OverseerSettingsPages({super.key});

  @override
  State<OverseerSettingsPages> createState() => _OverseerSettingsPagesState();
}

class _OverseerSettingsPagesState extends State<OverseerSettingsPages> {
  TextEditingController? unitText = TextEditingController();
  FocusNode? unitFocusNode = FocusNode();
  TextEditingController? equipmentText = TextEditingController();
  FocusNode? equipmentFocusNode = FocusNode();
  TextEditingController? singleZJText = TextEditingController();
  FocusNode? singleZJFocusNode = FocusNode();
  TextEditingController? judgmentZJText = TextEditingController();
  FocusNode? judgmentZJFocusNode = FocusNode();

  TextEditingController? singleAQYText = TextEditingController();
  FocusNode? singleAQYFocusNode = FocusNode();
  TextEditingController? judgmentAQYText = TextEditingController();
  FocusNode? judgmentAQYFocusNode = FocusNode();

  OfficeList? mOfficeList;
  EquiList? mEquiList;
  DataEq? mDataEq;
  int allAQY = 0, allZJ = 0;

  List<UserLists>? userSafetyDirectorList = [], userSafetyOfficerList = [];
  UnitPersonListBo? mUnitPersonListBo;
  var unitStatus = '';

  @override
  void initState() {
    super.initState();
    getFindQuestionNum();
    unitStatus = StorageUtil.getInstance().getUnitStatus();
  }

  ///获取设备类型
  void getEquipmentList() {
    HttpUtils.getEquipmentList(context, mOfficeList!.id).then((value) {
      EquipmentListBo listBo = value;
      if (mounted) {
        setState(() {
          mEquiList = listBo.list![0];
          equipmentText!.text = mEquiList!.name!;
        });
      }
    });
  }

  ///获取题数
  void getFindQuestionNum() {
    HttpUtils.getFindQuestionNum(context).then((value) {
      FindQuestionNum listBo = value;
      if (mounted) {
        setState(() {
          DataNum dataNum = listBo.data!;
          singleZJText!.text = dataNum.aqzjDx!.toString();
          judgmentZJText!.text = dataNum.aqzjPd!.toString();
          singleAQYText!.text = dataNum.aqyDx!.toString();
          judgmentAQYText!.text = dataNum.aqyPd!.toString();
          allAQY = dataNum.aqzjDx! + dataNum.aqzjPd!;
          allZJ = dataNum.aqyDx! + dataNum.aqyPd!;
        });
      }
    });
  }

  ///获取人员
  void getUnitPersonList(var roleId) {
    HttpUtils.getUnitPerson(context, mOfficeList!.id, mEquiList!.id, roleId)
        .then((value) {
      mUnitPersonListBo = value;
      if (mounted) {
        setState(() {
          ///安全总监
          if (roleId == 'f801011eb2c1481892dba5bc15023733') {
            userSafetyDirectorList = mUnitPersonListBo!.userList;

            ///安全员
          } else if (roleId == '77584ba03b4545fba9d23fd670b66c10') {
            userSafetyOfficerList = mUnitPersonListBo!.userList;
          }
        });
      }
    });
  }

  ///根据设备类型获取总题数
  void getFindEqQuestionNum() {
    HttpUtils.getFindEqQuestionNum(context, mEquiList!.id!).then((value) {
      EqQuestionBo listBo = value;
      if (mounted) {
        setState(() {
          mDataEq = listBo.data!;
          if (int.parse(singleZJText!.text) > mDataEq!.dxNum!) {
            singleZJText!.text = mDataEq!.dxNum!.toString();
            allZJ = (singleZJText!.text.isNotEmpty
                    ? int.parse(singleZJText!.text)
                    : 0) +
                (judgmentZJText!.text.isNotEmpty
                    ? int.parse(judgmentZJText!.text)
                    : 0);
          }
          if (int.parse(judgmentZJText!.text) > mDataEq!.pdNum!) {
            judgmentZJText!.text = mDataEq!.pdNum!.toString();
            allZJ = (singleZJText!.text.isNotEmpty
                    ? int.parse(singleZJText!.text)
                    : 0) +
                (judgmentZJText!.text.isNotEmpty
                    ? int.parse(judgmentZJText!.text)
                    : 0);
          }
          if (int.parse(singleAQYText!.text) > mDataEq!.dxNum!) {
            singleAQYText!.text = mDataEq!.dxNum!.toString();
            allAQY = (singleAQYText!.text.isNotEmpty
                    ? int.parse(singleAQYText!.text)
                    : 0) +
                (judgmentAQYText!.text.isNotEmpty
                    ? int.parse(judgmentAQYText!.text)
                    : 0);
          }
          if (int.parse(judgmentAQYText!.text) > mDataEq!.pdNum!) {
            judgmentAQYText!.text = mDataEq!.pdNum!.toString();
            allAQY = (singleAQYText!.text.isNotEmpty
                    ? int.parse(singleAQYText!.text)
                    : 0) +
                (judgmentAQYText!.text.isNotEmpty
                    ? int.parse(judgmentAQYText!.text)
                    : 0);
          }
        });
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.grey[100],
      body: Stack(
        children: [
          Image.asset('assets/home/rigister_bg.png'),
          Container(
            margin:
                const EdgeInsets.only(left: 15, top: 110, right: 15, bottom: 0),
            decoration: const BoxDecoration(
              color: ColorConst.whiteColor,
              borderRadius: BorderRadius.all(Radius.circular(10)),
            ),
            child: CustomScrollView(
              primary: false,
              shrinkWrap: true,
              slivers: <Widget>[
                SliverToBoxAdapter(
                  child: Column(
                    children: [
                      buildUnitInformation(),
                      // buildSubmit(),
                      const SizedBox(height: 30)
                    ],
                  ),
                ),
              ],
            ),
          ),
          buildTopTitle(context)
        ],
      ),
    );
  }

  ///单位信息
  Container buildUnitInformation() {
    return Container(
      margin: const EdgeInsets.only(left: 10, top: 10, right: 10, bottom: 10),
      child: Stack(
        children: [
          Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: <Widget>[
              const SizedBox(height: 10),
              const Row(children: [
                Icon(Icons.touch_app, color: ColorConst.orangeColor, size: 15),
                Text('单位名称', style: TextStyle(fontSize: 14))
              ]),
              const SizedBox(height: 5),
              CustomTextField(
                  enabled: true,
                  readOnly: true,
                  hintText: '请选择单位名称',
                  controller: unitText,
                  focusNode: unitFocusNode,
                  onTop: () {
                    Get.toNamed(RouteString.UNIT_LIST_PAGE)?.then((map) {
                      if (map != null) {
                        mOfficeList = map;
                        setState(() {
                          unitText!.text = mOfficeList!.name!;
                          mEquiList = null;
                          equipmentText!.text = '';
                          userSafetyDirectorList = [];
                          userSafetyOfficerList = [];
                        });
                      }
                    });
                  }),
              const SizedBox(height: 15),
              const Row(children: [
                Icon(Icons.touch_app, color: ColorConst.orangeColor, size: 15),
                Text('设备类型', style: TextStyle(fontSize: 14))
              ]),
              const SizedBox(height: 5),
              CustomTextField(
                  enabled: true,
                  readOnly: true,
                  hintText: '请选择设备类型',
                  controller: equipmentText,
                  focusNode: equipmentFocusNode,
                  onTop: () {
                    if (mOfficeList != null && mOfficeList!.id!.isNotEmpty) {
                      Get.toNamed(RouteString.EQUIPMENT_LIST_PAGE,
                              arguments: {'officeId': mOfficeList!.id})
                          ?.then((map) {
                        if (map != null) {
                          mEquiList = map;
                          setState(() {
                            equipmentText!.text = mEquiList!.name!;
                            getUnitPersonList(
                                'f801011eb2c1481892dba5bc15023733');
                            getUnitPersonList(
                                '77584ba03b4545fba9d23fd670b66c10');
                            getFindEqQuestionNum();
                          });
                        }
                      });
                    } else {
                      ToastUtils.showCenter('请先选择单位');
                    }
                  }),
              const SizedBox(height: 15),
              Container(
                padding: const EdgeInsets.only(
                    left: 5, top: 10, right: 5, bottom: 10),
                decoration: const BoxDecoration(
                  color: ColorConst.grayf5Color,
                  borderRadius: BorderRadius.all(Radius.circular(10)),
                ),
                child: Column(
                  children: [
                    const Row(children: [
                      Icon(Icons.touch_app,
                          color: ColorConst.orangeColor, size: 15),
                      Text('安全总监', style: TextStyle(fontSize: 14))
                    ]),
                    const SizedBox(height: 5),
                    if (mUnitPersonListBo != null &&
                        userSafetyDirectorList!.isEmpty) ...{
                      Container(
                        padding: const EdgeInsets.only(
                            left: 0, top: 15, right: 0, bottom: 15),
                        child: const Text(
                          "该单位暂无录入（质量）安全总监",
                          style: TextStyle(
                              color: ColorConst.blueColor,
                              fontWeight: FontWeight.bold),
                        ),
                      )
                    },
                    buildSafetyDirectorListView(),
                    const SizedBox(height: 10),
                    Container(
                      padding: const EdgeInsets.only(
                          left: 5, top: 0, right: 5, bottom: 0),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Row(children: [
                            const Text('单选题数', style: TextStyle(fontSize: 14)),
                            SizedBox(
                              width: 40,
                              height: 30,
                              child: TextFormField(
                                textAlign: TextAlign.center,
                                inputFormatters: [
                                  FilteringTextInputFormatter.digitsOnly,
                                  LengthLimitingTextInputFormatter(3),
                                ],
                                focusNode: singleZJFocusNode,
                                controller: singleZJText,
                                onChanged: (num) {
                                  setState(() {
                                    if (num.isEmpty) {
                                      num = '0';
                                    }
                                    if (mDataEq != null &&
                                        int.parse(num) > mDataEq!.dxNum!) {
                                      ToastUtils.showCenter(
                                          '题库只有${mDataEq!.dxNum}道单选题');
                                      setState(() {
                                        singleZJText!.text =
                                            mDataEq!.dxNum.toString();
                                      });
                                    }
                                    allZJ = (singleZJText!.text.isNotEmpty
                                            ? int.parse(singleZJText!.text)
                                            : 0) +
                                        (judgmentZJText!.text.isNotEmpty
                                            ? int.parse(judgmentZJText!.text)
                                            : 0);
                                  });
                                },
                              ),
                            )
                          ]),
                          Row(children: [
                            const Text('判断题数', style: TextStyle(fontSize: 14)),
                            SizedBox(
                              width: 40,
                              height: 30,
                              child: TextFormField(
                                textAlign: TextAlign.center,
                                inputFormatters: [
                                  FilteringTextInputFormatter.digitsOnly,
                                  LengthLimitingTextInputFormatter(3),
                                ],
                                focusNode: judgmentZJFocusNode,
                                controller: judgmentZJText,
                                onChanged: (num) {
                                  setState(() {
                                    if (num.isEmpty) {
                                      num = '0';
                                    }
                                    if (mDataEq != null &&
                                        int.parse(num) > mDataEq!.pdNum!) {
                                      ToastUtils.showCenter(
                                          '题库只有${mDataEq!.pdNum}道判断题');
                                      setState(() {
                                        judgmentZJText!.text =
                                            mDataEq!.pdNum.toString();
                                      });
                                    }

                                    allZJ = (judgmentZJText!.text.isNotEmpty
                                            ? int.parse(judgmentZJText!.text)
                                            : 0) +
                                        (singleZJText!.text.isNotEmpty
                                            ? int.parse(singleZJText!.text)
                                            : 0);
                                  });
                                },
                              ),
                            )
                          ]),
                          Text('总题数: ${allZJ.toString()}',
                              style: const TextStyle(
                                  color: Colors.grey, fontSize: 14)),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
              const SizedBox(height: 10),
              Container(
                padding: const EdgeInsets.only(
                    left: 5, top: 10, right: 5, bottom: 10),
                decoration: const BoxDecoration(
                  color: ColorConst.grayf5Color,
                  borderRadius: BorderRadius.all(Radius.circular(10)),
                ),
                child: Column(
                  children: [
                    const Row(children: [
                      Icon(Icons.touch_app,
                          color: ColorConst.orangeColor, size: 15),
                      Text('安全员', style: TextStyle(fontSize: 14))
                    ]),
                    const SizedBox(height: 5),
                    if (mUnitPersonListBo != null &&
                        userSafetyOfficerList!.isEmpty) ...{
                      Container(
                        padding: const EdgeInsets.only(
                            left: 0, top: 15, right: 0, bottom: 15),
                        child: const Text(
                          "该单位暂无录入（质量）安全员",
                          style: TextStyle(
                              color: ColorConst.blueColor,
                              fontWeight: FontWeight.bold),
                        ),
                      )
                    },
                    buildSafetyOfficerListView(),
                    const SizedBox(height: 10),
                    Container(
                      padding: const EdgeInsets.only(
                          left: 5, top: 0, right: 5, bottom: 0),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Row(children: [
                            const Text('单选题数', style: TextStyle(fontSize: 14)),
                            SizedBox(
                              width: 40,
                              height: 30,
                              child: TextFormField(
                                textAlign: TextAlign.center,
                                inputFormatters: [
                                  FilteringTextInputFormatter.digitsOnly,
                                  LengthLimitingTextInputFormatter(3),
                                ],
                                focusNode: singleAQYFocusNode,
                                controller: singleAQYText,
                                onChanged: (num) {
                                  setState(() {
                                    if (num.isEmpty) {
                                      num = '0';
                                    }
                                    if (mDataEq != null &&
                                        int.parse(num) > mDataEq!.dxNum!) {
                                      ToastUtils.showCenter(
                                          '题库只有${mDataEq!.dxNum}道单选题');
                                      setState(() {
                                        singleAQYText!.text =
                                            mDataEq!.dxNum.toString();
                                      });
                                    }
                                    allAQY = (singleAQYText!.text.isNotEmpty
                                            ? int.parse(singleAQYText!.text)
                                            : 0) +
                                        (judgmentAQYText!.text.isNotEmpty
                                            ? int.parse(judgmentAQYText!.text)
                                            : 0);
                                  });
                                },
                              ),
                            )
                          ]),
                          Row(children: [
                            const Text('判断题数', style: TextStyle(fontSize: 14)),
                            SizedBox(
                              width: 40,
                              height: 30,
                              child: TextFormField(
                                textAlign: TextAlign.center,
                                inputFormatters: [
                                  FilteringTextInputFormatter.digitsOnly,
                                  LengthLimitingTextInputFormatter(3)
                                ],
                                focusNode: judgmentAQYFocusNode,
                                controller: judgmentAQYText,
                                onChanged: (num) {
                                  setState(() {
                                    if (num.isEmpty) {
                                      num = '0';
                                    }
                                    if (mDataEq != null &&
                                        int.parse(num) > mDataEq!.pdNum!) {
                                      ToastUtils.showCenter(
                                          '题库只有${mDataEq!.pdNum}道判断题');
                                      setState(() {
                                        judgmentAQYText!.text =
                                            mDataEq!.pdNum.toString();
                                      });
                                    }
                                    allAQY = (judgmentAQYText!.text.isNotEmpty
                                            ? int.parse(judgmentAQYText!.text)
                                            : 0) +
                                        (singleAQYText!.text.isNotEmpty
                                            ? int.parse(singleAQYText!.text)
                                            : 0);
                                  });
                                },
                              ),
                            )
                          ]),
                          Text('总题数: ${allAQY.toString()}',
                              style: const TextStyle(
                                  color: Colors.grey, fontSize: 14)),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
              buildSubmit()
            ],
          )
        ],
      ),
    );
  }

  ListView buildSafetyDirectorListView() {
    return ListView.builder(
      shrinkWrap: true,
      physics: const NeverScrollableScrollPhysics(),
      padding: const EdgeInsets.only(top: 0, left: 0, bottom: 0, right: 0),
      itemCount: userSafetyDirectorList!.length,
      // 列表项数量
      itemBuilder: (context, index) {
        return GestureDetector(
          onTap: () {
            setState(() {
              ///当前状态是否禁止选中 true 可选 可以操作
              if (userSafetyDirectorList![index].isUserSafetyDirectorChecked!) {
                ///如果当前选择状态为 true，选中
                if (userSafetyDirectorList![index].isChecked!) {
                  userSafetyDirectorList![index].isChecked = false;
                  for (var i = 0; i < userSafetyOfficerList!.length; i++) {
                    ///安全总监--->判断安全员是否有相同人员
                    if (userSafetyDirectorList![index].id ==
                        userSafetyOfficerList![i].id) {
                      userSafetyOfficerList![i].isUserSafetyOfficerChecked =
                          true;
                    }
                  }
                } else {
                  ///未选中
                  userSafetyDirectorList![index].isChecked = true;
                  for (var i = 0; i < userSafetyOfficerList!.length; i++) {
                    ///安全总监--->判断安全员是否有相同人员
                    if (userSafetyDirectorList![index].id ==
                        userSafetyOfficerList![i].id) {
                      userSafetyOfficerList![i].isUserSafetyOfficerChecked =
                          false;
                    }
                  }
                }
              } else {
                ///禁止选中
              }
            });
          },
          child: Container(
            height: 40,
            decoration: BoxDecoration(
              color: userSafetyDirectorList![index].isChecked!
                  ? Colors.grey.withOpacity(0.1)
                  : Colors.transparent,
              borderRadius: const BorderRadius.all(Radius.circular(5)),
            ),
            child: Row(
              children: [
                Checkbox(
                  value: userSafetyDirectorList![index]
                          .isUserSafetyDirectorChecked!
                      ? userSafetyDirectorList![index].isChecked
                      : false,
                  side: MaterialStateBorderSide.resolveWith(
                    (Set<MaterialState> states) {
                      //设置未选中为灰色
                      return userSafetyDirectorList![index]
                              .isUserSafetyDirectorChecked!
                          ? null
                          : const BorderSide(width: 2, color: Colors.black12);
                    },
                  ),
                  onChanged: userSafetyDirectorList![index]
                          .isUserSafetyDirectorChecked!
                      ? (value) {
                          if (value != null) {
                            setState(() {
                              ///当前状态是否禁止选中 true 可选 可以操作
                              if (userSafetyDirectorList![index]
                                  .isUserSafetyDirectorChecked!) {
                                ///如果当前选择状态为 true，选中
                                if (userSafetyDirectorList![index].isChecked!) {
                                  userSafetyDirectorList![index].isChecked =
                                      false;
                                  for (var i = 0;
                                      i < userSafetyOfficerList!.length;
                                      i++) {
                                    ///安全总监--->判断安全员是否有相同人员
                                    if (userSafetyDirectorList![index].id ==
                                        userSafetyOfficerList![i].id) {
                                      userSafetyOfficerList![i]
                                          .isUserSafetyOfficerChecked = true;
                                    }
                                  }
                                } else {
                                  ///未选中
                                  userSafetyDirectorList![index].isChecked =
                                      true;
                                  for (var i = 0;
                                      i < userSafetyOfficerList!.length;
                                      i++) {
                                    ///安全总监--->判断安全员是否有相同人员
                                    if (userSafetyDirectorList![index].id ==
                                        userSafetyOfficerList![i].id) {
                                      userSafetyOfficerList![i]
                                          .isUserSafetyOfficerChecked = false;
                                    }
                                  }
                                }
                              } else {
                                ///禁止选中
                              }
                            });
                          }
                        }
                      : null,
                ),
                Text(userSafetyDirectorList![index].name!,
                    style: TextStyle(
                        color: userSafetyDirectorList![index]
                                .isUserSafetyDirectorChecked!
                            ? Colors.black
                            : Colors.black12))
              ],
            ),
          ),
        );
      },
    );
  }

  ListView buildSafetyOfficerListView() {
    return ListView.builder(
      shrinkWrap: true,
      physics: const NeverScrollableScrollPhysics(),
      padding: const EdgeInsets.only(top: 0, left: 0, bottom: 0, right: 0),
      itemCount: userSafetyOfficerList!.length,
      // 列表项数量
      itemBuilder: (context, index) {
        return InkWell(
          onTap: () {
            setState(() {
              ///当前状态是否禁止选中 true 可选 可以操作
              if (userSafetyOfficerList![index].isUserSafetyOfficerChecked!) {
                ///如果当前选择状态为 true，选中
                if (userSafetyOfficerList![index].isChecked!) {
                  userSafetyOfficerList![index].isChecked = false;
                  for (var i = 0; i < userSafetyDirectorList!.length; i++) {
                    ///安全总监--->判断安全员是否有相同人员
                    if (userSafetyOfficerList![index].id ==
                        userSafetyDirectorList![i].id) {
                      userSafetyDirectorList![i].isUserSafetyDirectorChecked =
                          true;
                    }
                  }
                } else {
                  ///未选中
                  userSafetyOfficerList![index].isChecked = true;
                  for (var i = 0; i < userSafetyDirectorList!.length; i++) {
                    ///安全总监--->判断安全员是否有相同人员
                    if (userSafetyOfficerList![index].id ==
                        userSafetyDirectorList![i].id) {
                      userSafetyDirectorList![i].isUserSafetyDirectorChecked =
                          false;
                    }
                  }
                }
              }
            });
          },
          child: Container(
            height: 40,
            decoration: BoxDecoration(
              color: userSafetyOfficerList![index].isChecked!
                  ? Colors.grey.withOpacity(0.3)
                  : Colors.transparent,
              borderRadius: const BorderRadius.all(Radius.circular(5)),
            ),
            child: Row(
              children: [
                Checkbox(
                  value:
                      userSafetyOfficerList![index].isUserSafetyOfficerChecked!
                          ? userSafetyOfficerList![index].isChecked
                          : false,
                  side: MaterialStateBorderSide.resolveWith(
                    (Set<MaterialState> states) {
                      //设置未选中为灰色
                      return userSafetyOfficerList![index]
                              .isUserSafetyOfficerChecked!
                          ? null
                          : const BorderSide(width: 2, color: Colors.black12);
                    },
                  ),
                  onChanged: userSafetyOfficerList![index]
                          .isUserSafetyOfficerChecked!
                      ? (value) {
                          if (value != null) {
                            setState(() {
                              ///当前状态是否禁止选中 true 可选 可以操作
                              if (userSafetyOfficerList![index]
                                  .isUserSafetyOfficerChecked!) {
                                ///如果当前选择状态为 true，选中
                                if (userSafetyOfficerList![index].isChecked!) {
                                  userSafetyOfficerList![index].isChecked =
                                      false;
                                  for (var i = 0;
                                      i < userSafetyDirectorList!.length;
                                      i++) {
                                    ///安全总监--->判断安全员是否有相同人员
                                    if (userSafetyOfficerList![index].id ==
                                        userSafetyDirectorList![i].id) {
                                      userSafetyDirectorList![i]
                                          .isUserSafetyDirectorChecked = true;
                                    }
                                  }
                                } else {
                                  ///未选中
                                  userSafetyOfficerList![index].isChecked =
                                      true;
                                  for (var i = 0;
                                      i < userSafetyDirectorList!.length;
                                      i++) {
                                    ///安全总监--->判断安全员是否有相同人员
                                    if (userSafetyOfficerList![index].id ==
                                        userSafetyDirectorList![i].id) {
                                      userSafetyDirectorList![i]
                                          .isUserSafetyDirectorChecked = false;
                                    }
                                  }
                                }
                              }
                            });
                          }
                        }
                      : null,
                ),
                Text(userSafetyOfficerList![index].name!,
                    style: TextStyle(
                        color: userSafetyOfficerList![index]
                                .isUserSafetyOfficerChecked!
                            ? Colors.black
                            : Colors.black12))
              ],
            ),
          ),
        );
      },
    );
  }

  Container buildTopTitle(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(top: 50),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          IconButton(
            onPressed: () {
              Navigator.of(context).pop();
            },
            icon: const Icon(Icons.arrow_back, color: Colors.white),
            iconSize: 30,
          ),
          Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              Container(
                  margin: const EdgeInsets.only(top: 5),
                  child: const Text(
                    '考核设置',
                    style: TextStyle(
                        fontSize: 23,
                        color: Colors.white,
                        fontWeight: FontWeight.bold),
                  )),
              Container(
                  height: 3,
                  width: 50,
                  alignment: Alignment.topLeft,
                  margin: const EdgeInsets.only(top: 3, bottom: 3),
                  decoration: const BoxDecoration(
                    color: Colors.white54,
                    borderRadius: BorderRadius.all(Radius.circular(5)),
                  )),
              const Text(
                '',
                style: TextStyle(fontSize: 12, color: Colors.white),
              ),
            ],
          ),
        ],
      ),
    );
  }

  ///交卷
  Container buildSubmit() {
    return Container(
        margin: const EdgeInsets.only(top: 30, bottom: 0),
        padding: const EdgeInsets.only(left: 20, right: 20, top: 15, bottom: 0),
        width: double.infinity,
        decoration: const BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.all(Radius.circular(5)),
        ),
        child: GradientButton(
            tapCallback: () {
              if (unitText!.text.isEmpty) {
                ToastUtils.showCenter('选择单位名称');
                return;
              }
              if (equipmentText!.text.isEmpty) {
                ToastUtils.showCenter('选择设备类型');
                return;
              }

              if (userSafetyDirectorList!.isEmpty &&
                  userSafetyOfficerList!.isEmpty) {
                ToastUtils.showCenter('没有可选的\n【安全总监】\n【安全员】\n无法提交');
                return;
              }

              bool isSafety = false;
              bool isSafety1 = false;
              bool isSafety2 = false;

              for (var i = 0; i < userSafetyDirectorList!.length; i++) {
                if (userSafetyDirectorList![i].isChecked!) {
                  isSafety = true;
                  isSafety1 = true;
                }
              }
              for (var i = 0; i < userSafetyOfficerList!.length; i++) {
                if (userSafetyOfficerList![i].isChecked!) {
                  isSafety = true;
                  isSafety2 = true;
                }
              }

              if (!isSafety) {
                ToastUtils.showCenter('至少选择一个\n【安全总监】\n【安全员】');
                return;
              }

              if (isSafety1) {
                if (allZJ == 0) {
                  ToastUtils.showCenter('【安全总监】总题数不能为 0');
                  return;
                }
              }
              if (isSafety2) {
                if (allAQY == 0) {
                  ToastUtils.showCenter('【安全员】总题数不能为 0');
                  return;
                }
              }

              Get.dialog(AlertDialog(
                title: const Text("温馨提示"),
                content: const Text("您确定要提交考核吗？"),
                actionsPadding: const EdgeInsets.only(
                    left: 0, top: 0, bottom: 10, right: 20),
                contentPadding: const EdgeInsets.only(
                    left: 20, top: 0, bottom: 10, right: 20),
                titlePadding: const EdgeInsets.only(
                    left: 20, top: 20, bottom: 10, right: 20),
                shape: const RoundedRectangleBorder(
                    // 这里设置shape属性
                    borderRadius: BorderRadius.all(Radius.circular(10.0))),
                actions: <Widget>[
                  TextButton(
                    child: const Text("取消", style: TextStyle(fontSize: 16)),
                    onPressed: () {
                      Get.back();
                    },
                  ),
                  TextButton(
                    child: const Text("确定", style: TextStyle(fontSize: 16)),
                    onPressed: () {
                      //关闭弹窗
                      Get.back();
                      // printLog(
                      //     "《考核-交卷》提交json数据----->${json.encode(examineQuestionsBo)}");

                      ExamSettingSubmitBo mExamSettingSubmitBo =
                          ExamSettingSubmitBo();
                      // 安全主管判断题数
                      mExamSettingSubmitBo.aqzgPdNum =
                          judgmentZJText!.text.isNotEmpty
                              ? int.parse(judgmentZJText!.text)
                              : 0;
                      // 安全主管选择题数
                      mExamSettingSubmitBo.aqzgXzNum =
                          singleZJText!.text.isNotEmpty
                              ? int.parse(singleZJText!.text)
                              : 0;
                      // 安全员判断题数
                      mExamSettingSubmitBo.aqyPdNum =
                          judgmentAQYText!.text.isNotEmpty
                              ? int.parse(judgmentAQYText!.text)
                              : 0;
                      // 安全员选择题数
                      mExamSettingSubmitBo.aqyXzNum =
                          singleAQYText!.text.isNotEmpty
                              ? int.parse(singleAQYText!.text)
                              : 0;
                      mExamSettingSubmitBo.type = mEquiList!.id;
                      List<String>? aqzgIds = [];
                      for (var i = 0; i < userSafetyDirectorList!.length; i++) {
                        if (userSafetyDirectorList![i].isChecked!) {
                          aqzgIds.add(userSafetyDirectorList![i].id.toString());
                        }
                      }
                      mExamSettingSubmitBo.aqzgIds = aqzgIds;

                      List<String>? aqyIds = [];
                      for (var i = 0; i < userSafetyOfficerList!.length; i++) {
                        if (userSafetyOfficerList![i].isChecked!) {
                          aqyIds.add(userSafetyOfficerList![i].id.toString());
                        }
                      }
                      mExamSettingSubmitBo.aqyIds = aqyIds;
                      mExamSettingSubmitBo.unitId = mOfficeList!.id;
                      HttpUtils.getExamSettingSubmit(
                              context, mExamSettingSubmitBo)
                          .then((value) {
                        BaseModel bo = value;
                        if (mounted) {
                          setState(() {
                            ToastUtils.showCenter(bo.msg);
                            Get.back(result: true);
                          });
                        }
                      });
                    },
                  ),
                ],
              ));
            },
            width: 300,
            height: 40,
            borderRadius: const BorderRadius.only(
                topLeft: Radius.circular(10),
                topRight: Radius.circular(20),
                bottomLeft: Radius.circular(20),
                bottomRight: Radius.circular(10)),
            disable: false,
            colors: const [ColorConst.blueColor, ColorConst.blue1Color],
            child: const Text(
              "提交",
              style: TextStyle(fontSize: 14, color: ColorConst.whiteColor),
            )));
  }
}
