import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/common/edgeInsets_const.dart';
import 'package:special_equipment_flutter/dio/http_utils.dart';
import 'package:special_equipment_flutter/model/exam/overseer_history_details_bo.dart';
import 'package:special_equipment_flutter/model/exam/overseer_history_information_bo.dart';
import 'package:special_equipment_flutter/utils/size_config.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';
import 'package:special_equipment_flutter/utils/time_util.dart';
import 'package:special_equipment_flutter/utils/toast_utils.dart';
import 'package:special_equipment_flutter/widgets/divider_custom.dart';

import '../../widgets/app_bar/custom_app_bar.dart';

///监察记录详情
class OverseerHistroyDetailsPage extends StatefulWidget {
  var arguments = Get.arguments;

  OverseerHistroyDetailsPage({super.key});

  @override
  State<OverseerHistroyDetailsPage> createState() =>
      _OverseerHistroyDetailsPageState();
}

class _OverseerHistroyDetailsPageState
    extends State<OverseerHistroyDetailsPage> {
  String? id;
  OverseerHistoryInformationBo? mOverseerHistoryInformationBo;

  Data? data;

  OverseerHistoryDetailsBo? mOverseerHistoryDetailsBo =
      OverseerHistoryDetailsBo();
  List<DataHistoryDetails>? rowList = [];

  @override
  void initState() {
    id = widget.arguments['id'];
    getOverseerHistoryInformationDetails();
    getOverseerHistoryDetails();
    super.initState();
  }

  ///获取监察记录基本信息
  void getOverseerHistoryInformationDetails() {
    HttpUtils.getPapers2(context, StorageUtil.getInstance().getUserId(), id!)
        .then((value) {
      mOverseerHistoryInformationBo = value;
      if (mounted) {
        setState(() {
          data = mOverseerHistoryInformationBo!.data;
        });
      }
    });
  }

  ///获取监察记录详情
  void getOverseerHistoryDetails() {
    HttpUtils.getExamPersonData(context, id!).then((value) {
      mOverseerHistoryDetailsBo = value;
      if (mounted) {
        setState(() {
          rowList = mOverseerHistoryDetailsBo!.data;
        });
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        Get.back(result: true);
        return true; // 控制是否可以侧滑返回，true为允许，false为不允许
      },
      child: Scaffold(
          backgroundColor: ColorConst.grayf5Color,
          appBar: AppBarCustom(
            text: '监察记录详情',
            height: 50,
          ),
          body: CustomScrollView(
            primary: false,
            shrinkWrap: true,
            slivers: <Widget>[
              SliverToBoxAdapter(
                child: Card(
                  elevation: 0,
                  margin: const EdgeInsets.only(
                      left: 0, right: 0, top: 15, bottom: 0),
                  color: Colors.white,
                  shape: const RoundedRectangleBorder(
                    borderRadius: BorderRadius.all(Radius.circular(5)),
                  ),
                  child: Column(
                    children: [
                      buildTitleContainer(Icons.insert_drive_file_outlined,
                          ColorConst.blueColor, '基本信息', Colors.black54),
                      Container(
                        padding: const EdgeInsets.only(
                            left: 40, right: 15, top: 0, bottom: 15),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: <Widget>[
                            Text(data != null ? data!.officeName! : '',
                                style: const TextStyle(
                                    fontWeight: FontWeight.bold,
                                    fontSize: 16,
                                    color: Colors.black54)),

                            ///分割线
                            DividerCustom(Colors.grey[300], 8, 8, 0, 0),

                            Row(children: [
                              const Text('设备类型：',
                                  style: TextStyle(
                                      fontSize: 14, color: Colors.black54)),
                              Text(data != null ? data!.typeName! : '',
                                  style: TextStyle(
                                      fontSize: 14, color: Colors.black54)),
                            ]),
                            const SizedBox(height: 5),
                            Text.rich(
                                softWrap: true,
                                TextSpan(children: [
                                  const TextSpan(
                                      text: "考核人数：",
                                      style: TextStyle(
                                          fontSize: 14, color: Colors.black54)),
                                  TextSpan(
                                      text: data != null
                                          ? data!.count.toString()
                                          : '',
                                      style: const TextStyle(
                                          fontSize: 18,
                                          fontWeight: FontWeight.bold)),
                                  const TextSpan(
                                      text: "人",
                                      style: TextStyle(
                                          fontSize: 14, color: Colors.black54)),
                                ])),
                            const SizedBox(height: 5),
                            Text.rich(
                                softWrap: true,
                                TextSpan(children: [
                                  const TextSpan(
                                      text: "考核状态：",
                                      style: TextStyle(
                                          fontSize: 14, color: Colors.black54)),
                                  const TextSpan(
                                      text: "已完成 ",
                                      style: TextStyle(
                                          color: ColorConst.greenColor)),
                                  TextSpan(
                                      text: data != null
                                          ? data!.complete.toString()
                                          : '',
                                      style: const TextStyle(
                                          color: ColorConst.greenColor,
                                          fontSize: 18,
                                          fontWeight: FontWeight.bold)),
                                  const TextSpan(
                                      text: " 人",
                                      style: TextStyle(
                                          color: ColorConst.greenColor)),
                                  if (data != null
                                      ? data!.incomplete != 0
                                      : true) ...[
                                    const TextSpan(
                                        text: "  |  ",
                                        style: TextStyle(
                                            color: ColorConst.greyD2Color)),
                                    const TextSpan(
                                        text: "进行中 ",
                                        style: TextStyle(
                                            color: ColorConst.red1BgColor)),
                                    TextSpan(
                                        text: data != null
                                            ? data!.incomplete.toString()
                                            : '',
                                        style: const TextStyle(
                                            color: ColorConst.red1BgColor,
                                            fontSize: 18,
                                            fontWeight: FontWeight.bold)),
                                    const TextSpan(
                                        text: " 人",
                                        style: TextStyle(
                                            color: ColorConst.red1BgColor)),
                                  ]
                                ])),
                            const SizedBox(height: 5),
                            Text.rich(
                                softWrap: true,
                                TextSpan(children: [
                                  const TextSpan(
                                      text: "考核时间：",
                                      style: TextStyle(
                                          fontSize: 14, color: Colors.black54)),
                                  TextSpan(
                                      text: timestampToDate2(
                                          data != null ? data!.createDate! : 0),
                                      style: const TextStyle(
                                          fontSize: 14, color: Colors.black54)),
                                ])),
                          ],
                        ),
                      )
                    ],
                  ),
                ),
              ),
              SliverToBoxAdapter(
                child: Card(
                  elevation: 0,
                  margin: const EdgeInsets.only(
                      left: 0, right: 0, top: 15, bottom: 0),
                  color: Colors.white,
                  shape: const RoundedRectangleBorder(
                    borderRadius: BorderRadius.all(Radius.circular(5)),
                  ),
                  child: Column(
                    children: [
                      buildTitleContainer(Icons.person_pin,
                          ColorConst.blueColor, '考核人', Colors.black54),
                      Container(
                        padding: const EdgeInsets.only(
                            left: 30, right: 15, top: 0, bottom: 15),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: <Widget>[
                            //文章列表
                            ListView.separated(
                              shrinkWrap: true,
                              padding: const EdgeInsets.symmetric(
                                  horizontal:
                                      EdgeInsetsConst.padding_horizontal),
                              physics: const NeverScrollableScrollPhysics(),
                              itemBuilder: (BuildContext context, int index) {
                                return Container(
                                  padding: const EdgeInsets.only(
                                      left: 10, right: 10, top: 10, bottom: 10),
                                  margin: const EdgeInsets.only(
                                      left: 0, right: 0, top: 0, bottom: 5),
                                  decoration: BoxDecoration(
                                    color: rowList![index].adopt == "0"
                                        ? ColorConst.red4BgColor
                                        : Colors.green[50],
                                    borderRadius: const BorderRadius.all(
                                        Radius.circular(5)),
                                  ),
                                  child: Column(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.spaceBetween,
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Text(rowList![index].user!.name!,
                                              style: const TextStyle(
                                                  fontSize: 16,
                                                  color: Colors.black54,
                                                  fontWeight: FontWeight.bold)),
                                          Text(
                                              rowList![index].adopt == "0"
                                                  ? "进行中"
                                                  : '已完成',
                                              style: TextStyle(
                                                  fontSize: 14,
                                                  color: rowList![index]
                                                              .adopt ==
                                                          "0"
                                                      ? ColorConst.red1BgColor
                                                      : ColorConst.greenColor,
                                                  fontWeight: FontWeight.bold)),
                                        ],
                                      ),
                                      Container(
                                        height: 3,
                                        width: 48,
                                        margin: const EdgeInsets.only(top: 2),
                                        decoration: BoxDecoration(
                                          color: rowList![index].adopt == "0"
                                              ? Colors.red
                                              : Colors.green,
                                          borderRadius: const BorderRadius.all(
                                              Radius.circular(5)),
                                        ),
                                      ),
                                      Container(
                                        margin: const EdgeInsets.only(top: 5),
                                        child: Text.rich(
                                            softWrap: true,
                                            TextSpan(children: [
                                              const TextSpan(
                                                  text: "考核人员身份：",
                                                  style: TextStyle(
                                                      color: Colors.black54)),
                                              TextSpan(
                                                  text: rowList![index]
                                                              .positionType ==
                                                          '1'
                                                      ? '安全总监'
                                                      : '安全员',
                                                  style: const TextStyle(
                                                      color: Colors.black54))
                                            ])),
                                      ),
                                      if (rowList![index].adopt == "1") ...[
                                        Container(
                                          margin: const EdgeInsets.only(top: 5),
                                          child: Text.rich(
                                              softWrap: true,
                                              TextSpan(children: [
                                                const TextSpan(
                                                    text: "考核得分 ",
                                                    style: TextStyle(
                                                        color: Colors.black54)),
                                                TextSpan(
                                                    text: rowList![index]
                                                        .score!
                                                        .toString(),
                                                    style: const TextStyle(
                                                        fontSize: 16,
                                                        color: ColorConst
                                                            .greenColor,
                                                        fontWeight:
                                                            FontWeight.bold)),
                                                const TextSpan(
                                                    text: " 分",
                                                    style: TextStyle(
                                                        color: Colors.black54)),
                                              ])),
                                        )
                                      ]
                                    ],
                                  ),
                                );
                              },
                              itemCount: rowList!.length,
                              separatorBuilder:
                                  (BuildContext context, int index) {
                                return const SizedBox(
                                  height: 0,
                                );
                              },
                            ),
                          ],
                        ),
                      )
                    ],
                  ),
                ),
              ),
              // SliverToBoxAdapter(
              //   child: Card(
              //     elevation: 5,
              //     shadowColor: ColorConst.greenColor,
              //     margin: const EdgeInsets.only(
              //         left: 0, right: 0, top: 15, bottom: 0),
              //     color: Colors.white,
              //     shape: const RoundedRectangleBorder(
              //       borderRadius: BorderRadius.all(Radius.circular(5)),
              //     ),
              //     child: Column(
              //       children: [
              //         buildTitleContainer(Icons.event_available,
              //             ColorConst.greenColor, '已完成', ColorConst.greenColor),
              //         Container(
              //           padding: const EdgeInsets.only(
              //               left: 40, right: 15, top: 0, bottom: 15),
              //           child: Column(
              //             crossAxisAlignment: CrossAxisAlignment.start,
              //             children: <Widget>[
              //
              //
              //
              //             ],
              //           ),
              //         )
              //       ],
              //     ),
              //   ),
              // )
            ],
          )),
    );
  }

  Container buildTitleContainer(
      IconData imageAsset, Color imageColor, String name, Color nameColor) {
    return Container(
        margin: const EdgeInsets.only(top: 0, left: 0, right: 0),
        padding: const EdgeInsets.all(10),
        decoration: const BoxDecoration(
          // color: Colors.white,
          borderRadius: BorderRadius.all(Radius.circular(5)),
        ),
        child: Column(
          children: [
            Row(
              children: [
                Icon(
                  imageAsset,
                  color: imageColor,
                ),
                const SizedBox(width: 5),
                Text(
                  name,
                  style: TextStyle(
                      color: nameColor,
                      fontSize: SizeConfig.isIpad()! ? 25 : 14,
                      fontWeight: FontWeight.bold),
                ),
              ],
            ),
            // buildTitle(Icons.equalizer, '考核练习'),
            // buildSliverGridExamination()
          ],
        ));
  }
}
