import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:special_equipment_flutter/dio/http_utils.dart';
import 'package:special_equipment_flutter/model/exam/equipment_list_bo.dart';
import 'package:special_equipment_flutter/model/exam/exam_unit_list.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';
import 'package:special_equipment_flutter/widgets/app_bar/custom_app_bar.dart';

///设备选择
class EquipmentListPage extends StatefulWidget {
  var arguments = Get.arguments;

  EquipmentListPage({super.key});

  @override
  State<EquipmentListPage> createState() => _EquipmentListPageState();
}

class _EquipmentListPageState extends State<EquipmentListPage> {
  List<EquiList>? officeLists = [];
  List<EquiList>? filterOfficeLists = [];
  var officeId = '';

  @override
  void initState() {
    super.initState();
    officeId = widget.arguments['officeId'];
    getEquipmentList();
  }

  ///获取设备类型
  void getEquipmentList() {
    HttpUtils.getEquipmentList(context, officeId).then((value) {
      EquipmentListBo listBo = value;
      if (mounted) {
        setState(() {
          officeLists = listBo.list;
          filterOfficeLists = officeLists;
        });
      }
    });
  }

  void _filterData(String query) {
    setState(() {
      filterOfficeLists = officeLists!.where((EquiList item) {
        return item.name!.toLowerCase().contains(query.toLowerCase());
      }).toList();
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBarCustom(text: '选择设备', height: 50),
      body: Column(
        children: [
          const SizedBox(height: 10),
          Container(
            margin: const EdgeInsets.only(left: 10, right: 10),
            decoration: BoxDecoration(
              color: Colors.grey[200],
              borderRadius: BorderRadius.circular(10),
            ),
            child: Row(
              children: [
                IconButton(
                  icon: const Icon(Icons.search),
                  onPressed: () {
                    // 处理搜索逻辑
                  },
                ),
                Expanded(
                  child: TextField(
                    onChanged: (value) {
                      _filterData(value);
                    },
                    decoration: const InputDecoration(
                      hintText: '请输入搜索关键字',
                      border: InputBorder.none,
                    ),
                  ),
                ),
              ],
            ),
          ),
          const SizedBox(height: 10),
          Flexible(
            child: ListView.builder(
              shrinkWrap: true,
              padding:
                  const EdgeInsets.only(top: 0, left: 0, bottom: 0, right: 0),
              itemCount: filterOfficeLists!.length,
              // 列表项数量
              itemBuilder: (context, index) {
                return GestureDetector(
                  onTap: () {
                    setState(() {
                      Get.back(result: filterOfficeLists![index]);
                    });
                  },
                  child: Container(
                    padding: const EdgeInsets.only(
                        left: 30, right: 15, top: 10, bottom: 10),
                    child: Text(
                      filterOfficeLists![index].name!,
                      style: const TextStyle(fontSize: 18),
                    ),
                  ),
                );
              },
            ),
          ),
        ],
      ),
    );
  }
}
