// import 'package:flutter/material.dart';
// import 'package:get/get.dart';
// import 'package:special_equipment_flutter/common/color_const.dart';
// import 'package:special_equipment_flutter/dio/http_utils.dart';
// import 'package:special_equipment_flutter/model/exam/equipment_list_bo.dart';
// import 'package:special_equipment_flutter/model/exam/exam_unit_list.dart';
// import 'package:special_equipment_flutter/utils/storage_util.dart';
// import 'package:special_equipment_flutter/utils/toast_utils.dart';
// import 'package:special_equipment_flutter/widgets/app_bar/custom_app_bar.dart';
// import 'package:special_equipment_flutter/widgets/custom_button.dart';
//
// ///设备选择
// class EquipmentListPage extends StatefulWidget {
//   var arguments = Get.arguments;
//
//   EquipmentListPage({super.key});
//
//   @override
//   State<EquipmentListPage> createState() => _EquipmentListPageState();
// }
//
// class _EquipmentListPageState extends State<EquipmentListPage> {
//   List<EquiList>? officeLists = [];
//   List<EquiList>? filterOfficeLists = [];
//   var officeId = '';
//
//   @override
//   void initState() {
//     super.initState();
//     officeId = widget.arguments['officeId'];
//     getEquipmentList();
//   }
//
//   ///获取设备类型
//   void getEquipmentList() {
//     HttpUtils.getEquipmentList(context, officeId).then((value) {
//       EquipmentListBo listBo = value;
//       if (mounted) {
//         setState(() {
//           officeLists = listBo.list;
//           filterOfficeLists = officeLists;
//         });
//       }
//     });
//   }
//
//   void _filterData(String query) {
//     setState(() {
//       filterOfficeLists = officeLists!.where((EquiList item) {
//         return item.name!.toLowerCase().contains(query.toLowerCase());
//       }).toList();
//     });
//   }
//
//   @override
//   Widget build(BuildContext context) {
//     return Scaffold(
//       appBar: AppBarCustom(text: '选择设备', height: 50),
//       body: Stack(
//         children: [
//           Column(
//             children: [
//               const SizedBox(height: 10),
//               Container(
//                 margin: const EdgeInsets.only(left: 10, right: 10),
//                 decoration: BoxDecoration(
//                   color: Colors.grey[200],
//                   borderRadius: BorderRadius.circular(10),
//                 ),
//                 child: Row(
//                   children: [
//                     IconButton(
//                       icon: const Icon(Icons.search),
//                       onPressed: () {
//                         // 处理搜索逻辑
//                       },
//                     ),
//                     Expanded(
//                       child: TextField(
//                         onChanged: (value) {
//                           _filterData(value);
//                         },
//                         decoration: const InputDecoration(
//                           hintText: '请输入搜索关键字',
//                           border: InputBorder.none,
//                         ),
//                       ),
//                     ),
//                   ],
//                 ),
//               ),
//               const SizedBox(height: 10),
//               Flexible(
//                 child: ListView.builder(
//                   shrinkWrap: true,
//                   padding: const EdgeInsets.only(
//                       top: 0, left: 0, bottom: 0, right: 0),
//                   itemCount: filterOfficeLists!.length,
//                   // 列表项数量
//                   itemBuilder: (context, index) {
//                     return InkWell(
//                       onTap: () {
//                         setState(() {
//                           filterOfficeLists![index].isChecked =
//                               !filterOfficeLists![index].isChecked;
//                         });
//                       },
//                       child: Container(
//                         padding: const EdgeInsets.only(
//                             left: 20, right: 20, top: 5, bottom: 5),
//                         child: Column(
//                           children: [
//                             Row(
//                               mainAxisAlignment: MainAxisAlignment.spaceBetween,
//                               children: [
//                                 Text(
//                                   filterOfficeLists![index].name!,
//                                   style: const TextStyle(fontSize: 18),
//                                 ),
//                                 Checkbox(
//                                   value: filterOfficeLists![index].isChecked,
//                                   onChanged: (value) {
//                                     if (value != null) {
//                                       setState(() {
//                                         filterOfficeLists![index].isChecked =
//                                             value;
//                                       });
//                                     }
//                                   },
//                                 ),
//                               ],
//                             ),
//                             Container(
//                               color: Colors.grey[200],
//                               height: 1,
//                               width: double.infinity,
//                             )
//                           ],
//                         ),
//                       ),
//                     );
//                   },
//                 ),
//               ),
//               buildSubmit()
//             ],
//           ),
//         ],
//       ),
//     );
//   }
//
//   ///提交
//   Container buildSubmit() {
//     return Container(
//         margin: const EdgeInsets.only(top: 20, bottom: 0),
//         padding: const EdgeInsets.only(left: 20, right: 20, top: 0, bottom: 20),
//         width: double.infinity,
//         decoration: const BoxDecoration(
//           color: Colors.white,
//           borderRadius: BorderRadius.all(Radius.circular(5)),
//         ),
//         child: GradientButton(
//             tapCallback: () {
//               bool isChecked = false;
//               List<EquiList>? selectList = [];
//               for (var i = 0; i < filterOfficeLists!.length; i++) {
//                 if (filterOfficeLists![i].isChecked) {
//                   isChecked = true;
//                   selectList.add(filterOfficeLists![i]);
//                 }
//               }
//               if (!isChecked) {
//                 ToastUtils.showCenter('至少选择一项内容');
//                 return;
//               }
//               Get.back(result: selectList);
//             },
//             width: 300,
//             height: 40,
//             borderRadius: const BorderRadius.only(
//                 topLeft: Radius.circular(10),
//                 topRight: Radius.circular(20),
//                 bottomLeft: Radius.circular(20),
//                 bottomRight: Radius.circular(10)),
//             disable: false,
//             colors: const [ColorConst.blueColor, ColorConst.blue1Color],
//             child: const Text(
//               "确定",
//               style: TextStyle(fontSize: 14, color: ColorConst.whiteColor),
//             )));
//   }
// }
