import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/ui/common/data.dart';
import 'package:special_equipment_flutter/utils/size_config.dart';

///公司账户：设置
class UnitGridList extends StatefulWidget {
  final void Function()? onTapUser;
  final void Function()? onTapEquipment;
  final void Function()? onTapUnit;

  const UnitGridList(
      {super.key, this.onTapUser, this.onTapEquipment, this.onTapUnit});

  @override
  State<UnitGridList> createState() => _UnitGridListState();
}

class _UnitGridListState extends State<UnitGridList>
    with TickerProviderStateMixin {
  late final AnimationController _controller;
  late final Animation<double> _animation;
  List<HomeMenuItem> checkItemSettingsList = [];

  @override
  void initState() {
    // TODO: implement initState
    super.initState();

    checkItemSettingsList.add(HomeMenuItem(
        image: 'assets/home/user_settings_icon.png', name: '用户设置'));
    checkItemSettingsList.add(HomeMenuItem(
        image: 'assets/home/equipment_settings_icon.png', name: '设备设置'));
    checkItemSettingsList.add(HomeMenuItem(
        image: 'assets/home/unit_settings_icon.png', name: '单位设置'));

    _controller = AnimationController(
      duration: const Duration(seconds: 2),
      vsync: this,
    )..forward();

    _animation = CurvedAnimation(
      parent: _controller,
      curve: Curves.bounceOut,
    );
  }

  @override
  Widget build(BuildContext context) {
    return SliverPadding(
      padding: const EdgeInsets.only(left: 0, right: 0, top: 0, bottom: 0),
      // 使用SliverGrid来创建GridView
      sliver: SliverGrid(
        gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: checkItemSettingsList.length,
          crossAxisSpacing: 1,
          mainAxisSpacing: 1,
          childAspectRatio: 1 / 0.83, //子项的宽高比，值越大高度越高
        ),
        delegate: SliverChildBuilderDelegate(
          (BuildContext context, int index) {
            return AnimatedBuilder(
              animation: _animation,
              builder: (context, child) {
                return Transform.scale(
                  scale: _animation.value,
                  child: buildSettingsListItem(index),
                );
              },
            );
          },
          childCount: checkItemSettingsList.length,
        ),
      ),
    );
  }

  InkWell buildSettingsListItem(index) {
    return InkWell(
      splashColor: ColorConst.green1Color,
      child: Column(
        // mainAxisAlignment: MainAxisAlignment.center,
        children: [
          SizedBox(height: SizeConfig.isIpad()! ? 40 : 15),
          Stack(
            alignment: Alignment.center,
            children: [
              Container(
                width: SizeConfig.isIpad()! ? 150 : 50,
                height: SizeConfig.isIpad()! ? 150 : 50,
                decoration: const BoxDecoration(
                  shape: BoxShape.circle, // 设定形状为圆形
                  gradient: LinearGradient(
                    begin: Alignment.topLeft,
                    end: Alignment.bottomRight,
                    stops: [0.4, 0.5],
                    colors: [ColorConst.orange1Color, ColorConst.orangeColor],
                  ),
                ),
              ),
              Image.asset(
                checkItemSettingsList[index].image,
                width: SizeConfig.isIpad()! ? 60 : 25,
                height: SizeConfig.isIpad()! ? 60 : 25,
              ),
              // Positioned(
              //   right: SizeConfig.isIpad()! ? 10 : 0,
              //   top: 0,
              //   child: Badge(
              //     largeSize: SizeConfig.isIpad()! ? 25 : 15,
              //     backgroundColor: Colors.red,
              //     isLabelVisible: checkItemSettingsList[index].isContains,
              //     label: Text(
              //       '',
              //       style: TextStyle(fontSize: SizeConfig.isIpad()! ? 18 : 8),
              //     ),
              //   ),
              // )
            ],
          ),
          buildBottomText(checkItemSettingsList[index].name),
        ],
      ),
      onTap: () {
        switch (index) {
          case 0:
            widget.onTapUser!();
            break;
          case 1:
            widget.onTapEquipment!();
            break;
          case 2:
            widget.onTapUnit!();
            break;
        }
      },
    );
  }

  //字
  Container buildBottomText(name, [color]) {
    return Container(
      height: SizeConfig.isIpad()! ? 40 : 20,
      margin: const EdgeInsets.only(top: 3),
      child: Text(
        name,
        style:
            TextStyle(fontSize: SizeConfig.isIpad()! ? 25 : 13, color: color),
      ),
    );
  }
}
