import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/model/device_list_bo.dart';
import 'package:special_equipment_flutter/model/find_charge_list_bo.dart';
import 'package:special_equipment_flutter/model/office_device.dart';
import 'package:special_equipment_flutter/utils/size_config.dart';
import 'package:special_equipment_flutter/widgets/divider_custom.dart';

class EquipmentPersonnelTable extends StatelessWidget {
  List<OfficeDtoLists>? deviceDataSyList = [], deviceDataScList = [];
  List<ChargeUserList>? chargeList = [];

  ///使用单位：点击主要负责人
  final void Function(List<ChargeUserList>? chargeList)? onTapSyCharge;

  ///使用单位：点击安全总监
  final void Function(OfficeDtoLists? value)? onTapSyDirector;

  ///使用单位：点击安全员
  final void Function(OfficeDtoLists? value)? onTapSyOfficer;

  ///生产单位：点击主要负责人
  final void Function(List<ChargeUserList>? chargeList)? onTapScCharge;

  ///生产单位：点击安全总监
  final void Function(OfficeDtoLists? value)? onTapScDirector;

  ///生产单位：点击安全员
  final void Function(OfficeDtoLists? value)? onTapScOfficer;

  EquipmentPersonnelTable(
      {super.key,
      this.deviceDataSyList,
      this.deviceDataScList,
      this.chargeList,
      this.onTapSyDirector,
      this.onTapSyOfficer,
      this.onTapSyCharge,
      this.onTapScDirector,
      this.onTapScOfficer,
      this.onTapScCharge});

  @override
  Widget build(BuildContext context) {
    return SliverToBoxAdapter(
        child: Container(
            margin: const EdgeInsets.only(top: 0, left: 8, right: 8),
            padding:
                const EdgeInsets.only(top: 10, bottom: 10, left: 5, right: 5),
            decoration: const BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.all(Radius.circular(5)),
            ),
            child: Column(
              children: [
                buildTitle(Icons.compare, '设备人员对比'),
                const SizedBox(height: 5),
                const Text(
                  '使用单位',
                  style: TextStyle(
                      fontWeight: FontWeight.bold,
                      color: ColorConst.blueColor,
                      fontSize: 16),
                ),
                const SizedBox(height: 10),
                Table(
                    border: TableBorder.all(color: ColorConst.blueColor),
                    textBaseline: TextBaseline.alphabetic,
                    defaultVerticalAlignment: TableCellVerticalAlignment.middle,
                    columnWidths: const {
                      0: FixedColumnWidth(130),
                      1: FixedColumnWidth(80),
                      2: FixedColumnWidth(65),
                      3: FixedColumnWidth(50)
                    },
                    children: [
                      TableRow(children: [
                        buildTableTitle(
                            name: '设备名称', color: ColorConst.blueColor),
                        buildTableTitle(
                            name: '主要负责人', color: ColorConst.blueColor),
                        buildTableTitle(
                            name: '安全总监', color: ColorConst.blueColor),
                        buildTableTitle(
                            name: '安全员', color: ColorConst.blueColor),
                      ]),
                      TableRow(children: [
                        Table(
                            border: TableBorder.all(
                                color: ColorConst.blueColor, width: 0.5),
                            children: [
                              for (var item in deviceDataSyList!) ...[
                                TableRow(children: [
                                  Center(
                                      child: Container(
                                          height: 30,
                                          padding: const EdgeInsets.only(
                                              top: 5, bottom: 5),
                                          child: Text(item.name!,
                                              style: const TextStyle(
                                                  fontSize: 14)))),
                                ]),
                              ],
                            ]),

                        ///使用单位：主要负责人内容
                        GestureDetector(
                          onTap: () {
                            onTapSyCharge!(chargeList);
                          },
                          child: Center(
                              child: Padding(
                            padding: const EdgeInsets.all(5.0),
                            child: Text(chargeList!.isNotEmpty ? '✔' : '✘',
                                style: TextStyle(
                                    fontSize: 13,
                                    color: chargeList!.isNotEmpty
                                        ? Colors.black
                                        : Colors.red)),
                          )),
                        ),

                        ///使用单位：安全总监内容
                        Table(
                            border: TableBorder.all(
                                color: ColorConst.blueColor, width: 0.5),
                            children: [
                              for (var item in deviceDataSyList!) ...[
                                TableRow(children: [
                                  GestureDetector(
                                    onTap: () {
                                      onTapSyDirector!(item);
                                    },
                                    child: Center(
                                        child: Container(
                                      height: 30,
                                      padding: const EdgeInsets.only(
                                          top: 5, bottom: 5),
                                      child: Text(
                                          item.safetyDirector!.isNotEmpty
                                              ? '✔'
                                              : '✘',
                                          style: TextStyle(
                                              fontSize: 13,
                                              color: item.safetyDirector!
                                                      .isNotEmpty
                                                  ? Colors.black
                                                  : Colors.red)),
                                    )),
                                  ),
                                ]),
                              ]
                            ]),

                        ///使用单位：安全员内容
                        Table(
                            border:
                                TableBorder.all(color: ColorConst.blueColor),
                            children: [
                              for (var item in deviceDataSyList!) ...[
                                TableRow(children: [
                                  GestureDetector(
                                    onTap: () {
                                      onTapSyOfficer!(item);
                                    },
                                    child: Center(
                                        child: Container(
                                      height: 30,
                                      padding: const EdgeInsets.only(
                                          top: 5, bottom: 5),
                                      child: Text(
                                          item.safetyOfficer!.isNotEmpty
                                              ? '✔'
                                              : '✘',
                                          style: TextStyle(
                                              fontSize: 13,
                                              color:
                                                  item.safetyOfficer!.isNotEmpty
                                                      ? Colors.black
                                                      : Colors.red)),
                                    )),
                                  ),
                                ]),
                              ]
                            ]),
                      ]),
                    ]),
                const SizedBox(height: 10),
                const Text(
                  '生产单位',
                  style: TextStyle(
                      fontWeight: FontWeight.bold,
                      color: ColorConst.orangeColor,
                      fontSize: 16),
                ),
                const SizedBox(height: 10),
                Table(
                    border: TableBorder.all(color: ColorConst.orangeColor),
                    textBaseline: TextBaseline.alphabetic,
                    defaultVerticalAlignment: TableCellVerticalAlignment.middle,
                    columnWidths: const {
                      0: FixedColumnWidth(130),
                      1: FixedColumnWidth(80),
                      2: FixedColumnWidth(65),
                      3: FixedColumnWidth(50)
                    },
                    children: [
                      TableRow(children: [
                        buildTableTitle(
                            name: '设备名称', color: ColorConst.orangeColor),
                        buildTableTitle(
                            name: '主要负责人', color: ColorConst.orangeColor),
                        buildTableTitle(
                            name: '安全总监', color: ColorConst.orangeColor),
                        buildTableTitle(
                            name: '安全员', color: ColorConst.orangeColor),
                      ]),
                      TableRow(children: [
                        Table(
                            border: TableBorder.all(
                                color: ColorConst.orangeColor, width: 0.5),
                            defaultVerticalAlignment:
                                TableCellVerticalAlignment.middle,
                            children: [
                              for (var item in deviceDataScList!) ...[
                                TableRow(children: [
                                  Center(
                                    child: Container(
                                        height: 30,
                                        padding: const EdgeInsets.only(
                                            top: 5, bottom: 5),
                                        child: Text(item.name!,
                                            style:
                                                const TextStyle(fontSize: 14))),
                                  ),
                                ]),
                              ],
                            ]),

                        ///生产单位：主要负责人内容
                        GestureDetector(
                          onTap: () {
                            onTapScCharge!(chargeList);
                          },
                          child: Center(
                              child: Padding(
                            padding: const EdgeInsets.all(5.0),
                            child: Text(chargeList!.isNotEmpty ? '✔' : '✘',
                                style: TextStyle(
                                    fontSize: 13,
                                    color: chargeList!.isNotEmpty
                                        ? Colors.black
                                        : Colors.red)),
                          )),
                        ),

                        ///生产单位：安全总监内容
                        Table(
                            border: TableBorder.all(
                                color: ColorConst.orangeColor, width: 0.5),
                            defaultVerticalAlignment:
                                TableCellVerticalAlignment.middle,
                            children: [
                              for (var item in deviceDataScList!) ...[
                                TableRow(children: [
                                  GestureDetector(
                                    onTap: () {
                                      onTapSyDirector!(item);
                                    },
                                    child: Center(
                                        child: Container(
                                      height: 30,
                                      padding: const EdgeInsets.only(
                                          top: 5, bottom: 5),
                                      child: Text(
                                          item.safetyDirector!.isNotEmpty
                                              ? '✔'
                                              : '✘',
                                          style: TextStyle(
                                              fontSize: 13,
                                              color: item.safetyDirector!
                                                      .isNotEmpty
                                                  ? Colors.black
                                                  : Colors.red)),
                                    )),
                                  ),
                                ]),
                              ]
                            ]),

                        ///生产单位：安全员内容
                        Table(
                            border:
                                TableBorder.all(color: ColorConst.orangeColor),
                            children: [
                              for (var item in deviceDataScList!) ...[
                                TableRow(children: [
                                  GestureDetector(
                                    onTap: () {
                                      onTapSyOfficer!(item);
                                    },
                                    child: Center(
                                        child: Container(
                                      height: 30,
                                      padding: const EdgeInsets.only(
                                          top: 5, bottom: 5),
                                      child: Text(
                                          item.safetyOfficer!.isNotEmpty
                                              ? '✔'
                                              : '✘',
                                          style: TextStyle(
                                              fontSize: 13,
                                              color:
                                                  item.safetyOfficer!.isNotEmpty
                                                      ? Colors.black
                                                      : Colors.red)),
                                    )),
                                  ),
                                ]),
                              ]
                            ]),
                      ]),
                    ])
              ],
            )));
  }

  Center buildTableTitle({color, name}) {
    return Center(
      child: Padding(
        padding: const EdgeInsets.only(top: 8, bottom: 8),
        child: Text(name,
            style: TextStyle(
                fontWeight: FontWeight.bold, color: color, fontSize: 14)),
      ),
    );
  }

  Column buildTitle(icon, title) {
    return Column(
      children: [
        Row(
          children: [
            Icon(
              icon,
              color: ColorConst.blueColor,
              size: SizeConfig.isIpad()! ? 35 : 18,
            ),
            const SizedBox(width: 5),
            Text(
              title,
              style: TextStyle(
                  color: Colors.black54,
                  fontSize: SizeConfig.isIpad()! ? 25 : 14,
                  fontWeight: FontWeight.bold),
            ),
          ],
        ),
        DividerCustom(Colors.grey[300], 10, 5, 5, 10),
      ],
    );
  }
}
