import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/model/find_charge_list_bo.dart';
import 'package:special_equipment_flutter/model/office_device.dart';
import 'package:special_equipment_flutter/utils/size_config.dart';
import 'package:special_equipment_flutter/widgets/divider_custom.dart';

class EquipmentPersonnelTable extends StatelessWidget {
  List<OfficeDtoLists>? deviceList = [];
  List<ChargeUserList>? chargeList = [];

  ///使用单位、生产单位：点击主要负责人
  final void Function(
          List<OfficeDtoLists>? deviceList, List<ChargeUserList>? chargeList)?
      onTapSyCharge;

  ///使用单位、生产单位：点击安全总监
  final void Function(OfficeDtoLists? value)? onTapSyDirector;

  ///使用单位、生产单位：点击安全员
  final void Function(OfficeDtoLists? value)? onTapSyOfficer;

  EquipmentPersonnelTable(
      {super.key,
      this.deviceList,
      this.chargeList,
      this.onTapSyDirector,
      this.onTapSyOfficer,
      this.onTapSyCharge});

  @override
  Widget build(BuildContext context) {
    return SliverToBoxAdapter(
        child: Container(
            margin: const EdgeInsets.only(top: 0, left: 8, right: 8),
            padding:
                const EdgeInsets.only(top: 10, bottom: 10, left: 5, right: 5),
            decoration: const BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.all(Radius.circular(5)),
            ),
            child: Column(
              children: [
                buildTitle(Icons.compare, '设备人员对比表格'),
                Container(
                  alignment: Alignment.centerLeft,
                  margin: const EdgeInsets.only(left: 5, right: 5, top: 5),
                  padding: const EdgeInsets.only(
                      left: 5, right: 5, top: 3, bottom: 3),
                  decoration: BoxDecoration(
                    color: Colors.orange[50],
                    borderRadius: const BorderRadius.only(
                        topLeft: Radius.circular(5),
                        topRight: Radius.circular(5),
                        bottomLeft: Radius.circular(5),
                        bottomRight: Radius.circular(5)),
                  ),
                  child: const Text(
                    softWrap: true,
                    '小提示：对比每个设备是否配备了相关负责人员，请在【用户设置】内配置相关负责人员.',
                    style: TextStyle(color: Colors.orange, fontSize: 13),
                  ),
                ),
                const SizedBox(height: 10),
                Table(
                    border: TableBorder.all(color: ColorConst.blueColor),
                    textBaseline: TextBaseline.alphabetic,
                    defaultVerticalAlignment: TableCellVerticalAlignment.middle,
                    columnWidths: const {
                      0: FixedColumnWidth(140),
                      1: FixedColumnWidth(80),
                      2: FixedColumnWidth(65),
                      3: FixedColumnWidth(50)
                    },
                    children: [
                      TableRow(children: [
                        buildTableTitle(
                            name: '设备名称', color: ColorConst.blueColor),
                        buildTableTitle(
                            name: '主要负责人', color: ColorConst.blueColor),
                        buildTableTitle(
                            name: '(质量)\n安全总监', color: ColorConst.blueColor),
                        buildTableTitle(
                            name: '(质量)\n安全员', color: ColorConst.blueColor),
                      ]),
                      TableRow(children: [
                        Table(
                            border: TableBorder.all(
                                color: ColorConst.blueColor, width: 0.5),
                            children: [
                              for (var item in deviceList!) ...[
                                TableRow(children: [
                                  SizedBox(
                                    height: 35,
                                    child: Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.center,
                                      children: [
                                        Text(item.name!,
                                            style:
                                                const TextStyle(fontSize: 14)),
                                        Text(
                                            item.deviceCount!.isNotEmpty
                                                ? '(${item.deviceCount})'
                                                : '',
                                            style: const TextStyle(
                                                fontSize: 12,
                                                color: Colors.red))
                                      ],
                                    ),
                                  ),
                                ]),
                              ],
                            ]),

                        ///使用单位：主要负责人内容
                        SizedBox(
                          height: 35,
                          child: TextButton(
                            onPressed: () {
                              if (chargeList!.isNotEmpty) {
                                onTapSyCharge!(deviceList, chargeList);
                              }
                            },
                            child: Text(chargeList!.isNotEmpty ? '✔' : '✘',
                                style: TextStyle(
                                    fontSize: 13,
                                    color: chargeList!.isNotEmpty
                                        ? Colors.black
                                        : Colors.red)),
                          ),
                        ),

                        ///使用单位：安全总监内容
                        Table(
                            border: TableBorder.all(
                                color: ColorConst.blueColor, width: 0.5),
                            children: [
                              for (var item in deviceList!) ...[
                                TableRow(children: [
                                  SizedBox(
                                    height: 35,
                                    child: TextButton(
                                      onPressed: () {
                                        if (item.safetyDirector!.isNotEmpty) {
                                          onTapSyDirector!(item);
                                        }
                                      },
                                      child: Text(
                                          item.safetyDirector!.isNotEmpty
                                              ? '✔'
                                              : '✘',
                                          style: TextStyle(
                                              fontSize: 13,
                                              color: item.safetyDirector!
                                                      .isNotEmpty
                                                  ? Colors.black
                                                  : Colors.red)),
                                    ),
                                  ),
                                ]),
                              ]
                            ]),

                        ///使用单位：安全员内容
                        Table(
                            border:
                                TableBorder.all(color: ColorConst.blueColor),
                            children: [
                              for (var item in deviceList!) ...[
                                TableRow(children: [
                                  SizedBox(
                                    height: 35,
                                    child: TextButton(
                                      onPressed: () {
                                        if (item.safetyOfficer!.isNotEmpty) {
                                          onTapSyOfficer!(item);
                                        }
                                      },
                                      child: Text(
                                          item.safetyOfficer!.isNotEmpty
                                              ? '✔'
                                              : '✘',
                                          style: TextStyle(
                                              fontSize: 13,
                                              color:
                                                  item.safetyOfficer!.isNotEmpty
                                                      ? Colors.black
                                                      : Colors.red)),
                                    ),
                                  ),
                                ]),
                              ]
                            ]),
                      ]),
                    ]),
                const SizedBox(height: 10)
              ],
            )));
  }

  Center buildTableTitle({color, name}) {
    return Center(
      child: Padding(
        padding: const EdgeInsets.only(top: 8, bottom: 8),
        child: Text(name,
            style: TextStyle(
                fontWeight: FontWeight.bold, color: color, fontSize: 14)),
      ),
    );
  }

  Column buildTitle(icon, title) {
    return Column(
      children: [
        Row(
          children: [
            Icon(
              icon,
              color: ColorConst.blueColor,
              size: SizeConfig.isIpad()! ? 35 : 18,
            ),
            const SizedBox(width: 5),
            Text(
              title,
              style: TextStyle(
                  color: Colors.black54,
                  fontSize: SizeConfig.isIpad()! ? 25 : 14,
                  fontWeight: FontWeight.bold),
            ),
          ],
        ),
        DividerCustom(Colors.grey[300], 10, 5, 5, 10),
      ],
    );
  }
}
