import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/model/device_list_bo.dart';
import 'package:special_equipment_flutter/widgets/app_bar/custom_app_bar.dart';

///公司-首页-设备人员对比表格
class EquipmentPersonnelPage extends StatefulWidget {
  var argsBundle = Get.arguments;

  EquipmentPersonnelPage({super.key});

  @override
  State<EquipmentPersonnelPage> createState() => _EquipmentPersonnelPageState();
}

class _EquipmentPersonnelPageState extends State<EquipmentPersonnelPage> {
  Data? deviceData;

  @override
  void initState() {
    super.initState();
    deviceData = widget.argsBundle['item'];
    print(jsonEncode(deviceData));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBarCustom(text: deviceData!.name, height: 50),
      body: Table(
          border: TableBorder.all(color: ColorConst.blueColor),
          textBaseline: TextBaseline.alphabetic,
          defaultVerticalAlignment: TableCellVerticalAlignment.middle,
          columnWidths: const {
            // 0: FixedColumnWidth(130),
            // 1: FixedColumnWidth(80),
            // 2: FixedColumnWidth(65),
            // 3: FixedColumnWidth(50)
          },
          children: [
            TableRow(children: [
              buildTableTitle(name: '用户类型', color: ColorConst.blueColor),
              buildTableTitle(name: '用户名称', color: ColorConst.blueColor),
            ]),
            TableRow(children: [
              Table(
                  border:
                      TableBorder.all(color: ColorConst.blueColor, width: 0.5),
                  children: [
                    for (var item in deviceData!.list!) ...[
                      TableRow(children: [
                        GestureDetector(
                          onTap: () {
                            // onTapSyDirector!();
                          },
                          child: Center(
                              child: Container(
                            height: 30,
                            padding: const EdgeInsets.only(top: 5, bottom: 5),
                            child: Text(item.roleName!,
                                style: const TextStyle(
                                    fontSize: 13, color: Colors.black)),
                          )),
                        ),
                      ]),
                    ]
                  ]),
              Table(
                  border: TableBorder.all(color: ColorConst.blueColor),
                  children: [
                    for (var item in deviceData!.list!) ...[
                      TableRow(children: [
                        GestureDetector(
                          onTap: () {
                            // onTapSyOfficer!();
                          },
                          child: Center(
                              child: Container(
                            height: 30,
                            padding: const EdgeInsets.only(top: 5, bottom: 5),
                            child: Text(item.userName!,
                                style: const TextStyle(
                                    fontSize: 13, color: Colors.black)),
                          )),
                        ),
                      ]),
                    ]
                  ]),
            ]),
          ]),
    );
  }

  Center buildTableTitle({color, name}) {
    return Center(
      child: Padding(
        padding: const EdgeInsets.only(top: 8, bottom: 8),
        child: Text(name,
            style: TextStyle(
                fontWeight: FontWeight.bold, color: color, fontSize: 14)),
      ),
    );
  }
}
