// ignore_for_file: prefer_typing_uninitialized_variables, library_private_types_in_public_api, use_build_context_synchronously

import 'dart:async';
import 'dart:convert';
import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter_easyrefresh/easy_refresh.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import 'package:package_info/package_info.dart';
import 'package:special_equipment_flutter/common/edgeInsets_const.dart';
import 'package:special_equipment_flutter/common/route_string.dart';
import 'package:special_equipment_flutter/dio/http_utils.dart';
import 'package:special_equipment_flutter/model/app_is_open.dart';
import 'package:special_equipment_flutter/model/banner_list_bo.dart';
import 'package:special_equipment_flutter/model/check_update.dart';
import 'package:special_equipment_flutter/model/count_bo.dart';
import 'package:special_equipment_flutter/model/echart_bo.dart';
import 'package:special_equipment_flutter/model/exam/examine_person_bo.dart';
import 'package:special_equipment_flutter/model/exam/overseer_history_list_bo.dart';
import 'package:special_equipment_flutter/model/find_charge_list_bo.dart';
import 'package:special_equipment_flutter/model/find_count_bo.dart';
import 'package:special_equipment_flutter/model/office_device.dart';
import 'package:special_equipment_flutter/model/role_bo.dart';
import 'package:special_equipment_flutter/model/version/app_info_bo.dart';
import 'package:special_equipment_flutter/model/version/version_bo.dart';
import 'package:special_equipment_flutter/ui/common/data.dart';
import 'package:special_equipment_flutter/ui/main/echart/home_echart_tabs.dart';
import 'package:special_equipment_flutter/ui/main/unit/equipment_personnel_table.dart';
import 'package:special_equipment_flutter/ui/main/unit/unit_grid_list.dart';
import 'package:special_equipment_flutter/utils/eventbus_utils.dart';
import 'package:special_equipment_flutter/utils/size_config.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';
import 'package:special_equipment_flutter/utils/time_util.dart';
import 'package:special_equipment_flutter/utils/toast_utils.dart';
import 'package:special_equipment_flutter/widgets/banner_view.dart';
import 'package:special_equipment_flutter/widgets/card_swiper.dart';
import 'package:special_equipment_flutter/widgets/custom_button.dart';
import 'package:special_equipment_flutter/widgets/divider_custom.dart';
import 'package:special_equipment_flutter/widgets/easy_refresh_header1.dart';
import 'package:special_equipment_flutter/widgets/emptyI_img_widget.dart';
import 'package:special_equipment_flutter/widgets/tip.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../common/color_const.dart';
import '../../utils/string_utils.dart';

///首页
class HomePage extends StatefulWidget {
  const HomePage({super.key});

  @override
  _HomePageState createState() => _HomePageState();
}

class _HomePageState extends State<HomePage>
    with AutomaticKeepAliveClientMixin, TickerProviderStateMixin {
  @override
  bool get wantKeepAlive => true;

  var unitList = [];
  List<HomeMenuItem> checkItemList = [],
      checkItemRiskList = [],
      checkItemSettingsList = [],
      checkItemExaminationList = [];
  var unitId = '1',
      unitName = '使用单位',
      officeName,
      userName,
      roleNames,
      dayCount,
      weekCount,
      monthCount,
      dayRiskCount,
      weekRiskCount,
      monthRiskCount;
  List<dynamic>? completedDayNum = [], incompletedDayNum = [];
  List<dynamic>? completedWeekNum = [], incompletedWeekNum = [];
  List<dynamic>? completedMonthNum = [], incompletedMonthNum = [];
  String? xDateDayListJson, xDateWeekListJson, xDateMonthListJson;
  late final AnimationController _controller;
  late final Animation<double> _animation;
  List<ChargeUserList>? chargeList = [];
  List<OfficeDtoLists>? deviceList = [];

  FindChargeListBo? chargeBo = FindChargeListBo();
  List<CountData>? findCountList = [];
  ExaminePersonBo? mExaminePersonBo = ExaminePersonBo();
  OverseerHistoryListBo? mOverseerHistoryListBo = OverseerHistoryListBo();
  int mOverseerHistoryCount = 0;
  List<HistoryListData>? mHistoryListData = [];
  String? isOpen = '0';
  List<Data>? bannerList = [];

  //声明，后面需要销毁
  StreamSubscription? event;

  // List<Map> banner = [
  //   {"url": "assets/banner/banner0.png"},
  //   {"url": "assets/banner/banner1.png"}
  // ];

  @override
  void initState() {
    super.initState();
    doAppIsOpen();

    ///获取版本
    checkUpdateVersion();
    officeName = StorageUtil.getInstance().getOfficeName();
    userName = StorageUtil.getInstance().getName();
    roleNames = StorageUtil.getInstance().getRoleNames();

    unitList = getUnitList();
    try {
      var unitStatus = StorageUtil.getInstance().getUnitStatus();
      if (!StringUtils.strIsEmpty(unitStatus)) {
        unitId = unitStatus;
        if (unitStatus == '1') {
          unitName = '使用单位';
        } else if (unitStatus == '2') {
          unitName = '生产单位';
        }
      } else {
        StorageUtil.getInstance().set(SpKeys.UNIT_STATUS, unitId);
      }
    } catch (e) {
      StorageUtil.getInstance().set(SpKeys.UNIT_STATUS, unitId);
    }
    // _requestPermission();
    Future.delayed(const Duration(seconds: 2), () {
      // 延迟执行的代码
      getBannerList();
    });

    ///获取日管控、周排查、月调度数量
    getCount();
    getGirdviewData();

    ///监察人身份获取
    if (isInspectorRoles(StorageUtil.getInstance().getRoleNames())!) {
      getOverseerHistoryList();
    } else {
      getQuestionsPerson();
    }

    _controller = AnimationController(
      duration: const Duration(seconds: 2),
      vsync: this,
    )..forward();

    _animation = CurvedAnimation(
      parent: _controller,
      curve: Curves.bounceOut,
    );

    //通知监听
    event = EventBusUtils.getInstance()?.on().listen((event) {
      if (event.toString() == "1") {
        getQuestionsPerson();
      }
    });

    getDeviceData();
  }

  ///获取轮播图接口
  void getBannerList() {
    HttpUtils.getBannerList(context).then((value) {
      BannerListBo mBannerListBo = value;
      if (mounted) {
        setState(() {
          bannerList!.clear();
          List<Data>? mList = mBannerListBo.data;
          for (var item in mList!) {
            if (item.advertisPosition == "0") {
              bannerList!.add(item);
            }
          }
        });
      }
    });
  }

  ///版本显示控制
  void doAppIsOpen() {
    if (Platform.isIOS) {
      HttpUtils.doAppIsOpen(context, onSuccess: (value) {
        AppIsOpen appIsOpen = value;
        if (mounted) {
          setState(() {
            isOpen = appIsOpen.appIsOpen!;
          });
        }
      });
    }
  }

  ///获取监察记录列表
  void getOverseerHistoryList() {
    HttpUtils.getPapers(context, StorageUtil.getInstance().getUserId(), 1, 10)
        .then((value) {
      if (mounted) {
        setState(() {
          mOverseerHistoryListBo = value;
          mOverseerHistoryCount = mOverseerHistoryListBo!.count!;
          mHistoryListData = mOverseerHistoryListBo!.data;
        });
      }
    });
  }

  ///获取考核试卷
  void getQuestionsPerson() {
    HttpUtils.getExaminePerson(context).then((value) {
      mExaminePersonBo = value;
      if (mounted) {
        setState(() {
          checkItemExaminationList.clear();
          if (mExaminePersonBo!.success!) {
            checkItemExaminationList.add(HomeMenuItem(
                image: 'assets/examine/examine_icon.png',
                name: '考核',
                isContains: roleNames.contains(StandingConfig.SAFETY_OFFICER)));
          } else {
            checkItemExaminationList.add(HomeMenuItem(
                image: 'assets/examine/examine_gary_icon.png',
                name: '考核',
                isContains: roleNames.contains(StandingConfig.SAFETY_OFFICER)));
          }
          checkItemExaminationList.add(HomeMenuItem(
              image: 'assets/examine/examine_test_icon.png',
              name: '测试练习',
              isContains: roleNames.contains(StandingConfig.PERSON_CHARGE)));

          // checkItemExaminationList.add(HomeMenuItem(
          //     image: 'assets/examine/examine_history_icon.png',
          //     name: '考核历史',
          //     isContains: roleNames.contains(StandingConfig.SAFETY_DIRECTOR)));
        });
      }
    });
  }

  ///获取考核试卷
  void getClickQuestionsPerson() {
    HttpUtils.getExaminePerson(context).then((value) {
      mExaminePersonBo = value;
      if (mounted) {
        setState(() {
          checkItemExaminationList.clear();
          if (mExaminePersonBo!.success!) {
            checkItemExaminationList.add(HomeMenuItem(
                image: 'assets/examine/examine_icon.png',
                name: '考核',
                isContains: roleNames.contains(StandingConfig.SAFETY_OFFICER)));
            Get.toNamed(RouteString.EXAM_PAGE,
                    arguments: {'mExaminePersonBo': mExaminePersonBo!.data})
                ?.then((value) {
              // getQuestionsPerson();
            });
          } else {
            checkItemExaminationList.add(HomeMenuItem(
                image: 'assets/examine/examine_gary_icon.png',
                name: '考核',
                isContains: roleNames.contains(StandingConfig.SAFETY_OFFICER)));
            ToastUtils.showCenter('您目前暂无考核内容');
          }
          checkItemExaminationList.add(HomeMenuItem(
              image: 'assets/examine/examine_test_icon.png',
              name: '测试练习',
              isContains: roleNames.contains(StandingConfig.PERSON_CHARGE)));

          // checkItemExaminationList.add(HomeMenuItem(
          //     image: 'assets/examine/examine_history_icon.png',
          //     name: '考核历史',
          //     isContains: roleNames.contains(StandingConfig.SAFETY_DIRECTOR)));
        });
      }
    });
  }

  getDeviceData() {
    if (!isUnitRoles(StorageUtil.getInstance().getRoleNames())!) {
      return;
    }

    ///获取对应设备下的人员角色
    HttpUtils.doFindNatureDtoList(context, onSuccess: (value) {
      ///接口返回数据
      RoleBo roleBo = value;
      if (mounted) {
        ///设备对比表格 获取使用单位设备数量
        HttpUtils.doFindCount(context, onSuccess: (value) {
          FindCountBo findCountBo = value;
          findCountList = findCountBo.list;

          ///设备对比表格 获取主要负责人
          HttpUtils.doFindChargeList(context, onSuccess: (value) {
            FindChargeListBo findChargeListBo = value;
            if (mounted) {
              setState(() {
                chargeList = findChargeListBo.list;
                chargeBo = findChargeListBo;
                var charge = '';
                for (var deviceItem in chargeBo!.list!) {
                  charge += '${deviceItem.name}\n';
                }
                //删除字符串最后一个逗号
                int lastIndex = charge.lastIndexOf("\n");
                if (lastIndex != -1) {
                  // 如果字符串中存在逗号
                  charge = charge.substring(0, lastIndex) +
                      charge.substring(lastIndex + 1);
                }
                findChargeListBo.chargeNames = charge;
                HttpUtils.getOfficeDevice(context).then((value) {
                  if (value != null) {
                    OfficeDevice officeDeviceItem = value;
                    setState(() {
                      deviceList = officeDeviceItem.office!.officeDtoList;
                      //角色集合
                      for (var deviceItem in deviceList!) {
                        ///将获取到的使用单位的数量放到设备数组中
                        for (var countItem in findCountList!) {
                          if (countItem.deviceTypeId ==
                              deviceItem.deviceTypeId) {
                            deviceItem.deviceCount = countItem.count.toString();
                          }
                        }
                        var director = '', officer = '';
                        List<UserData>? userDataList = [];
                        for (var rolesItem in roleBo.list!) {
                          if (rolesItem.deviceTypeId ==
                              deviceItem.deviceTypeId) {
                            userDataList.add(rolesItem);
                            //安全总监
                            if (rolesItem.roleEnName == 'director') {
                              director += '${rolesItem.userName},';
                            }
                            //安全员
                            if (rolesItem.roleEnName == 'officer') {
                              officer += '${rolesItem.userName},';
                            }
                          }
                        }
                        deviceItem.list = userDataList;
                        deviceItem.safetyOfficer = officer;
                        deviceItem.safetyDirector = director;
                      }
                    });
                  }
                });
              });
            }
          });
        });
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    super.build(context);
    return Scaffold(
      backgroundColor: Colors.grey[100],
      body: EasyRefresh(
        header: TaurusHeaders(),
        onRefresh: () async {
          setState(() {
            // Future.delayed(const Duration(seconds: 2), () {
            //   // 延迟执行的代码
            //   getBannerList();
            // });
            getBannerList();
            getCount();
            getDeviceData();

            ///监察人身份获取
            if (isInspectorRoles(StorageUtil.getInstance().getRoleNames())!) {
              getOverseerHistoryList();
            } else {
              getQuestionsPerson();
            }
            doAppIsOpen();
          });
        },
        child: CustomScrollView(
          primary: false,
          shrinkWrap: true,
          slivers: <Widget>[
            buildSliverAppBar(),

            ///欢迎、身份
            buildStanding(),

            ///公司账户
            if (isUnitRoles(StorageUtil.getInstance().getRoleNames())!) ...[
              ///用户设置、设备设置、单位设置布局
              UnitGridList(onTapUser: () {
                Get.toNamed(RouteString.UER_LIST)?.then((value) {
                  // if (value) {
                  getDeviceData();
                  // }
                });
              }, onTapEquipment: () {
                HttpUtils.getOfficeDevice(context).then((value) {
                  if (value != null) {
                    OfficeDevice officeDeviceItem = value;
                    setState(() {
                      var type = officeDeviceItem.office!.type!.split(',');
                      Get.toNamed(RouteString.EQUIPMENT_TAB, arguments: type)
                          ?.then((value) {
                        // if (value) {
                        getDeviceData();
                        // }
                      });
                    });
                  }
                });
              }, onTapUnit: () {
                Get.toNamed(RouteString.UNIT_SETTINGS)?.then((value) {
                  // if (value) {
                  getDeviceData();
                  // }
                });
              }),

              ///设备人员对比
              EquipmentPersonnelTable(
                  deviceList: deviceList,
                  chargeList: chargeList,
                  onTapSyCharge: (deviceList, chargeList) {
                    buildShowChargeDialog(context, deviceList, chargeList!);
                  },
                  onTapSyDirector: (value) {
                    buildShowTableDialog(context, value, true);
                  },
                  onTapSyOfficer: (value) {
                    buildShowTableDialog(context, value, false);
                  }),

              ///统计
              // buildSliverStatistics(context),

              ///监察人员
            ] else if (isInspectorRoles(
                StorageUtil.getInstance().getRoleNames())!) ...[
              buildOverseerLable(),
            ] else ...[
              buildSliverToBoxAdapter(
                  'assets/examine/check_title_icon.png', '检查整改'),

              ///日管控、周排查、月调度布局
              buildSliverDayWeekMonth(),

              ///日管控整改、周排查整改、月调度整改布局
              buildSliverRiskDayWeekMonth(),
              if (!isRolesName1(StorageUtil.getInstance().getRoleNames())!) ...[
                ///统计
                buildSliverStatistics(context)
              ] else ...[
                buildSliverToBoxAdapter(
                    'assets/examine/exam_title_icon.png', '考核练习'),
                buildSliverGridExamination(),
                // if (Platform.isIOS) ...[
                //   if (isOpen == '1') ...[
                //     buildSliverToBoxAdapter(
                //         'assets/examine/exam_title_icon.png', '考核练习'),
                //     buildSliverGridExamination(),
                //   ]
                // ] else ...[
                //   buildSliverToBoxAdapter(
                //       'assets/examine/exam_title_icon.png', '考核练习'),
                //   buildSliverGridExamination(),
                // ]
              ]
            ]
          ],
        ),
      ),
    );
  }

  ///监察人员布局
  SliverToBoxAdapter buildOverseerLable() {
    return SliverToBoxAdapter(
        child: Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        buildLableTitle('assets/examine/exam_title_icon.png', '监察考核'),
        Container(
          margin: const EdgeInsets.only(left: 35, top: 10),
          child: InkWell(
            splashColor: ColorConst.green1Color,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                SizedBox(height: SizeConfig.isIpad()! ? 30 : 5),
                Image.asset(
                  'assets/examine/examine_icon.png',
                  width: SizeConfig.isIpad()! ? 150 : 50,
                  height: SizeConfig.isIpad()! ? 150 : 50,
                ),
                Container(
                  height: SizeConfig.isIpad()! ? 40 : 20,
                  margin: const EdgeInsets.only(top: 3),
                  child: Text(
                    '考核设置',
                    style: TextStyle(
                        fontSize: SizeConfig.isIpad()! ? 25 : 13,
                        color: Colors.black54),
                  ),
                )
              ],
            ),
            onTap: () {
              Get.toNamed(RouteString.OVERSEER_SETTINGS_PAGE, arguments: {})
                  ?.then((value) {
                if (value != null && value) {
                  getOverseerHistoryList();
                }
              });

              // Get.toNamed(RouteString.FILE_LIST_PAGE, arguments: {})
              //     ?.then((value) {
              //   if (value != null && value) {
              //     getOverseerHistoryList();
              //   }
              // });
            },
          ),
        ),
        Container(
          margin: const EdgeInsets.only(top: 10),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Container(
                  margin: const EdgeInsets.only(left: 5),
                  padding: const EdgeInsets.all(10),
                  child: Column(
                    children: [
                      Row(
                        children: [
                          Image.asset(
                            'assets/examine/history_icon.png',
                            width: SizeConfig.isIpad()! ? 35 : 18,
                            height: SizeConfig.isIpad()! ? 35 : 18,
                          ),
                          const SizedBox(width: 5),
                          Text(
                            '监察记录',
                            style: TextStyle(
                                color: Colors.black54,
                                fontSize: SizeConfig.isIpad()! ? 25 : 14,
                                fontWeight: FontWeight.bold),
                          ),
                        ],
                      ),
                      // buildTitle(Icons.equalizer, '考核练习'),
                      // buildSliverGridExamination()
                    ],
                  )),
              InkWell(
                onTap: () {
                  Get.toNamed(RouteString.OVERSEER_HISTORY_LIST_PAGE,
                      arguments: {})?.then((value) {
                    if (value != null && value) {
                      getOverseerHistoryList();
                    }
                  });
                },
                child: Container(
                  padding: const EdgeInsets.all(10),
                  child: const Text(
                    '更多监察记录 >',
                    style: TextStyle(color: ColorConst.blueColor, fontSize: 14),
                  ),
                ),
              )
            ],
          ),
        ),
        //TODO
        Container(
          width: double.infinity,
          margin: const EdgeInsets.only(left: 15, right: 15, top: 0, bottom: 5),
          padding: const EdgeInsets.only(left: 5, right: 5, top: 3, bottom: 3),
          decoration: BoxDecoration(
            color: Colors.orange[50],
            borderRadius: const BorderRadius.only(
                topLeft: Radius.circular(5),
                topRight: Radius.circular(5),
                bottomLeft: Radius.circular(5),
                bottomRight: Radius.circular(5)),
          ),
          child: Text.rich(
              softWrap: true,
              TextSpan(children: [
                const TextSpan(
                    text: "历史监察记录共 ",
                    style: TextStyle(fontSize: 12, color: Colors.orange)),
                TextSpan(
                    text: mOverseerHistoryListBo != null
                        ? mOverseerHistoryCount.toString()
                        : '0',
                    style: const TextStyle(
                        fontSize: 16,
                        color: Colors.orange,
                        fontWeight: FontWeight.bold)),
                const TextSpan(
                    text: " 条",
                    style: TextStyle(fontSize: 12, color: Colors.orange))
              ])),
        ),

        if (mHistoryListData!.isEmpty) ...[
          EmptyImgWidget(
              title: '暂无监察记录，点击刷新',
              onTap: () {
                getOverseerHistoryList();
              }),
        ] else ...[
          Container(
            margin:
                const EdgeInsets.only(left: 5, right: 5, top: 0, bottom: 30),
            child: ListView.separated(
              shrinkWrap: true,
              padding: const EdgeInsets.symmetric(
                  horizontal: EdgeInsetsConst.padding_horizontal),
              physics: const NeverScrollableScrollPhysics(),
              itemBuilder: (BuildContext context, int index) {
                return AnimatedBuilder(
                  animation: _animation,
                  builder: (context, child) {
                    return Transform.scale(
                      scale: _animation.value,
                      child: InkWell(
                        onTap: () {
                          Get.toNamed(RouteString.OVERSEER_HISTROY_DETAILS_PAGE,
                              arguments: {
                                'id': mHistoryListData![index].id,
                              })?.then((value) {
                            if (value != null && value) {
                              getOverseerHistoryList();
                            }
                          });
                        },
                        child: Card(
                          elevation: 10,
                          shadowColor: mHistoryListData![index].incomplete != 0
                              ? ColorConst.orangeColor
                              : ColorConst.greenColor,
                          margin: EdgeInsets.only(
                              left: 0,
                              right: 0,
                              top: index == 0 ? 0 : 15,
                              bottom: 0),
                          shape: const RoundedRectangleBorder(
                            borderRadius: BorderRadius.all(Radius.circular(10)),
                          ),
                          child: Container(
                            padding: const EdgeInsets.only(
                                left: 15, right: 15, top: 10, bottom: 10),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                Text(mHistoryListData![index].officeName!,
                                    style: const TextStyle(
                                        fontWeight: FontWeight.bold,
                                        fontSize: 16,
                                        color: Colors.black54)),

                                ///分割线
                                DividerCustom(Colors.grey[300], 8, 8, 0, 0),

                                Row(children: [
                                  const Text('设备类型：',
                                      style: TextStyle(
                                          fontSize: 14, color: Colors.black54)),
                                  Text(mHistoryListData![index].typeName!,
                                      style: const TextStyle(
                                          fontSize: 14, color: Colors.black54)),
                                ]),
                                const SizedBox(height: 5),
                                Text.rich(
                                    softWrap: true,
                                    TextSpan(children: [
                                      const TextSpan(
                                          text: "考核人数：",
                                          style: TextStyle(
                                              fontSize: 14,
                                              color: Colors.black54)),
                                      TextSpan(
                                          text: mHistoryListData![index]
                                              .count!
                                              .toString(),
                                          style: const TextStyle(
                                              fontSize: 18,
                                              color: ColorConst.greenColor,
                                              fontWeight: FontWeight.bold)),
                                      const TextSpan(
                                          text: "人",
                                          style: TextStyle(
                                              fontSize: 14,
                                              color: Colors.black54)),
                                    ])),
                                const SizedBox(height: 5),
                                Text.rich(
                                    softWrap: true,
                                    TextSpan(children: [
                                      const TextSpan(
                                          text: "考核状态：",
                                          style: TextStyle(
                                              fontSize: 14,
                                              color: Colors.black54)),
                                      const TextSpan(
                                          text: "已完成 ",
                                          style: TextStyle(
                                              color: ColorConst.greenColor)),
                                      TextSpan(
                                          text: mHistoryListData![index]
                                              .complete!
                                              .toString(),
                                          style: const TextStyle(
                                              color: ColorConst.greenColor,
                                              fontSize: 18,
                                              fontWeight: FontWeight.bold)),
                                      const TextSpan(
                                          text: " 人",
                                          style: TextStyle(
                                              color: ColorConst.greenColor)),
                                      if (mHistoryListData![index].incomplete !=
                                          0) ...[
                                        const TextSpan(
                                            text: "  |  ",
                                            style: TextStyle(
                                                color: ColorConst.greyD2Color)),
                                        const TextSpan(
                                            text: "进行中 ",
                                            style: TextStyle(
                                                color: ColorConst.red1BgColor)),
                                        TextSpan(
                                            text: mHistoryListData![index]
                                                .incomplete!
                                                .toString(),
                                            style: const TextStyle(
                                                color: ColorConst.red1BgColor,
                                                fontSize: 18,
                                                fontWeight: FontWeight.bold)),
                                        const TextSpan(
                                            text: " 人",
                                            style: TextStyle(
                                                color: ColorConst.red1BgColor)),
                                      ]
                                    ])),
                                const SizedBox(height: 5),
                                Text.rich(
                                    softWrap: true,
                                    TextSpan(children: [
                                      const TextSpan(
                                          text: "考核时间：",
                                          style: TextStyle(
                                              fontSize: 14,
                                              color: Colors.black54)),
                                      TextSpan(
                                          text: timestampToDate(
                                              mHistoryListData![index]
                                                  .createDate!),
                                          style: const TextStyle(
                                              fontSize: 14,
                                              color: Colors.black54)),
                                    ])),
                                const SizedBox(height: 10),
                                Row(
                                  mainAxisAlignment: MainAxisAlignment.end,
                                  children: [
                                    if (mHistoryListData![index].incomplete !=
                                        0) ...[
                                      GradientButton(
                                          tapCallback: () {
                                            showDialog(
                                                context: context,
                                                builder: (context) {
                                                  return AlertDialog(
                                                    title: const Text("温馨提示"),
                                                    content: const Text(
                                                        "您确定要删除该监察记录吗？"),
                                                    actionsPadding:
                                                        const EdgeInsets.only(
                                                            left: 0,
                                                            top: 0,
                                                            bottom: 10,
                                                            right: 20),
                                                    contentPadding:
                                                        const EdgeInsets.only(
                                                            left: 20,
                                                            top: 0,
                                                            bottom: 10,
                                                            right: 20),
                                                    titlePadding:
                                                        const EdgeInsets.only(
                                                            left: 20,
                                                            top: 20,
                                                            bottom: 10,
                                                            right: 20),
                                                    actions: [
                                                      TextButton(
                                                        child: const Text("取消"),
                                                        onPressed: () {
                                                          Get.back();
                                                        },
                                                      ),
                                                      TextButton(
                                                          child:
                                                              const Text("确定"),
                                                          onPressed: () {
                                                            ///删除监察记录
                                                            HttpUtils.getExamSetupDelete(
                                                                    context,
                                                                    mHistoryListData![
                                                                            index]
                                                                        .id!)
                                                                .then((value) {
                                                              if (mounted) {
                                                                setState(() {
                                                                  mHistoryListData!
                                                                      .removeAt(
                                                                          index);
                                                                  mOverseerHistoryCount--;
                                                                  ToastUtils
                                                                      .showCenter(
                                                                          '删除成功');
                                                                  Get.back();
                                                                });
                                                              }
                                                            });
                                                          })
                                                    ],
                                                  );
                                                });
                                          },
                                          width: 60,
                                          height: 23,
                                          borderRadius: const BorderRadius.only(
                                              topLeft: Radius.circular(10),
                                              topRight: Radius.circular(20),
                                              bottomLeft: Radius.circular(20),
                                              bottomRight: Radius.circular(10)),
                                          disable: false,
                                          colors: const [
                                            ColorConst.red1BgColor,
                                            ColorConst.red3BgColor
                                          ],
                                          child: const Text(
                                            "删除",
                                            style: TextStyle(
                                                fontSize: 14,
                                                color: ColorConst.whiteColor),
                                          )),
                                    ],
                                    Container(
                                      margin: const EdgeInsets.only(left: 20),
                                      child: GradientButton(
                                          tapCallback: () {
                                            Get.toNamed(
                                                RouteString
                                                    .OVERSEER_HISTROY_DETAILS_PAGE,
                                                arguments: {
                                                  'id': mHistoryListData![index]
                                                      .id,
                                                })?.then((value) {
                                              if (value != null && value) {
                                                getOverseerHistoryList();
                                              }
                                            });
                                          },
                                          width: 60,
                                          height: 23,
                                          borderRadius: const BorderRadius.only(
                                              topLeft: Radius.circular(10),
                                              topRight: Radius.circular(20),
                                              bottomLeft: Radius.circular(20),
                                              bottomRight: Radius.circular(10)),
                                          disable: false,
                                          colors: const [
                                            ColorConst.blueColor,
                                            ColorConst.blue1Color
                                          ],
                                          child: const Text(
                                            "详情",
                                            style: TextStyle(
                                                fontSize: 14,
                                                color: ColorConst.whiteColor),
                                          )),
                                    )
                                  ],
                                )
                              ],
                            ),
                          ),
                        ),
                      ),
                    );
                  },
                );
              },
              itemCount: mHistoryListData!.length,
              separatorBuilder: (BuildContext context, int index) {
                return const SizedBox(
                  height: 0,
                );
              },
            ),
          ),
        ],
      ],
    ));
  }

  Container buildLableTitle(String imageAsset, String name) {
    return Container(
        margin: const EdgeInsets.only(top: 10, left: 5, right: 0),
        padding: const EdgeInsets.all(10),
        decoration: const BoxDecoration(
          // color: Colors.white,
          borderRadius: BorderRadius.all(Radius.circular(5)),
        ),
        child: Column(
          children: [
            Row(
              children: [
                Image.asset(
                  imageAsset,
                  width: SizeConfig.isIpad()! ? 35 : 18,
                  height: SizeConfig.isIpad()! ? 35 : 18,
                ),
                const SizedBox(width: 5),
                Text(
                  name,
                  style: TextStyle(
                      color: Colors.black54,
                      fontSize: SizeConfig.isIpad()! ? 25 : 14,
                      fontWeight: FontWeight.bold),
                ),
              ],
            ),
            // buildTitle(Icons.equalizer, '考核练习'),
            // buildSliverGridExamination()
          ],
        ));
  }

  SliverToBoxAdapter buildSliverToBoxAdapter(String imageAsset, String name) {
    return SliverToBoxAdapter(
        child: Container(
            margin: const EdgeInsets.only(top: 10, left: 5, right: 0),
            padding: const EdgeInsets.all(10),
            decoration: const BoxDecoration(
              // color: Colors.white,
              borderRadius: BorderRadius.all(Radius.circular(5)),
            ),
            child: Column(
              children: [
                Row(
                  children: [
                    Image.asset(
                      imageAsset,
                      width: SizeConfig.isIpad()! ? 35 : 18,
                      height: SizeConfig.isIpad()! ? 35 : 18,
                    ),
                    const SizedBox(width: 5),
                    Text(
                      name,
                      style: TextStyle(
                          color: Colors.black54,
                          fontSize: SizeConfig.isIpad()! ? 25 : 14,
                          fontWeight: FontWeight.bold),
                    ),
                  ],
                ),
                // buildTitle(Icons.equalizer, '考核练习'),
                // buildSliverGridExamination()
                if (name == '考核练习') ...[
                  const Tip('小提示:【安全监察人】向各单位开启监督抽查【考核】'),
                ]
              ],
            )));
  }

  Future<dynamic> buildShowChargeDialog(BuildContext context,
      List<OfficeDtoLists>? deviceList, List<ChargeUserList>? chargeList) {
    return showDialog(
        context: context,
        barrierDismissible: true,
        builder: (context) {
          return AlertDialog(
            title: const Text('主要负责人'),

            content: CustomScrollView(
                primary: false,
                shrinkWrap: true,
                slivers: <Widget>[
                  SliverToBoxAdapter(
                    child: buildChargeTable(deviceList!, chargeList),
                  )
                ]),

            // content: Container(
            //     height: 150, child: buildChargeTable(deviceList!, chargeList)),
            actions: <Widget>[
              Center(
                child: GradientButton(
                    tapCallback: () {
                      setState(() {
                        Get.back();
                      });
                    },
                    width: 90,
                    height: 30,
                    borderRadius: const BorderRadius.only(
                        topLeft: Radius.circular(5),
                        topRight: Radius.circular(10),
                        bottomLeft: Radius.circular(10),
                        bottomRight: Radius.circular(5)),
                    disable: false,
                    colors: const [ColorConst.blueColor, Colors.blue],
                    child: const Text(
                      "我知道了",
                      style:
                          TextStyle(fontSize: 13, color: ColorConst.whiteColor),
                    )),
              ),
              const SizedBox(height: 10)
            ],
          );
        });
  }

  Table buildChargeTable(
      List<OfficeDtoLists>? deviceList, List<ChargeUserList>? chargeList) {
    return Table(
        border: TableBorder.all(color: ColorConst.blueColor),
        textBaseline: TextBaseline.alphabetic,
        defaultVerticalAlignment: TableCellVerticalAlignment.middle,
        columnWidths: const {
          // 0: FixedColumnWidth(100),
          // 1: FixedColumnWidth(50),
        },
        children: [
          TableRow(children: [
            buildTableTitle(name: '设备类型', color: ColorConst.blueColor),
            buildTableTitle(name: '用户名称', color: ColorConst.blueColor),
          ]),
          TableRow(children: [
            Table(
                border:
                    TableBorder.all(color: ColorConst.blueColor, width: 0.5),
                children: [
                  for (var item in deviceList!) ...[
                    TableRow(children: [
                      Container(
                          height: 30,
                          padding: const EdgeInsets.only(top: 5, bottom: 5),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              Text(item.name!,
                                  style: const TextStyle(fontSize: 13)),
                              Text(
                                  item.deviceCount!.isNotEmpty
                                      ? '(${item.deviceCount})'
                                      : '',
                                  style: const TextStyle(
                                      fontSize: 12, color: Colors.red)),
                            ],
                          )),
                    ]),
                  ],
                ]),
            Center(
                child: Padding(
              padding: const EdgeInsets.all(5.0),
              child: Text(chargeBo!.chargeNames! ?? '',
                  style: const TextStyle(fontSize: 13, color: Colors.black)),
            )),
          ]),
        ]);
  }

  Future<dynamic> buildShowTableDialog(
      BuildContext context, OfficeDtoLists? value, isUser) {
    return showDialog(
        context: context,
        barrierDismissible: true,
        builder: (context) {
          return AlertDialog(
            title: Row(
              children: [
                Text(value!.name!),
                Text(
                    value.deviceCount!.isNotEmpty
                        ? '(${value.deviceCount})'
                        : '',
                    style: const TextStyle(fontSize: 12, color: Colors.red)),
              ],
            ),
            content: buildTable(value, isUser),
            actions: <Widget>[
              Center(
                child: GradientButton(
                    tapCallback: () {
                      setState(() {
                        Get.back();
                      });
                    },
                    width: 90,
                    height: 30,
                    borderRadius: const BorderRadius.only(
                        topLeft: Radius.circular(5),
                        topRight: Radius.circular(10),
                        bottomLeft: Radius.circular(10),
                        bottomRight: Radius.circular(5)),
                    disable: false,
                    colors: const [ColorConst.blueColor, Colors.blue],
                    child: const Text(
                      "我知道了",
                      style:
                          TextStyle(fontSize: 13, color: ColorConst.whiteColor),
                    )),
              ),
              const SizedBox(height: 10)
            ],
          );
        });
  }

  Table buildTable(OfficeDtoLists value, bool isUser) {
    return Table(
        border: TableBorder.all(color: ColorConst.blueColor),
        textBaseline: TextBaseline.alphabetic,
        defaultVerticalAlignment: TableCellVerticalAlignment.middle,
        columnWidths: const {
          // 0: FixedColumnWidth(130),
          // 1: FixedColumnWidth(80),
          // 2: FixedColumnWidth(65),
          // 3: FixedColumnWidth(50)
        },
        children: [
          TableRow(children: [
            buildTableTitle(name: '用户类型', color: ColorConst.blueColor),
            buildTableTitle(name: '用户名称', color: ColorConst.blueColor),
          ]),
          TableRow(children: [
            Table(
                border:
                    TableBorder.all(color: ColorConst.blueColor, width: 0.5),
                children: [
                  for (UserData item in value.list!) ...[
                    if (isUser) ...[
                      if (item.roleEnName == 'director') ...[
                        TableRow(children: [
                          GestureDetector(
                            onTap: () {
                              // onTapSyDirector!();
                            },
                            child: Center(
                                child: Container(
                              height: 30,
                              padding: const EdgeInsets.only(top: 5, bottom: 5),
                              child: Text(
                                  !StandingConfig.SY_DEVICE
                                          .contains(value.name!)
                                      ? item.roleName!.replaceAll('(质量)', '质量')
                                      : item.roleName!.replaceAll('(质量)', ''),
                                  style: const TextStyle(
                                      fontSize: 13, color: Colors.black)),
                            )),
                          ),
                        ]),
                      ],
                    ],
                    if (!isUser) ...[
                      if (item.roleEnName == 'officer') ...[
                        TableRow(children: [
                          GestureDetector(
                            onTap: () {
                              // onTapSyDirector!();
                            },
                            child: Center(
                                child: Container(
                              height: 30,
                              padding: const EdgeInsets.only(top: 5, bottom: 5),
                              child: Text(
                                  !StandingConfig.SY_DEVICE
                                          .contains(value.name!)
                                      ? item.roleName!.replaceAll('(质量)', '质量')
                                      : item.roleName!.replaceAll('(质量)', ''),
                                  style: const TextStyle(
                                      fontSize: 13, color: Colors.black)),
                            )),
                          ),
                        ]),
                      ]
                    ]
                  ]
                ]),
            Table(
                border: TableBorder.all(color: ColorConst.blueColor),
                children: [
                  for (UserData item in value.list!) ...[
                    if (isUser) ...[
                      if (item.roleEnName == 'director') ...[
                        TableRow(children: [
                          GestureDetector(
                            onTap: () {
                              // onTapSyOfficer!();
                            },
                            child: Center(
                                child: Container(
                              height: 30,
                              padding: const EdgeInsets.only(top: 5, bottom: 5),
                              child: Text(item.userName!,
                                  style: const TextStyle(
                                      fontSize: 13, color: Colors.black)),
                            )),
                          ),
                        ]),
                      ]
                    ],
                    if (!isUser) ...[
                      if (item.roleEnName == 'officer') ...[
                        TableRow(children: [
                          GestureDetector(
                            onTap: () {
                              // onTapSyOfficer!();
                            },
                            child: Center(
                                child: Container(
                              height: 30,
                              padding: const EdgeInsets.only(top: 5, bottom: 5),
                              child: Text(item.userName!,
                                  style: const TextStyle(
                                      fontSize: 13, color: Colors.black)),
                            )),
                          ),
                        ]),
                      ]
                    ]
                  ]
                ]),
          ]),
        ]);
  }

  Center buildTableTitle({color, name}) {
    return Center(
      child: Padding(
        padding: const EdgeInsets.only(top: 8, bottom: 8),
        child: Text(name,
            style: TextStyle(
                fontWeight: FontWeight.bold, color: color, fontSize: 14)),
      ),
    );
  }

  Column buildTitle(icon, title) {
    return Column(
      children: [
        Row(
          children: [
            Icon(
              icon,
              color: ColorConst.blueColor,
              size: SizeConfig.isIpad()! ? 35 : 18,
            ),
            const SizedBox(width: 5),
            Text(
              title,
              style: TextStyle(
                  color: Colors.black54,
                  fontSize: SizeConfig.isIpad()! ? 25 : 14,
                  fontWeight: FontWeight.bold),
            ),
          ],
        ),
        DividerCustom(Colors.grey[300], 10, 5, 5, 10),
      ],
    );
  }

  ///日管控、周排查、月调度布局
  SliverPadding buildSliverDayWeekMonth() {
    return SliverPadding(
      padding: const EdgeInsets.only(left: 0, right: 0, top: 0, bottom: 0),
      // 使用SliverGrid来创建GridView
      sliver: SliverGrid(
        gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: checkItemList.length,
          crossAxisSpacing: 1,
          mainAxisSpacing: 1,
          childAspectRatio: 1 / 0.80, //子项的宽高比，值越大高度越高
        ),
        delegate: SliverChildBuilderDelegate(
          (BuildContext context, int index) {
            return AnimatedBuilder(
              animation: _animation,
              builder: (context, child) {
                return Transform.scale(
                  scale: _animation.value,
                  child: buildCheckItem(index),
                );
              },
            );
          },
          childCount: checkItemList.length,
        ),
      ),
    );
  }

  ///日管控、周排查、月调度布局
  SliverPadding buildSliverRiskDayWeekMonth() {
    return SliverPadding(
      padding: const EdgeInsets.only(left: 0, right: 0, top: 0, bottom: 0),
      // 使用SliverGrid来创建GridView
      sliver: SliverGrid(
        gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: checkItemRiskList.length,
          crossAxisSpacing: 1,
          mainAxisSpacing: 1,
          childAspectRatio:
              1 / (SizeConfig.isIpad()! ? 0.66 : 0.75), //子项的宽高比，值越大高度越高
        ),
        delegate: SliverChildBuilderDelegate(
          (BuildContext context, int index) {
            return AnimatedBuilder(
              animation: _animation,
              builder: (context, child) {
                return Transform.scale(
                  scale: _animation.value,
                  child: buildCheckRiskItem(index),
                );
              },
            );
          },
          childCount: checkItemRiskList.length,
        ),
      ),
    );
  }

  ///考核、考核历史、测试练习 布局
  SliverPadding buildSliverGridExamination() {
    return SliverPadding(
      padding: const EdgeInsets.only(left: 0, right: 0, top: 0, bottom: 0),
      // 使用SliverGrid来创建GridView
      sliver: SliverGrid(
        gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 3,
          crossAxisSpacing: 1,
          mainAxisSpacing: 1,
          childAspectRatio:
              1 / (SizeConfig.isIpad()! ? 0.66 : 0.83), //子项的宽高比，值越大高度越高
        ),
        delegate: SliverChildBuilderDelegate(
          (BuildContext context, int index) {
            return AnimatedBuilder(
              animation: _animation,
              builder: (context, child) {
                return Transform.scale(
                  scale: _animation.value,
                  child: buildExaminationItem(index),
                );
              },
            );
          },
          childCount: checkItemExaminationList.length,
        ),
      ),
    );
  }

  InkWell buildCheckRiskItem(index) {
    return InkWell(
      splashColor: ColorConst.green1Color,
      child: Column(
        children: [
          SizedBox(height: SizeConfig.isIpad()! ? 0 : 5),
          Stack(
            alignment: Alignment.center,
            children: [
              Container(
                width: SizeConfig.isIpad()! ? 150 : 50,
                height: SizeConfig.isIpad()! ? 150 : 50,
                decoration: BoxDecoration(
                  shape: BoxShape.circle, // 设定形状为圆形
                  gradient: LinearGradient(
                    begin: Alignment.topLeft,
                    end: Alignment.bottomRight,
                    stops: const [0.4, 0.5],
                    colors: [
                      checkItemRiskList[index].isContains
                          ? ColorConst.orange1Color
                          : ColorConst.greyC2Color,
                      checkItemRiskList[index].isContains
                          ? ColorConst.orangeColor
                          : ColorConst.greyC2Color,
                    ],
                  ),
                ),
              ),
              Image.asset(
                checkItemRiskList[index].image,
                width: SizeConfig.isIpad()! ? 60 : 30,
                height: SizeConfig.isIpad()! ? 60 : 30,
              ),
              Positioned(
                right: SizeConfig.isIpad()! ? 10 : 0,
                top: 0,
                child: Badge(
                  largeSize: SizeConfig.isIpad()! ? 25 : 15,
                  backgroundColor: Colors.red,
                  isLabelVisible: checkItemRiskList[index].isContains,
                  label: Text(
                    buildCount1(index)!,
                    style: TextStyle(fontSize: SizeConfig.isIpad()! ? 18 : 8),
                  ),
                ),
              )
            ],
          ),
          buildBottomText(checkItemRiskList[index].name),
        ],
      ),
      onTap: () {
        switch (index) {
          case 0:
            if (checkItemRiskList[index].isContains) {
              Get.toNamed(RouteString.TAB_SY, arguments: {
                'type': '1',
                'tabIndex': 1,
                'titleName': '日管控'
              })?.then((value) {
                if (value != null && value) {
                  ///获取日管控、周排查、月调度数量
                  getCount();
                }
              });
            } else {
              ToastUtils.showCenter('您没有权限访问');
            }
            break;
          case 1:
            if (checkItemRiskList[index].isContains) {
              Get.toNamed(RouteString.TAB_SY, arguments: {
                'type': '2',
                'tabIndex': 1,
                'titleName': '周排查'
              })?.then((value) {
                if (value != null && value) {
                  ///获取日管控、周排查、月调度数量
                  getCount();
                }
              });
            } else {
              ToastUtils.showCenter('您没有权限访问');
            }
            break;
          case 2:
            if (checkItemRiskList[index].isContains) {
              Get.toNamed(RouteString.TAB_SY, arguments: {
                'type': '3',
                'tabIndex': 1,
                'titleName': '月调度'
              })?.then((value) {
                if (value != null && value) {
                  ///获取日管控、周排查、月调度数量
                  getCount();
                }
              });
            } else {
              ToastUtils.showCenter('您没有权限访问');
            }
            break;
        }
      },
    );
  }

  InkWell buildCheckItem(index) {
    return InkWell(
      splashColor: ColorConst.green1Color,
      child: Column(
        // mainAxisAlignment: MainAxisAlignment.center,
        children: [
          SizedBox(height: SizeConfig.isIpad()! ? 30 : 5),
          Stack(
            alignment: Alignment.center,
            children: [
              Container(
                width: SizeConfig.isIpad()! ? 150 : 50,
                height: SizeConfig.isIpad()! ? 150 : 50,
                decoration: BoxDecoration(
                  shape: BoxShape.circle, // 设定形状为圆形
                  gradient: LinearGradient(
                    begin: Alignment.topLeft,
                    end: Alignment.bottomRight,
                    stops: const [0.4, 0.5],
                    colors: [
                      checkItemList[index].isContains
                          ? ColorConst.blue4Color
                          : ColorConst.greyC2Color,
                      checkItemList[index].isContains
                          ? ColorConst.blueColor
                          : ColorConst.greyC2Color,
                    ],
                  ),
                ),
              ),
              Image.asset(
                checkItemList[index].image,
                width: SizeConfig.isIpad()! ? 60 : 25,
                height: SizeConfig.isIpad()! ? 60 : 25,
              ),
              Positioned(
                right: SizeConfig.isIpad()! ? 10 : 0,
                top: 0,
                child: Badge(
                  largeSize: SizeConfig.isIpad()! ? 25 : 15,
                  backgroundColor: Colors.red,
                  isLabelVisible: checkItemList[index].isContains,
                  label: Text(
                    buildCount(index)!,
                    style: TextStyle(fontSize: SizeConfig.isIpad()! ? 18 : 8),
                  ),
                ),
              )
            ],
          ),
          buildBottomText(checkItemList[index].name),
        ],
      ),
      onTap: () {
        switch (index) {
          case 0:
            if (checkItemList[index].isContains) {
              Get.toNamed(RouteString.TAB_SY, arguments: {
                'type': '1',
                'tabIndex': 0,
                'titleName': '日管控'
              })?.then((value) {
                if (value != null && value) {
                  ///获取日管控、周排查、月调度数量
                  getCount();
                }
              });
            } else {
              ToastUtils.showCenter('您没有权限访问');
            }
            break;
          case 1:
            if (checkItemList[index].isContains) {
              Get.toNamed(RouteString.TAB_SY, arguments: {
                'type': '2',
                'tabIndex': 0,
                'titleName': '周排查'
              })?.then((value) {
                if (value != null && value) {
                  ///获取日管控、周排查、月调度数量
                  getCount();
                }
              });
            } else {
              ToastUtils.showCenter('您没有权限访问');
            }
            break;
          case 2:
            if (checkItemList[index].isContains) {
              Get.toNamed(RouteString.TAB_SY, arguments: {
                'type': '3',
                'tabIndex': 0,
                'titleName': '月调度'
              })?.then((value) {
                if (value != null && value) {
                  ///获取日管控、周排查、月调度数量
                  getCount();
                }
              });
            } else {
              ToastUtils.showCenter('您没有权限访问');
            }
            break;
        }
      },
    );
  }

  ///考核、考核历史、测试练习 item布局
  InkWell buildExaminationItem(index) {
    return InkWell(
      splashColor: ColorConst.green1Color,
      child: Column(
        children: [
          SizedBox(height: SizeConfig.isIpad()! ? 30 : 5),
          Stack(
            alignment: Alignment.center,
            children: [
              Image.asset(
                checkItemExaminationList[index].image,
                width: SizeConfig.isIpad()! ? 150 : 50,
                height: SizeConfig.isIpad()! ? 150 : 50,
              ),
            ],
          ),
          buildBottomText(checkItemExaminationList[index].name),
        ],
      ),
      onTap: () {
        switch (index) {
          ///考核
          case 0:
            getClickQuestionsPerson();
            // Get.toNamed(RouteString.EXAM_PAGE,
            //         arguments: {'type': '1', 'tabIndex': 0, 'titleName': '考核'})
            //     ?.then((value) {
            //   if (value != null && value) {}
            // });
            break;

          ///考核历史
          case 1:
            // Get.toNamed(RouteString.OVERSEER_SETTINGS_PAGE, arguments: {
            //   'type': '2',
            //   'tabIndex': 0,
            //   'titleName': '考核历史'
            // })?.then((value) {
            //   if (value != null && value) {}
            // });
            // Get.toNamed(RouteString.TEST_PAGE, arguments: {
            //   // 'type': '3',
            //   // 'tabIndex': 0,
            //   // 'titleName': '测试练习'
            // })?.then((value) {
            //   if (value != null && value) {}
            // });

            Get.toNamed(RouteString.TEST_SETTING_PAGE, arguments: {
              'roles': roleNamesText(unitId),
              'unitType': unitId
            })?.then((value) {
              if (value != null && value) {}
            });
            break;

          ///测试练习
          case 2:
            Get.toNamed(RouteString.EXAM_HISTORY_PAGE, arguments: {
              'type': '2',
              'tabIndex': 0,
              'titleName': '考核历史'
            })?.then((value) {
              if (value != null && value) {}
            });
            break;
        }
      },
    );
  }

  ///欢迎、身份
  SliverToBoxAdapter buildStanding() {
    return SliverToBoxAdapter(
      child: Container(
        padding: const EdgeInsets.only(left: 5),
        color: ColorConst.whiteColor,
        child: Column(
          children: [
            const SizedBox(
              height: 5,
            ),
            Row(
              children: [
                const SizedBox(
                  width: 3,
                ),
                Icon(
                  Icons.volume_down,
                  size: SizeConfig.isIpad()! ? 30 : 20,
                  color: ColorConst.blueColor,
                ),
                const SizedBox(
                  width: 3,
                ),
                Expanded(
                  child: Text.rich(
                      softWrap: true,
                      TextSpan(children: [
                        TextSpan(
                            text: '欢迎 ',
                            style: TextStyle(
                                color: Colors.black54,
                                fontSize: SizeConfig.isIpad()! ? 20 : 12,
                                fontStyle: FontStyle.normal)),
                        TextSpan(
                            text: officeName + '-' + userName,
                            style: TextStyle(
                                color: Colors.black54,
                                fontSize: SizeConfig.isIpad()! ? 20 : 12,
                                fontWeight: FontWeight.bold)),
                      ])),
                ),
              ],
            ),
            const SizedBox(
              height: 3,
            ),
            Row(
              children: [
                const SizedBox(
                  width: 3,
                ),
                Icon(
                  Icons.person_rounded,
                  size: SizeConfig.isIpad()! ? 30 : 20,
                  color: ColorConst.blueColor,
                ),
                const SizedBox(
                  width: 3,
                ),
                Text.rich(TextSpan(children: [
                  TextSpan(
                      text: '您的身份：',
                      style: TextStyle(
                          color: Colors.black54,
                          fontSize: SizeConfig.isIpad()! ? 20 : 12,
                          fontStyle: FontStyle.normal)),
                  TextSpan(
                      text: roleNamesText(unitId),
                      style: TextStyle(
                          color: Colors.black54,
                          fontSize: SizeConfig.isIpad()! ? 20 : 12,
                          fontWeight: FontWeight.bold))
                ])),
              ],
            ),
            const SizedBox(
              height: 5,
            ),
          ],
        ),
      ),
    );
  }

  ///切换使用单位、生产单位（安全总监、安全员加质量），重新赋值身份
  roleNamesText(unitId) {
    var roleName = '';
    if (roleNames.contains(StandingConfig.SAFETY_DIRECTOR) ||
        roleNames.contains(StandingConfig.SAFETY_OFFICER) ||
        roleNames.contains(StandingConfig.PERSON_CHARGE)) {
      var roleNameStr = roleNames.split(',');
      if (roleNames.contains(StandingConfig.PERSON_CHARGE)) {
        if (roleNameStr.length == 1) {
          roleName = roleName += '主要负责人';
        } else {
          roleName = roleName += '主要负责人,';
        }
      } else {
        roleName = roleName += '';
      }

      ///使用单位
      if (unitId == '1') {
        //安全总监、安全员
        if (roleNames.contains(StandingConfig.SAFETY_DIRECTOR) &&
            roleNames.contains(StandingConfig.SAFETY_OFFICER)) {
          roleName = roleName += '安全总监,安全员';
        } else if (roleNames.contains(StandingConfig.SAFETY_OFFICER)) {
          //安全员
          roleName = roleName += '安全员';
        } else if (roleNames.contains(StandingConfig.SAFETY_DIRECTOR)) {
          //安全总监
          roleName = roleName += '安全总监';
        }

        ///生产单位
      } else if (unitId == '2') {
        //安全总监、安全员
        if (roleNames.contains(StandingConfig.SAFETY_DIRECTOR) &&
            roleNames.contains(StandingConfig.SAFETY_OFFICER)) {
          roleName = roleName += '质量安全总监,质量安全员';
        } else if (roleNames.contains(StandingConfig.SAFETY_OFFICER)) {
          //安全员
          roleName = roleName += '质量安全员';
        } else if (roleNames.contains(StandingConfig.SAFETY_DIRECTOR)) {
          //安全总监
          roleName = roleName += '质量安全总监';
        }
      }
    } else {
      roleName = roleNames;
    }
    return roleName;
  }

  String? buildCount(index) {
    if (index == 0) {
      return dayCount ?? '0';
    } else if (index == 1) {
      return weekCount ?? '0';
    } else if (index == 2) {
      return monthCount ?? '0';
    } else {
      return '0';
    }
  }

  String? buildCount1(index) {
    if (index == 0) {
      return dayRiskCount ?? '0';
    } else if (index == 1) {
      return weekRiskCount ?? '0';
    } else if (index == 2) {
      return monthRiskCount ?? '0';
    } else {
      return '0';
    }
  }

  //字
  Container buildBottomText(name, [color]) {
    return Container(
      height: SizeConfig.isIpad()! ? 40 : 20,
      margin: const EdgeInsets.only(top: 3),
      child: Text(
        name,
        style:
            TextStyle(fontSize: SizeConfig.isIpad()! ? 25 : 13, color: color),
      ),
    );
  }

  SliverToBoxAdapter buildSliverStatistics(BuildContext context) {
    return SliverToBoxAdapter(
        child: Container(
            margin: const EdgeInsets.only(top: 0, left: 8, right: 8),
            padding: const EdgeInsets.all(10),
            decoration: const BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.all(Radius.circular(5)),
            ),
            child: Column(
              children: [
                buildTitle(Icons.equalizer, '统计'),
                HomeEchartTab(
                    roleNames,
                    completedDayNum,
                    incompletedDayNum,
                    xDateDayListJson,
                    completedWeekNum,
                    incompletedWeekNum,
                    xDateWeekListJson,
                    completedMonthNum,
                    incompletedMonthNum,
                    xDateMonthListJson),
              ],
            )));
  }

  SliverAppBar buildSliverAppBar() {
    return SliverAppBar(
      expandedHeight: SizeConfig.isIpad()! ? 300 : 190.0,
      floating: true,
      pinned: true,
      flexibleSpace: FlexibleSpaceBar(
        centerTitle: true,
        background: Stack(
          children: [
            if (bannerList!.isEmpty) ...[
              Image.asset('assets/banner/banner0.png',
                  width: MediaQuery.of(context).size.width,
                  height: MediaQuery.of(context).size.height,
                  fit: BoxFit.fill)
            ] else ...[
              CardSwiper(
                bannerList: bannerList,
              )
            ],
            Positioned(
              bottom: SizeConfig.isIpad()! ? 190 : 5,
              // left: SizeConfig.isIpad()!
              //     ? MediaQuery.of(context).size.width / 2 - 70
              //     : MediaQuery.of(context).size.width / 2 - 50,
              child: isRolesName(StorageUtil.getInstance().getRoleNames())
                  ? _buildCheckUnit()
                  : const SizedBox(),
            )
          ],
        ),
      ),
      // title: Column(
      //   children: [
      //     Text(
      //       '晋特保助手',
      //       style: TextStyle(fontSize: SizeConfig.isIpad()! ? 35 : 20),
      //     ),
      //   ],
      // ),
      actions: [
        InkWell(
          onTap: () {
            showDialog(
                context: context,
                builder: (context) {
                  return AlertDialog(
                    content: const Text("您确定要退出登录吗？"),
                    actions: [
                      TextButton(
                        child: const Text("取消"),
                        onPressed: () {
                          Navigator.of(context).pop();
                        },
                      ),
                      TextButton(
                          child: const Text("确定"),
                          onPressed: () {
                            _loginOut();
                          })
                    ],
                  );
                });
          },
          child: Padding(
              padding: const EdgeInsets.only(
                  left: 15, right: 5, top: 12, bottom: 12),
              child: Container(
                width: 35,
                decoration: BoxDecoration(
                    color: Colors.white24,
                    borderRadius: BorderRadius.circular(15.0)),
                child: Icon(Icons.power_settings_new,
                    size: SizeConfig.isIpad()! ? 40 : 25, color: Colors.orange),
              )),
        ),
        const SizedBox(
          width: 10,
        ),
      ],
    );
  }

  ///退出登录
  _loginOut() async {
    HttpUtils.doLoginOut(context).then((value) {
      if (mounted) {
        ///清除本地所有数据
        // StorageUtil.getInstance().clearAll();
        StorageUtil.getInstance().remove(SpKeys.JSESSION_ID);
        Get.offAllNamed(RouteString.LOGIN);
      }
    });
  }

  ///切换单位
  Row _buildCheckUnit() {
    return Row(
      // mainAxisAlignment: MainAxisAlignment.center,
      children: [
        Container(
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10.0),
            boxShadow: const [
              BoxShadow(
                color: Colors.black87,
                offset: Offset(-30.0, 0),
                blurRadius: 20.0,
                spreadRadius: 0,
              ),
              BoxShadow(
                color: Colors.black87,
                offset: Offset(5.0, 0),
                blurRadius: 20.0,
                spreadRadius: 0,
              )
            ],
          ),
          margin: const EdgeInsets.only(top: 1),
          child: PopupMenuButton<int>(
            shadowColor: ColorConst.whiteColor,
            offset: const Offset(-10, 25),
            shape: RoundedRectangleBorder(
              // side: BorderSide(color: Colors.red, width: 2),
              borderRadius: BorderRadius.circular(5),
            ),
            child: Container(
              padding:
                  const EdgeInsets.only(left: 10, top: 3, right: 3, bottom: 5),
              // decoration: BoxDecoration(
              //   border: Border.all(color: ColorConst.whiteColor, width: 0.5),
              //   borderRadius: const BorderRadius.only(
              //       topLeft: Radius.circular(0),
              //       topRight: Radius.circular(5),
              //       bottomLeft: Radius.circular(0),
              //       bottomRight: Radius.circular(5)),
              // ),
              child: Row(
                children: [
                  const SizedBox(width: 0),
                  Text(unitName,
                      style: TextStyle(
                          fontSize: SizeConfig.isIpad()! ? 25 : 14,
                          color: ColorConst.whiteColor,
                          fontWeight: FontWeight.bold)),
                  const Icon(
                    Icons.arrow_drop_down,
                    color: ColorConst.whiteColor,
                    size: 20,
                  )
                ],
              ),
            ),
            itemBuilder: (context) => [
              for (var i = 0; i < unitList.length; i++) ...[
                PopupMenuItem(
                  height: 35,
                  padding: const EdgeInsets.only(
                      left: 25, right: 0, top: 0, bottom: 0),
                  value: i,
                  child: Text('${unitList[i].name}',
                      style:
                          const TextStyle(color: Colors.black, fontSize: 13)),
                ),
              ],
            ],
            onSelected: (value) {
              setState(() {
                unitName = unitList[value].name;
                unitId = unitList[value].id;
                StorageUtil.getInstance().set(SpKeys.UNIT_STATUS, unitId);
                getCount();
                Get.snackbar("提示", "您已切换到<$unitName>",
                    colorText: Colors.black,
                    backgroundColor: ColorConst.whiteColor,
                    snackPosition: SnackPosition.TOP, // 这里设置弹窗出现在顶部
                    duration: const Duration(seconds: 1));
              });
            },
          ),
        ),
      ],
    );
  }

  // ///切换单位
  // Row _buildCheckUnit() {
  //   return Row(
  //     mainAxisAlignment: MainAxisAlignment.center,
  //     children: [
  //       PopupMenuButton<int>(
  //         padding: const EdgeInsets.all(0),
  //         shadowColor: ColorConst.themeBgColor,
  //         offset: const Offset(3.5, 30),
  //         shape: RoundedRectangleBorder(
  //           // side: BorderSide(color: Colors.red, width: 2),
  //           borderRadius: BorderRadius.circular(10),
  //         ),
  //         child: Container(
  //           padding:
  //               const EdgeInsets.only(left: 20, top: 5, right: 10, bottom: 5),
  //           decoration: BoxDecoration(
  //             border: Border.all(color: Colors.white, width: 0.5),
  //             borderRadius: BorderRadius.circular(10),
  //           ),
  //           child: Row(
  //             children: [
  //               const SizedBox(width: 0),
  //               Text(unitName,
  //                   style: TextStyle(
  //                       fontSize: SizeConfig.isIpad()! ? 25 : 14,
  //                       color: Colors.white)),
  //               const Icon(
  //                 Icons.arrow_drop_down,
  //                 color: Colors.white,
  //                 size: 18,
  //               )
  //             ],
  //           ),
  //         ),
  //         itemBuilder: (context) => [
  //           for (var i = 0; i < unitList.length; i++) ...[
  //             PopupMenuItem(
  //               height: 35,
  //               padding: const EdgeInsets.only(
  //                   left: 25, right: 0, top: 0, bottom: 0),
  //               value: i,
  //               child: Text('${unitList[i].name}',
  //                   style: const TextStyle(color: Colors.black, fontSize: 14)),
  //             ),
  //           ],
  //         ],
  //         onSelected: (value) {
  //           setState(() {
  //             unitName = unitList[value].name;
  //             unitId = unitList[value].id;
  //             StorageUtil.getInstance().set(SpKeys.UNIT_STATUS, unitId);
  //             getCount();
  //             Get.snackbar("提示", "您已切换到<$unitName>",
  //                 colorText: Colors.black,
  //                 backgroundColor: ColorConst.whiteColor,
  //                 snackPosition: SnackPosition.TOP, // 这里设置弹窗出现在顶部
  //                 duration: const Duration(seconds: 1));
  //           });
  //         },
  //       ),
  //     ],
  //   );
  // }

  ///获取数据
  void getCount() {
    ///判断是否是公司账户、管理员、市场监管局登录，是：显示统计图
    if (isRolesName1(StorageUtil.getInstance().getRoleNames())) {
      ///判断是否有权限访问
      if (roleNames.contains(StandingConfig.SAFETY_OFFICER)) {
        ///获取日管控数量
        HttpUtils.doCount(context, '0', '1').then((value) {
          CountBo countBo = value;
          if (mounted) {
            setState(() {
              dayCount = countBo.userAllTaskDayCount.toString();
            });
          }
        });

        ///获取日管控整改数量
        HttpUtils.doCount(context, '2', '1').then((value) {
          CountBo countBo = value;
          if (mounted) {
            setState(() {
              dayRiskCount = countBo.userAllTaskDayCount.toString();
            });
          }
        });

        HttpUtils.doEchartDay(context, '1').then((value) {
          EchartBo echartBo = value;
          if (mounted) {
            setState(() {
              List<String>? xDateDayList = [];
              completedDayNum!.clear();
              incompletedDayNum!.clear();
              xDateDayList.clear();
              for (var item in echartBo.sevenTaskCounts!) {
                completedDayNum!.add(item.completedNum.toString());
                incompletedDayNum!.add(item.incompletedNum.toString());
                String formattedDate =
                    DateFormat('MM.dd').format(DateTime.parse(item.dateStr!));
                xDateDayList.add(formattedDate);
              }
              xDateDayListJson = jsonEncode(xDateDayList);
            });
          }
        });
      }

      ///判断是否有权限访问
      if (roleNames.contains(StandingConfig.SAFETY_DIRECTOR)) {
        ///获取周排查数量
        HttpUtils.doCount(context, '0', '2').then((value) {
          CountBo countBo = value;
          if (mounted) {
            setState(() {
              weekCount = countBo.userAllTaskWeekCount.toString();
            });
          }
        });

        ///获取周排查数量
        HttpUtils.doCount(context, '2', '2').then((value) {
          CountBo countBo = value;
          if (mounted) {
            setState(() {
              weekRiskCount = countBo.userAllTaskWeekCount.toString();
            });
          }
        });
        HttpUtils.doEchartDay(context, '2').then((value) {
          EchartBo echartBo = value;
          if (mounted) {
            setState(() {
              List<String>? xDateWeekList = [];
              completedWeekNum!.clear();
              incompletedWeekNum!.clear();
              xDateWeekList.clear();
              for (var item in echartBo.sevenTaskCounts!) {
                completedWeekNum!.add(item.completedNum.toString());
                incompletedWeekNum!.add(item.incompletedNum.toString());
                xDateWeekList.add('${item.dateStr}周');
              }
              xDateWeekListJson = jsonEncode(xDateWeekList);
            });
          }
        });
      }

      ///判断是否有权限访问
      if (roleNames.contains(StandingConfig.PERSON_CHARGE)) {
        ///获取月调度数量
        HttpUtils.doCount(context, '0', '3').then((value) {
          CountBo countBo = value;
          if (mounted) {
            setState(() {
              monthCount = countBo.userAllTaskMonthCount.toString();
            });
          }
        });

        ///获取月调度数量
        HttpUtils.doCount(context, '2', '3').then((value) {
          CountBo countBo = value;
          if (mounted) {
            setState(() {
              monthRiskCount = countBo.userAllTaskMonthCount.toString();
            });
          }
        });
        HttpUtils.doEchartDay(context, '3').then((value) {
          EchartBo echartBo = value;
          if (mounted) {
            setState(() {
              List<String>? xDateMonthList = [];
              completedMonthNum!.clear();
              incompletedMonthNum!.clear();
              xDateMonthList.clear();
              for (var item in echartBo.sevenTaskCounts!) {
                completedMonthNum!.add(item.completedNum.toString());
                incompletedMonthNum!.add(item.incompletedNum.toString());
                xDateMonthList.add('${item.dateStr}月');
              }
              xDateMonthListJson = jsonEncode(xDateMonthList);
            });
          }
        });
      }
    } else {
      HttpUtils.doEchartDay(context, '1').then((value) {
        EchartBo echartBo = value;
        if (mounted) {
          setState(() {
            List<String>? xDateDayList = [];
            completedDayNum!.clear();
            incompletedDayNum!.clear();
            xDateDayList.clear();
            for (var item in echartBo.sevenTaskCounts!) {
              completedDayNum!.add(item.completedNum.toString());
              incompletedDayNum!.add(item.incompletedNum.toString());
              String formattedDate =
                  DateFormat('MM.dd').format(DateTime.parse(item.dateStr!));
              xDateDayList.add(formattedDate);
            }
            xDateDayListJson = jsonEncode(xDateDayList);
          });
        }
      });
      HttpUtils.doEchartDay(context, '2').then((value) {
        EchartBo echartBo = value;
        if (mounted) {
          setState(() {
            List<String>? xDateWeekList = [];
            completedWeekNum!.clear();
            incompletedWeekNum!.clear();
            xDateWeekList.clear();
            for (var item in echartBo.sevenTaskCounts!) {
              completedWeekNum!.add(item.completedNum.toString());
              incompletedWeekNum!.add(item.incompletedNum.toString());
              xDateWeekList.add('${item.dateStr}周');
            }
            xDateWeekListJson = jsonEncode(xDateWeekList);
          });
        }
      });
      HttpUtils.doEchartDay(context, '3').then((value) {
        EchartBo echartBo = value;
        if (mounted) {
          setState(() {
            List<String>? xDateMonthList = [];
            completedMonthNum!.clear();
            incompletedMonthNum!.clear();
            xDateMonthList.clear();
            for (var item in echartBo.sevenTaskCounts!) {
              completedMonthNum!.add(item.completedNum.toString());
              incompletedMonthNum!.add(item.incompletedNum.toString());
              xDateMonthList.add('${item.dateStr}月');
            }
            xDateMonthListJson = jsonEncode(xDateMonthList);
          });
        }
      });
    }
  }

  /// 检查是否需要版本更新
  Future<bool> checkUpdateVersion() async {
    PackageInfo packageInfo = await PackageInfo.fromPlatform();
    var versionCodeLoc = packageInfo.buildNumber;
    bool check = false;
    HttpUtils.getVersionUpdate(context).then((value) {
      VersionBo versionBo = value;
      var apkVersion = versionBo.apkVersion;
      if (apkVersion == null) {
        return;
      }
      var versionCode = int.parse(apkVersion.verionCode!);

      ///本地versionCode小于接口返回versionCode提示升级
      if (int.parse(versionCodeLoc) < versionCode) {
        ///android端
        if (Platform.isAndroid) {
          AppInfo appInfo = AppInfo();
          appInfo.versionCode = versionCode;
          appInfo.updateLog = apkVersion.updateLog;
          appInfo.isForce = true; //是否强制更新
          appInfo.hasUpdate = true; //是否有新版本
          appInfo.isIgnorable = false; //是否可忽略该版本
          appInfo.versionName = apkVersion.versionName;
          appInfo.apkUrl = apkVersion.apkUrl;
          appInfo.apkSize = int.parse(apkVersion.apkSize!);
          appUpdate(appInfo);
        } else if (Platform.isIOS) {
          WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
            showDialog(
                context: context,
                barrierDismissible: false,
                builder: (context) {
                  return AlertDialog(
                    title: Text("请更新版本到${apkVersion.versionName}"),
                    content: Text(apkVersion.updateLog!),
                    actions: <Widget>[
                      InkWell(
                        onTap: () {
                          /// 在这里添加打开应用商店的代码
                          _launchURL();
                        },
                        child: Center(
                          child: Container(
                            alignment: Alignment.center,
                            width: MediaQuery.of(context).size.width * 0.6,
                            height: 40,
                            decoration: const BoxDecoration(
                              color: ColorConst.blueColor,
                              borderRadius:
                                  BorderRadius.all(Radius.circular(5)),
                            ),
                            // color: ColorConst.blueColor,
                            child: const Text("去更新",
                                style: TextStyle(
                                    fontSize: 16,
                                    color: ColorConst.whiteColor)),
                          ),
                        ),
                      ),
                    ],
                  );
                });
          });
        }
      }
    });
    return check;
  }

  final Uri _url = Uri.parse('https://apps.apple.com/cn/app/id6469591631');

  _launchURL() async {
    if (await canLaunchUrl(_url)) {
      await launchUrl(_url);
    } else {
      throw 'Could not launch $_url';
    }
  }

  void appUpdate(appInfo) async {
    CheckUpdate checkUpdate = CheckUpdate();
    await checkUpdate.initXUpdate();
    await checkUpdate.checkUpdateByUpdateEntity(appInfo);
  }

  @override
  void dispose() {
    if (_controller != null) {
      _controller.dispose();
    }
    super.dispose();
    event?.cancel();
  }

  void getGirdviewData() {
    checkItemList.add(HomeMenuItem(
        image: 'assets/home/day_control_white_icon.png',
        name: '日管控',
        isContains: roleNames.contains(StandingConfig.SAFETY_OFFICER)));
    checkItemList.add(HomeMenuItem(
        image: 'assets/home/weekly_survey_white_icon.png',
        name: '周排查',
        isContains: roleNames.contains(StandingConfig.SAFETY_DIRECTOR)));
    checkItemList.add(HomeMenuItem(
        image: 'assets/home/monthly_scheduling_white_icon.png',
        name: '月调度',
        isContains: roleNames.contains(StandingConfig.PERSON_CHARGE)));

    checkItemRiskList.add(HomeMenuItem(
        image: 'assets/home/risk_bg_icon.png',
        name: '日整改',
        isContains: roleNames.contains(StandingConfig.SAFETY_OFFICER)));
    checkItemRiskList.add(HomeMenuItem(
        image: 'assets/home/risk_bg_icon.png',
        name: '周整改',
        isContains: roleNames.contains(StandingConfig.SAFETY_DIRECTOR)));
    checkItemRiskList.add(HomeMenuItem(
        image: 'assets/home/risk_bg_icon.png',
        name: '月整改',
        isContains: roleNames.contains(StandingConfig.PERSON_CHARGE)));

    checkItemSettingsList.add(HomeMenuItem(
        image: 'assets/home/user_settings_icon.png',
        name: '用户设置',
        isContains: roleNames.contains(StandingConfig.SAFETY_OFFICER)));
    checkItemSettingsList.add(HomeMenuItem(
        image: 'assets/home/equipment_settings_icon.png',
        name: '设备设置',
        isContains: roleNames.contains(StandingConfig.SAFETY_DIRECTOR)));
    checkItemSettingsList.add(HomeMenuItem(
        image: 'assets/home/unit_settings_icon.png',
        name: '单位设置',
        isContains: roleNames.contains(StandingConfig.PERSON_CHARGE)));
  }

// _requestPermission() async {
//   // var camera = await Permission.camera.status;
//   // var storage = await Permission.storage.status;
//   var location = await Permission.location.status;
//   if (location != PermissionStatus.granted) {
//     var future = await [
//       Permission.location,
//     ].request();
//
//     for (final item in future.entries) {
//       if (item.value != PermissionStatus.granted) {
//         return false;
//       }
//     }
//   }
//   return true;
// }
}
