// ignore_for_file: use_key_in_widget_constructors

import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:flutter_echarts/flutter_echarts.dart';
import 'package:intl/intl.dart';
import 'package:special_equipment_flutter/dio/http_utils.dart';
import 'package:special_equipment_flutter/widgets/emptyI_small_img_widget.dart';

import '../../../model/echart_bo.dart';

///周排查柱状图
class WeeklySurveyEchart extends StatefulWidget {
  var completedWeekNum, incompletedWeekNum;
  var xDateWeekListJson;

  WeeklySurveyEchart(
      this.completedWeekNum, this.incompletedWeekNum, this.xDateWeekListJson,
      {Key? key})
      : super(key: key);

  @override
  State<WeeklySurveyEchart> createState() => _WeeklySurveyEchartState();
}

class _WeeklySurveyEchartState extends State<WeeklySurveyEchart> {
  // List<dynamic> completedNum = [];
  // List<dynamic> incompletedNum = [];
  // List<String> dateList = [];
  // String? _jsonEncodeDate;

  @override
  void initState() {
    super.initState();
    // HttpUtils.doEchartDay(context, '2').then((value) {
    //   EchartBo echartBo = value;
    //   if (mounted) {
    //     setState(() {
    //       for (var item in echartBo.sevenTaskCounts!) {
    //         completedNum.add(item.completedNum.toString());
    //         incompletedNum.add(item.incompletedNum.toString());
    //         dateList.add('${item.dateStr}周');
    //       }
    //       _jsonEncodeDate = jsonEncode(dateList);
    //     });
    //   }
    // });
  }

  @override
  Widget build(BuildContext context) {
    return SizedBox(
//      width: MediaQuery.of(context).size.width,
      height: 210,
      child: Stack(
        children: [
          // if (widget.completedWeekNum.isEmpty) ...[
          //   const EmptySmallImgWidget(
          //     title: '暂无周统计数据',
          //   )
          // ],
          Echarts(
            option: '''
              {
//            title: {
//              text: '日管控统计',
//              textStyle:{
//                fontSize: 15,
//                fontWeight: "bold",
//                color: "#464646"
//              }
//            },
                tooltip: {},
                legend: {
                  data:['未完成','已完成'],
                  right: '0%',
                  itemWidth: 10,
                  itemHeight: 10,
                  textStyle:{
                  fontSize: 10,
                  color: "#666666"
                }
                },
                grid: {
                 borderWidth: 0,
                 top: 35,
                 left: 25,
                 right: 5,
                 bottom: 25,
                },
                xAxis: {
                  data: ${widget.xDateWeekListJson},
                  type: 'category',
                  axisLabel: {
                  color: '#666666', // 文字颜色
                  fontSize: 11 // 字体大小
                }
                },
                yAxis: {
                 axisLabel: {
                  color: '#666666', // 文字颜色
                  fontSize: 11 // 字体大小
                }},
                series: [{
                  name: '未完成',
                  type: 'bar',
                  itemStyle: {
                  color: {
                    type: 'linear',
                    x: 0,
                    y: 0,
                    x2: 0,
                    y2: 1,
                    colorStops: [{
                        offset: 0, color: '#E99D42' // 0% 处的颜色
                    }, {
                        offset: 0.5, color: '#E98D5C' // 50% 处的颜色
                    }, {
                        offset: 1, color: '#E0620D' // 100% 处的颜色
                    }],
                    globalCoord: false // 缺省为 false
                    }
                },
                 label: {
                  show: true,
                  position: 'top',
                  textStyle:{
                    fontSize: 8,
                    color: "#E0620D"
                  }
                },
                  data: ${widget.incompletedWeekNum},
                },{
                  name: '已完成',
                  type: 'bar',
                  itemStyle: {
                  color: {
                    type: 'linear',
                    x: 0,
                    y: 0,
                    x2: 0,
                    y2: 1,
                    colorStops: [{
                        offset: 0, color: '#64B5F6' // 0% 处的颜色
                    }, {
                        offset: 0.5, color: '#3469C1' // 50% 处的颜色
                    }, {
                        offset: 1, color: '#3469C1' // 100% 处的颜色
                    }],
                    globalCoord: false // 缺省为 false
                    }
                },
                 label: {
                  show: true,
                  position: 'top',
                  textStyle:{
                    fontSize: 8,
                    color: "#3469C1"
                  }
                },
                  data: ${widget.completedWeekNum},
                }]
              }
              ''',
          )
        ],
      ),
    );
  }
}
