import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/ui/common/data.dart';
import 'package:special_equipment_flutter/ui/main/echart/day_control_echart.dart';
import 'package:special_equipment_flutter/ui/main/echart/monthly_scheduling_echart.dart';
import 'package:special_equipment_flutter/ui/main/echart/weekly_survey_echart.dart';
import 'package:special_equipment_flutter/utils/size_config.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';

import '../../../common/color_const.dart';

class HomeEchartTab extends StatelessWidget {
  var roleNames, xDateDayListJson, xDateWeekListJson, xDateMonthListJson;

  List<dynamic>? completedDayNum, incompletedDayNum;

  List<dynamic>? completedWeekNum = [], incompletedWeekNum;

  List<dynamic>? completedMonthNum, incompletedMonthNum;

  HomeEchartTab(
      this.roleNames,
      this.completedDayNum,
      this.incompletedDayNum,
      this.xDateDayListJson,
      this.completedWeekNum,
      this.incompletedWeekNum,
      this.xDateWeekListJson,
      this.completedMonthNum,
      this.incompletedMonthNum,
      this.xDateMonthListJson,
      {super.key});

  @override
  Widget build(BuildContext context) {
    return buildDefaultTabControllers(
        context,
        roleNames,
        completedDayNum,
        incompletedDayNum,
        xDateDayListJson,
        completedWeekNum,
        incompletedWeekNum,
        xDateWeekListJson,
        completedMonthNum,
        incompletedMonthNum,
        xDateMonthListJson);
  }
}

SizedBox buildDefaultTabControllers(
    BuildContext context,
    roleNames,
    completedDayNum,
    incompletedDayNum,
    xDateDayListJson,
    completedWeekNum,
    incompletedWeekNum,
    xDateWeekListJson,
    completedMonthNum,
    incompletedMonthNum,
    xDateMonthListJson) {
  return SizedBox(
    height: 240,
    child: DefaultTabController(
      length: isRolesName(StorageUtil.getInstance().getRoleNames())
          ? roleNames.split(',').length
          : 3,
      child: Column(
        children: <Widget>[
          Container(
            child: tabBar(roleNames),
          ),
          Expanded(
            child: TabBarView(
              children: [
                if (isRolesName(StorageUtil.getInstance().getRoleNames())) ...[
                  if (roleNames.contains(StandingConfig.SAFETY_OFFICER)) ...[
                    DayControlEchart(
                        completedDayNum, incompletedDayNum, xDateDayListJson)
                  ],
                  if (roleNames.contains(StandingConfig.SAFETY_DIRECTOR)) ...[
                    WeeklySurveyEchart(
                        completedWeekNum, incompletedWeekNum, xDateWeekListJson)
                  ],
                  if (roleNames.contains(StandingConfig.PERSON_CHARGE)) ...[
                    MonthlySchedulingEchart(completedMonthNum,
                        incompletedMonthNum, xDateMonthListJson)
                  ]
                ] else ...[
                  DayControlEchart(
                      completedDayNum, incompletedDayNum, xDateDayListJson),
                  WeeklySurveyEchart(
                      completedWeekNum, incompletedWeekNum, xDateWeekListJson),
                  MonthlySchedulingEchart(completedMonthNum,
                      incompletedMonthNum, xDateMonthListJson),
                ]
              ],
            ),
          ),
        ],
      ),
    ),
  );
}

Container tabBar(roleNames) {
  return Container(
    height: SizeConfig.isIpad()! ? 40 : 25,
    margin: const EdgeInsets.only(top: 5, bottom: 5),
    decoration: BoxDecoration(
      border: Border.all(color: ColorConst.blue1Color, width: 0.7),
      borderRadius: BorderRadius.circular(5),
    ),
    child: TabBar(
      unselectedLabelColor: ColorConst.blueColor,
      unselectedLabelStyle: const TextStyle(fontSize: 12),
      indicatorSize: TabBarIndicatorSize.tab,
      labelPadding:
          const EdgeInsets.only(left: 15, right: 15, top: 0, bottom: 0),
      isScrollable: true,
      padding: const EdgeInsets.all(0.0),
      indicatorWeight: 3,
      indicatorPadding: const EdgeInsets.all(0),
      indicator: BoxDecoration(
        gradient: const LinearGradient(
          colors: [
            ColorConst.blueColor,
            ColorConst.blue1Color,
          ],
        ),
        borderRadius: BorderRadius.circular(3),
      ),
      tabs: [
        if (isRolesName(StorageUtil.getInstance().getRoleNames())) ...[
          if (roleNames.contains(StandingConfig.SAFETY_OFFICER)) ...[
            Tab(
              child: Align(
                alignment: Alignment.center,
                child: Text(
                  "日管控",
                  style: TextStyle(fontSize: SizeConfig.isIpad()! ? 25 : 12),
                ),
              ),
            ),
          ],
          if (roleNames.contains(StandingConfig.SAFETY_DIRECTOR)) ...[
            Tab(
              child: Align(
                alignment: Alignment.center,
                child: Text("周排查",
                    style: TextStyle(fontSize: SizeConfig.isIpad()! ? 25 : 12)),
              ),
            )
          ],
          if (roleNames.contains(StandingConfig.PERSON_CHARGE)) ...[
            Tab(
              child: Align(
                alignment: Alignment.center,
                child: Text("月调度",
                    style: TextStyle(fontSize: SizeConfig.isIpad()! ? 25 : 12)),
              ),
            ),
          ]
        ] else ...[
          Tab(
            child: Align(
              alignment: Alignment.center,
              child: Text(
                "日管控",
                style: TextStyle(fontSize: SizeConfig.isIpad()! ? 25 : 12),
              ),
            ),
          ),
          Tab(
            child: Align(
              alignment: Alignment.center,
              child: Text("周排查",
                  style: TextStyle(fontSize: SizeConfig.isIpad()! ? 25 : 12)),
            ),
          ),
          Tab(
            child: Align(
              alignment: Alignment.center,
              child: Text("月调度",
                  style: TextStyle(fontSize: SizeConfig.isIpad()! ? 25 : 12)),
            ),
          ),
        ]
      ],
    ),
  );
}
