import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/model/exam/exam_result_bo.dart';
import 'package:special_equipment_flutter/widgets/app_bar/custom_app_bar_back.dart';
import 'package:special_equipment_flutter/widgets/custom_button.dart';

///测试结果页面
class TestResultPage extends StatefulWidget {
  var arguments = Get.arguments;

  TestResultPage({super.key});

  @override
  State<TestResultPage> createState() => _TestResultPageState();
}

class _TestResultPageState extends State<TestResultPage> {
  ExamResultData? testResultDataBo;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    testResultDataBo = widget.arguments['testResultDataBo'];
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.grey[100],
      appBar: AppBarCustom(
        text: '测试练习结果',
        height: 50,
        leading: IconButton(
          iconSize: 20,
          icon: const Icon(Icons.arrow_back_ios),
          color: ColorConst.whiteColor,
          onPressed: () {
            Get.back();
          },

          ///这里设置了按钮的内边距为零，可以消除默认的16像素间距
          padding: EdgeInsets.zero,
        ),
      ),
      body: Container(
        height: 300,
        width: double.infinity,
        margin: const EdgeInsets.only(top: 15, left: 15, right: 15, bottom: 15),
        padding: const EdgeInsets.all(10),
        decoration: const BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.all(Radius.circular(5)),
        ),
        child: Column(
          children: [
            const SizedBox(height: 10),
            const Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Text(
                  '——————   ',
                  style: TextStyle(color: ColorConst.grayf5Color),
                ),
                Text('本次考核成绩'),
                Text(
                  '   ——————',
                  style: TextStyle(color: ColorConst.grayf5Color),
                )
              ],
            ),
            const SizedBox(height: 10),
            Text(
              testResultDataBo!.score!.toString(),
              style: TextStyle(
                  color:
                      testResultDataBo!.score! < 90 ? Colors.red : Colors.green,
                  fontSize: 20,
                  fontWeight: FontWeight.bold),
            ),
            const SizedBox(height: 20),
            Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                if (testResultDataBo!.adopt == '1') ...[
                  Image.asset(
                    'assets/examine/pass_icon.png',
                    width: 100,
                    height: 100,
                  ),
                ] else ...[
                  Image.asset(
                    'assets/examine/no_pass_icon.png',
                    width: 100,
                    height: 100,
                  ),
                ],
                Container(
                    height: 100,
                    width: 1,
                    color: ColorConst.grayf5Color,
                    margin: const EdgeInsets.only(left: 20, right: 40)),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text.rich(
                        softWrap: true,
                        TextSpan(children: [
                          const TextSpan(
                              text: "答对    ",
                              style:
                                  TextStyle(fontSize: 14, color: Colors.grey)),
                          TextSpan(
                              text: "${testResultDataBo!.correct.toString()}题",
                              style: const TextStyle(
                                  fontSize: 14, color: Colors.black87)),
                        ])),
                    const SizedBox(height: 20),
                    Text.rich(
                        softWrap: true,
                        TextSpan(children: [
                          const TextSpan(
                              text: "答错    ",
                              style:
                                  TextStyle(fontSize: 14, color: Colors.grey)),
                          TextSpan(
                              text: "${testResultDataBo!.error.toString()}题",
                              style: const TextStyle(
                                  fontSize: 14, color: Colors.black87)),
                        ])),
                    const SizedBox(height: 20),
                    Text.rich(
                        softWrap: true,
                        TextSpan(children: [
                          const TextSpan(
                              text: "总题    ",
                              style:
                                  TextStyle(fontSize: 14, color: Colors.grey)),
                          TextSpan(
                              text:
                                  "${testResultDataBo!.questionNum.toString()}题",
                              style: const TextStyle(
                                  fontSize: 14, color: Colors.black87)),
                        ])),
                  ],
                )
              ],
            ),
            const SizedBox(height: 40),
            GradientButton(
                tapCallback: () {
                  Get.back();
                },
                width: 300,
                height: 40,
                borderRadius: const BorderRadius.only(
                    topLeft: Radius.circular(10),
                    topRight: Radius.circular(20),
                    bottomLeft: Radius.circular(20),
                    bottomRight: Radius.circular(10)),
                disable: false,
                colors: const [ColorConst.blueColor, ColorConst.blue1Color],
                child: const Text(
                  "关闭",
                  style: TextStyle(fontSize: 14, color: ColorConst.whiteColor),
                ))
          ],
        ),
      ),
    );
  }
}
