import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/common/route_string.dart';
import 'package:special_equipment_flutter/dio/http_utils.dart';
import 'package:special_equipment_flutter/model/exam/exam_result_bo.dart';
import 'package:special_equipment_flutter/model/exam/examine_person_bo.dart';
import 'package:special_equipment_flutter/utils/eventbus_utils.dart';
import 'package:special_equipment_flutter/utils/toast_utils.dart';
import 'package:special_equipment_flutter/widgets/app_bar/custom_app_bar_back.dart';
import 'package:special_equipment_flutter/widgets/custom_button.dart';

///考核结果页面
class ExamResultPage extends StatefulWidget {
  var arguments = Get.arguments;

  // Data2? examResultDataBo;

  ExamResultPage({super.key});

  // ExamResultPage({super.key, this.examResultDataBo});

  @override
  State<ExamResultPage> createState() => _ExamResultPageState();
}

class _ExamResultPageState extends State<ExamResultPage> {
  ExamResultData? examResultDataBo;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    // examResultDataBo = widget.examResultDataBo;
    examResultDataBo = widget.arguments['examResultDataBo'];
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.grey[100],
      appBar: AppBarCustom(
        text: '考核结果',
        height: 50,
        leading: IconButton(
          iconSize: 20,
          icon: const Icon(Icons.arrow_back_ios),
          color: ColorConst.whiteColor,
          onPressed: () {
            Get.back();
          },

          ///这里设置了按钮的内边距为零，可以消除默认的16像素间距
          padding: EdgeInsets.zero,
        ),
      ),
      body: Column(
        children: [
          Container(
            width: double.infinity,
            margin:
                const EdgeInsets.only(left: 15, right: 15, top: 20, bottom: 0),
            padding:
                const EdgeInsets.only(left: 5, right: 5, top: 3, bottom: 3),
            decoration: BoxDecoration(
                color: Colors.orange[50],
                borderRadius: const BorderRadius.only(
                    topLeft: Radius.circular(5),
                    topRight: Radius.circular(5),
                    bottomLeft: Radius.circular(5),
                    bottomRight: Radius.circular(5))),
            child: const Text.rich(
                softWrap: true,
                TextSpan(children: [
                  TextSpan(
                      text: "小提示：考核成绩 ",
                      style: TextStyle(fontSize: 14, color: Colors.orange)),
                  TextSpan(
                      text: '90',
                      style: TextStyle(
                          fontSize: 20,
                          color: Colors.green,
                          fontWeight: FontWeight.bold)),
                  TextSpan(
                      text: " 为合格",
                      style: TextStyle(fontSize: 14, color: Colors.orange))
                ])),
          ),
          Container(
            height: 350,
            width: double.infinity,
            margin:
                const EdgeInsets.only(top: 5, left: 15, right: 15, bottom: 15),
            padding: const EdgeInsets.all(10),
            decoration: const BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.all(Radius.circular(5)),
            ),
            child: Column(
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Container(
                      height: 40,
                    ),
                    const Text(
                      '——————   ',
                      style: TextStyle(color: ColorConst.grayf5Color),
                    ),
                    const Text(
                      '本次考核成绩',
                      style: TextStyle(fontSize: 16),
                    ),
                    const Text(
                      '   ——————',
                      style: TextStyle(color: ColorConst.grayf5Color),
                    )
                  ],
                ),
                // const SizedBox(height: 10),
                Text(
                  examResultDataBo!.score!.round().toString(),
                  style: TextStyle(
                      color: examResultDataBo!.score! >= 90
                          ? Colors.green
                          : Colors.red,
                      fontSize: 50,
                      fontWeight: FontWeight.bold),
                ),
                const SizedBox(height: 20),
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    if (examResultDataBo!.adopt == '1') ...[
                      Image.asset(
                        'assets/examine/pass_icon.png',
                        width: 100,
                        height: 100,
                      ),
                    ] else ...[
                      Image.asset(
                        'assets/examine/no_pass_icon.png',
                        width: 100,
                        height: 100,
                      ),
                    ],
                    Container(
                        height: 100,
                        width: 1,
                        color: ColorConst.grayf5Color,
                        margin: const EdgeInsets.only(left: 20, right: 40)),
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text.rich(
                            softWrap: true,
                            TextSpan(children: [
                              const TextSpan(
                                  text: "答对    ",
                                  style: TextStyle(
                                      fontSize: 14, color: Colors.grey)),
                              TextSpan(
                                  text:
                                      "${examResultDataBo!.correct.toString()}题",
                                  style: const TextStyle(
                                      fontSize: 14, color: Colors.black87)),
                            ])),
                        const SizedBox(height: 20),
                        Text.rich(
                            softWrap: true,
                            TextSpan(children: [
                              const TextSpan(
                                  text: "答错    ",
                                  style: TextStyle(
                                      fontSize: 14, color: Colors.grey)),
                              TextSpan(
                                  text:
                                      "${examResultDataBo!.error.toString()}题",
                                  style: const TextStyle(
                                      fontSize: 14, color: Colors.black87)),
                            ])),
                        const SizedBox(height: 20),
                        Text.rich(
                            softWrap: true,
                            TextSpan(children: [
                              const TextSpan(
                                  text: "总题    ",
                                  style: TextStyle(
                                      fontSize: 14, color: Colors.grey)),
                              TextSpan(
                                  text:
                                      "${examResultDataBo!.questionNum.toString()}题",
                                  style: const TextStyle(
                                      fontSize: 14, color: Colors.black87)),
                            ])),
                      ],
                    )
                  ],
                ),
                const SizedBox(height: 40),
                GradientButton(
                    tapCallback: () {
                      if (examResultDataBo!.adopt == '1') {
                        //发出通知
                        EventBusUtils.getInstance()?.fire("1");
                        Get.back(result: true);
                      } else {
                        Get.back(result: true);
                        getClickQuestionsPerson();
                      }
                    },
                    width: 300,
                    height: 40,
                    borderRadius: const BorderRadius.only(
                        topLeft: Radius.circular(10),
                        topRight: Radius.circular(20),
                        bottomLeft: Radius.circular(20),
                        bottomRight: Radius.circular(10)),
                    disable: false,
                    colors: const [ColorConst.blueColor, ColorConst.blue1Color],
                    child: Text(
                      examResultDataBo!.adopt == '1' ? "关闭" : '继续答题',
                      style: const TextStyle(
                          fontSize: 14, color: ColorConst.whiteColor),
                    ))
              ],
            ),
          ),
        ],
      ),
    );
  }

  ExaminePersonBo? mExaminePersonBo;

  ///获取考核试卷
  void getClickQuestionsPerson() {
    HttpUtils.getExaminePerson(context).then((value) {
      mExaminePersonBo = value;
      if (mounted) {
        setState(() {
          if (mExaminePersonBo!.success!) {
            Get.toNamed(RouteString.EXAM_PAGE,
                    arguments: {'mExaminePersonBo': mExaminePersonBo!.data})
                ?.then((value) {});
          } else {
            ToastUtils.showCenter('您目前暂无考核内容');
          }
        });
      }
    });
  }
}
