import 'package:flutter/material.dart';
import 'package:flutter_easyrefresh/easy_refresh.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/common/edgeInsets_const.dart';
import 'package:special_equipment_flutter/dio/http_utils.dart';
import 'package:special_equipment_flutter/model/day_control_list_sy_bo.dart';
import 'package:special_equipment_flutter/widgets/app_bar/custom_app_bar.dart';
import 'package:special_equipment_flutter/widgets/divider_custom.dart';

///考核历史页面
class ExamHistoryPage extends StatefulWidget {
  const ExamHistoryPage({super.key});

  @override
  State<ExamHistoryPage> createState() => _ExamHistoryPageState();
}

class _ExamHistoryPageState extends State<ExamHistoryPage> {
  final EasyRefreshController _controller = EasyRefreshController();
  List<TaskDayList> list = [];

  @override
  void initState() {
    super.initState();
    // getData();
  }

  void getData() {
    HttpUtils.getOverseerList(context, '0', '', '').then((value) {
      DayControlListSyBo listBo = value;
      if (mounted) {
        setState(() {
          var taskDayList = listBo.taskDayList;
          list.clear();
          list.addAll(taskDayList!);

          _controller.finishRefresh();
        });
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBarCustom(text: '考核记录', height: 50),
      backgroundColor: Colors.grey[100],
      body: Column(
        children: [
          Expanded(
              flex: 1,
              child: EasyRefresh(
                firstRefresh: true,
                enableControlFinishRefresh: true,
                // enableControlFinishLoad: true,
                // firstRefreshWidget: const FirstRefreshWidget(),

                // emptyWidget: list.isEmpty
                //     ? EmptyImgWidget(
                //         title: '暂无数据,点击刷新',
                //         onTap: () {
                //           getData();
                //         })
                //     : null,
                controller: _controller,
                onRefresh: () async {
                  // page = 1;
                  // getData();
                },
//                onLoad: () async {
//                  page++;
//                  getList();
//                },
                child: buildBody(),
              )),
        ],
      ),
    );
  }

  Column buildBody() {
    return Column(
      children: [
        //文章列表
        ListView.separated(
          shrinkWrap: true,
          padding: const EdgeInsets.symmetric(
              horizontal: EdgeInsetsConst.padding_horizontal),
          physics: const NeverScrollableScrollPhysics(),
          itemBuilder: (BuildContext context, int index) {
            return buildItem(index, context);
          },
          itemCount: 4,
          separatorBuilder: (BuildContext context, int index) {
            return const SizedBox(
              height: 0,
            );
          },
        ),
      ],
    );
  }

  InkWell buildItem(int index, BuildContext context) {
    return InkWell(
      onTap: () {
        // Get.toNamed(RouteString.DAY_INSPECT_SUBMIT_SY,
        //     arguments: {'argsData': widget.args, 'listBo': list(index)})
        //     ?.then((value) {
        //   if (value != null && value) {
        //     getData();
        //   }
        // });
      },
      child: buildCard(context, index),
    );
  }

  Card buildCard(BuildContext context, int index) {
    return Card(
      elevation: 3,
      margin: const EdgeInsets.only(left: 0, right: 0, top: 15, bottom: 0),
      color: Colors.white,
      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.all(Radius.circular(5)),
      ),
      child: Container(
        padding:
            const EdgeInsets.only(left: 10, right: 10, top: 10, bottom: 10),
        child: Column(
          children: <Widget>[
            const Column(
              children: [
                Text('山西盈中科技有限公司山西盈中科技有限公司',
                    style: TextStyle(
                        fontWeight: FontWeight.bold,
                        fontSize: 18,
                        color: Colors.black87)),
                Text('2024-05-21',
                    style: TextStyle(fontSize: 14, color: Colors.grey)),
              ],
            ),

            ///分割线
            DividerCustom(Colors.grey[300], 8, 8, 0, 0),

            Container(
              margin:
                  const EdgeInsets.only(left: 8, top: 0, right: 0, bottom: 0),
              child: const Row(children: [
                Text('设备类型：',
                    style: TextStyle(
                        fontSize: 14,
                        color: ColorConst.blueColor,
                        fontWeight: FontWeight.bold)),
                Text('电梯，锅炉', style: TextStyle()),
              ]),
            ),
          ],
        ),
      ),
    );
  }
}
