import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/model/exam/examine_questions_bo.dart';
import 'package:special_equipment_flutter/ui/examine/exam/custom/choice_item.dart';

///单选(单选题、判断题)
class SingleOption extends StatefulWidget {
  final ExamQuestionList question;
  final PageController pageController;
  final int index;

  const SingleOption(
      {Key? key,
      required this.question,
      required this.pageController,
      required this.index})
      : super(key: key);

  @override
  _SingleOptionState createState() => _SingleOptionState();
}

class _SingleOptionState extends State<SingleOption> {
  @override
  Widget build(BuildContext context) {
    var question = widget.question;
    return ListView.builder(
      scrollDirection: Axis.vertical,
      shrinkWrap: true,
      itemCount: widget.question.examQuestionOptionList?.length,
      itemBuilder: (BuildContext context, int index) {
        var options = question.examQuestionOptionList![index];
        return InkWell(
          splashColor: ColorConst.themeBgColor,
          onTap: () {
            setState(() {
              //将其他选项全部置为false
              question.examQuestionOptionList!
                  .forEach((element) => element.isSelected = false);
              //将当前选项置为true
              options.isSelected = true;
              question.result = options.options;
              //延时1秒
              Future.delayed(const Duration(milliseconds: 500), () {
                widget.pageController.jumpToPage(widget.index + 1);
              });
            });
          },
          child: ChoiceItem(option: options),
        );
      },
    );
  }
}
