import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/model/exam/examine_questions_bo.dart';

///单选、多选item布局
class ChoiceItem extends StatefulWidget {
  final ExamQuestionOptionList option;

  const ChoiceItem({Key? key, required this.option}) : super(key: key);

  @override
  _ChoiceItemState createState() => _ChoiceItemState();
}

class _ChoiceItemState extends State<ChoiceItem> {
  @override
  Widget build(BuildContext context) {
    var options = widget.option;
    return Container(
      margin: const EdgeInsets.fromLTRB(15, 10, 15, 10),
      child: Row(
        mainAxisSize: MainAxisSize.max,
        children: <Widget>[
          Container(
            height: 30,
            width: 30,
            margin: const EdgeInsets.fromLTRB(0, 0, 15, 0),
            decoration: BoxDecoration(
              ///设置当前选中选项圆圈背景为蓝色、未选中选项圆圈背景为白色
              color:
                  options.isSelected! ? ColorConst.themeBgColor : Colors.white,

              ///设置圆圈为蓝色
              border: Border.all(
                  color: options.isSelected!
                      ? ColorConst.themeBgColor
                      : ColorConst.themeBgColor),
              borderRadius: const BorderRadius.all(Radius.circular(90)),
            ),
            child: Center(
              ///设置选项A、B、C、D
              child: Text(options.options!,
                  style: TextStyle(

                      ///设置当前选中选项字母为白色、未选中选项字母为蓝色
                      color: options.isSelected!
                          ? Colors.white
                          : ColorConst.themeBgColor,
                      //fontWeight: FontWeight.bold,
                      fontSize: 16.0)),
            ),
          ),
          Flexible(
            child: Text(
              options.isAcquiesceSelected!
                  ? '${options.content!}.'
                  : options.content!,
              style: const TextStyle(fontSize: 14),
            ),
          ),
        ],
      ),
    );
  }
}
