import 'package:flutter/material.dart';
import 'package:photo_view/photo_view.dart';
import 'package:photo_view/photo_view_gallery.dart';

class PhotoViewGalleryScreen extends StatelessWidget {
  final int index;
  final List<String> imageList;

  const PhotoViewGalleryScreen(
      {super.key, required this.index, required this.imageList});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      extendBodyBehindAppBar: true,
      backgroundColor: Colors.black,
      appBar: AppBar(
        backgroundColor: Colors.transparent,
        elevation: 0,
      ),
      body: InkWell(
        onTap: () {
          Navigator.pop(context);
        },
        child: PhotoViewGallery.builder(
          scrollPhysics: const BouncingScrollPhysics(),
          builder: (BuildContext context, int index) {
            return PhotoViewGalleryPageOptions(
              imageProvider: NetworkImage(imageList[index]),
              initialScale: PhotoViewComputedScale.contained,
            );
          },
          itemCount: imageList.length,
          loadingBuilder: (context, progress) => const Center(
            child: CircularProgressIndicator(),
          ),
          backgroundDecoration: const BoxDecoration(
            color: Colors.black,
          ),
          pageController: PageController(initialPage: index),
          onPageChanged: (int index) {},
        ),
      ),
    );
  }
}
