// ignore_for_file: constant_identifier_names, prefer_typing_uninitialized_variables

import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/model/completed_list_bo.dart';
import 'package:special_equipment_flutter/utils/storage_util.dart';

class StandingConfig {
  static const String SAFETY_OFFICER = "安全员";
  static const String SAFETY_DIRECTOR = "安全总监";
  static const String PERSON_CHARGE = "主要负责人";
  static const String INSPECTOR = "安全监察人员";
  static const String SY_DEVICE = '客运索道,电梯,起重机械,锅炉,压力管道,压力容器,大型游乐设施,场车,气瓶';
}

bool? isUnitRoles(rolesName) {
  if (rolesName == '公司账户') {
    return true;
  } else {
    return false;
  }
}

bool? isInspectorRoles(rolesName) {
  if (rolesName == StandingConfig.INSPECTOR) {
    return true;
  } else {
    return false;
  }
}

dynamic isRolesName(name) {
  switch (name) {
    case '公司账户':
      return false;
    case '管理员':
      return false;
    case '市场监管局':
      return false;
    case StandingConfig.INSPECTOR:
      return false;
    default:
      return true;
  }
}

dynamic isRolesName1(name) {
  switch (name) {
    case '管理员':
      return false;
    case '市场监管局':
      return false;
    default:
      return true;
  }
}

dynamic resultStatus(result) {
  if (result == '1') {
    return '符合';
  } else if (result == '2') {
    return '不符合';
  } else if (result == '4') {
    return '已整改';
  }
}

dynamic resultStatusDay(result) {
  if (result == '1') {
    return '无风险';
  } else if (result == '2') {
    return '有风险';
  } else if (result == '3') {
    return '无此项';
  } else if (result == '4') {
    return '已整改';
  }
}

dynamic resultColorDay(result) {
  if (result == '1') {
    return ColorConst.greenColor;
  } else if (result == '2') {
    return ColorConst.red1BgColor;
  } else if (result == '3') {
    return ColorConst.greenColor;
  } else if (result == '4') {
    return ColorConst.yellowColor;
  }
}

dynamic resultColor(result) {
  if (result == '1') {
    return ColorConst.greenColor;
  } else if (result == '2') {
    return ColorConst.red1BgColor;
  } else if (result == '4') {
    return ColorConst.yellowColor;
  }
}

Color typeColor(name) {
  switch (name) {
    case '锅炉':
      return Colors.purpleAccent;
    case '压力管道':
      return ColorConst.orangeColor;
    case '客运索道':
      return ColorConst.greenColor;
    case '气瓶':
      return ColorConst.purpleColor;
    case '大型游乐设施':
      return Colors.red;
    case '起重机械':
      return Colors.black;
    case '电梯':
      return ColorConst.blueColor;
    case '压力容器':
      return Colors.brown;
    case '场车':
      return Colors.deepOrange;

    case '客运索道安装':
      return ColorConst.greenColor;
    case '客运索道制造':
      return ColorConst.greenColor;
    case '电梯安装':
      return ColorConst.blueColor;
    case '电梯制造':
      return ColorConst.blueColor;
    case '起重机械安装':
      return Colors.black;
    case '起重机械制造':
      return Colors.black;
    case '锅炉制造':
      return Colors.purpleAccent;
    case '锅炉安装':
      return Colors.purpleAccent;
    case '压力管道元件制造':
      return ColorConst.orangeColor;
    case '压力管道安装':
      return ColorConst.orangeColor;
    case '压力管道设计':
      return ColorConst.orangeColor;
    case '压力容器制造':
      return Colors.brown;
    case '压力容器设计':
      return Colors.brown;
    case '大型游乐设施安装':
      return Colors.red;
    case '大型游乐设施制造':
      return Colors.red;
    case '场车制造':
      return Colors.deepOrange;
    case '场车维修':
      return Colors.deepOrange;
    case '气瓶制造':
      return ColorConst.purpleColor;
  }
  return ColorConst.blueColor;
}

String typeImage(name) {
  switch (name) {
    case '锅炉':
      return 'assets/home/boiler_white_icon.png';
    case '压力管道':
      return 'assets/home/conduit_white_icon.png';
    case '客运索道':
      return 'assets/home/bigfacility_icon.png';
    case '气瓶':
      return 'assets/home/gasbottle_icon.png';
    case '大型游乐设施':
      return 'assets/home/bigfacility_icon.png';
    case '起重机械':
      return 'assets/home/lifting_machinery_icon.png';
    case '电梯':
      return 'assets/home/elevator_white_icon.png';
    case '压力容器':
      return 'assets/home/container_white_icon.png';
    case '场车':
      return 'assets/home/sitevehicle_icon.png';

    case '客运索道安装':
      return 'assets/home/bigfacility_icon.png';
    case '客运索道制造':
      return 'assets/home/bigfacility_icon.png';
    case '电梯安装':
      return 'assets/home/elevator_white_icon.png';
    case '电梯制造':
      return 'assets/home/elevator_white_icon.png';
    case '起重机械安装':
      return 'assets/home/lifting_machinery_icon.png';
    case '起重机械制造':
      return 'assets/home/lifting_machinery_icon.png';
    case '锅炉制造':
      return 'assets/home/boiler_white_icon.png';
    case '锅炉安装':
      return 'assets/home/boiler_white_icon.png';
    case '压力管道元件制造':
      return 'assets/home/conduit_white_icon.png';
    case '压力管道安装':
      return 'assets/home/conduit_white_icon.png';
    case '压力管道设计':
      return 'assets/home/conduit_white_icon.png';
    case '压力容器制造':
      return 'assets/home/container_white_icon.png';
    case '压力容器设计':
      return 'assets/home/container_white_icon.png';
    case '大型游乐设施安装':
      return 'assets/home/bigfacility_icon.png';
    case '大型游乐设施制造':
      return 'assets/home/bigfacility_icon.png';
    case '场车制造':
      return 'assets/home/sitevehicle_icon.png';
    case '场车维修':
      return 'assets/home/sitevehicle_icon.png';
    case '气瓶制造':
      return 'assets/home/gasbottle_icon.png';
  }
  return 'assets/home/elevator_white_icon.png';
}

///切换单位类型：使用单位、生产单位
class Unit {
  Unit({
    required this.id,
    required this.name,
  });

  late final String id;
  late final String name;

  Unit.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final _data = <String, dynamic>{};
    _data['id'] = id;
    _data['name'] = name;
    return _data;
  }
}

String setBeginTime(type, beginTime) {
  switch (type) {
    ///日
    case '1':
      DateTime dateTime = DateFormat("yyyy-MM-dd").parse(beginTime);
      String formattedDate = DateFormat('yyyy年MM月dd日').format(dateTime);
      return formattedDate;

    ///周
    case '2':
      DateTime dateTime = DateFormat("yyyy-MM-dd").parse(beginTime);
      String year = DateFormat('yyyy').format(dateTime);
      final dayOfYear = int.parse(DateFormat("D").format(dateTime));
      final week = ((dayOfYear - dateTime.weekday + 10) / 7).floor();
      return "$year年 第$week周";

    ///月
    case '3':
      DateTime dateTime = DateFormat("yyyy-MM-dd").parse(beginTime);
      String year = DateFormat('yyyy').format(dateTime);
      int month = dateTime.month;
      return "$year年 $month月";
  }
  return "";
}

///基本信息模型
class BasicInformationData {
  var equipmentIcon, equipmentTitle, equipmentContent;

  BasicInformationData(
      this.equipmentIcon, this.equipmentTitle, this.equipmentContent);
}

class DataConfig {
  ///使用单位：日管控、风险整改、已完成基本信息 TaskDayList?
  static List<BasicInformationData> syDayInformationData(status,
      [isVis = true, taskDayBo, var rows]) {
    List<BasicInformationData> informationDataList = [];
    switch (status) {
      case '1':
        if (isVis) {
          informationDataList.add(BasicInformationData(
              Icons.account_balance_wallet_rounded,
              '设备：',
              taskDayBo!.deviceType!.name));
          var unitStatus = StorageUtil.getInstance().getUnitStatus();
          if (unitStatus == '1') {
            informationDataList.add(BasicInformationData(
                Icons.pin, '内部编号：', taskDayBo!.device!.code));
          }
        }
        var unitStatus = StorageUtil.getInstance().getUnitStatus();
        if (unitStatus == '1') {
          informationDataList.add(BasicInformationData(
              Icons.share_location, '设备地点：', taskDayBo!.device!.address));
        } else {
          ///日管控
          informationDataList.add(BasicInformationData(
              Icons.policy, '检查时间：', getDayResult('3', taskDayBo)));
        }

        ///日管控
        informationDataList.add(BasicInformationData(
            Icons.policy, '设备运行状态：', getDayResult('1', taskDayBo)));
        informationDataList.add(BasicInformationData(
            Icons.people_alt, '检查人：', getDayResult('2', taskDayBo)));
        break;
      case '2':
        if (isVis) {
          informationDataList.add(BasicInformationData(
              Icons.account_balance_wallet_rounded,
              '设备：',
              taskDayBo!.deviceType!.name));
          var unitStatus = StorageUtil.getInstance().getUnitStatus();
          if (unitStatus == '1') {
            informationDataList.add(BasicInformationData(
                Icons.pin, '内部编号：', taskDayBo!.device!.code));
          }
        }
        var unitStatus = StorageUtil.getInstance().getUnitStatus();
        if (unitStatus == '1') {
          informationDataList.add(BasicInformationData(
              Icons.share_location, '设备地点：', taskDayBo!.device!.address));
        }
        informationDataList.add(BasicInformationData(
            Icons.access_time_filled, '检查时间：', taskDayBo!.checkTime ?? '---'));

        informationDataList.add(BasicInformationData(
            Icons.people_alt,
            '检查人：',
            taskDayBo!.checkUser != null
                ? taskDayBo!.checkUser!.name ?? '---'
                : '---'));
        break;
      case '3':
        if (isVis) {
          informationDataList.add(BasicInformationData(
              Icons.account_balance_wallet_rounded,
              '设备：',
              rows!.deviceType!.name));
          var unitStatus = StorageUtil.getInstance().getUnitStatus();
          if (unitStatus == '1') {
            informationDataList.add(
                BasicInformationData(Icons.pin, '内部编号：', rows!.device!.code));
          }
        }
        var unitStatus = StorageUtil.getInstance().getUnitStatus();
        if (unitStatus == '1') {
          informationDataList.add(BasicInformationData(
              Icons.share_location, '设备地点：', rows!.device!.address));
        }

        ///已完成
        informationDataList.add(BasicInformationData(
            Icons.policy, '检查结果：', getCompletedTaskState('1', rows)));
        informationDataList.add(BasicInformationData(
            Icons.access_time_filled, '检查时间：', rows!.checkTime ?? '---'));
        informationDataList.add(BasicInformationData(Icons.people_alt, '检查人：',
            rows!.checkUser != null ? rows!.checkUser!.name ?? '---' : '---'));
        break;
    }
    return informationDataList;
  }

  static String? getCompletedTaskState(type, Rows? rows) {
    if (rows!.taskState == '1') {
      return '正常';
    } else if (rows!.taskState == '2') {
      return '有风险';
    } else if (rows!.taskState == '3') {
      return '有风险→正常';
    } else if (rows!.taskState == '6') {
      return '未检查';
    }
  }

  static String? getMonthResult(type, var taskDayBo) {
    if (taskDayBo.deviceInfoCheck != null) {
      if (taskDayBo.deviceInfoCheck!.monthCheck != null) {
        if (taskDayBo.deviceInfoCheck!.monthCheck!.result == '0') {
          if (type == '1') {
            return '---';
          } else if (type == '2') {
            return '---';
          } else if (type == '3') {
            return '---';
          } else if (type == '4') {
            return '---';
          } else if (type == '5') {
            return '---';
          }
        } else if (taskDayBo.deviceInfoCheck!.monthCheck!.result == '1') {
          if (type == '1') {
            return '正常';
          } else if (type == '2') {
            var checkUser = taskDayBo.deviceInfoCheck!.monthCheck!.checkUser;
            if (checkUser != null) {
              return taskDayBo.deviceInfoCheck!.monthCheck!.checkUser!.name;
            } else {
              return '---';
            }
          } else if (type == '3') {
            return setBeginTime(
                '1', taskDayBo.deviceInfoCheck!.monthCheck!.checkTime);
          } else if (type == '4') {
            return setBeginTime(
                '2', taskDayBo.deviceInfoCheck!.monthCheck!.checkTime);
          } else if (type == '5') {
            return setBeginTime(
                '3', taskDayBo.deviceInfoCheck!.monthCheck!.checkTime);
          }
        } else if (taskDayBo.deviceInfoCheck!.monthCheck!.result == '2') {
          if (type == '1') {
            return '有风险';
          } else if (type == '2') {
            var checkUser = taskDayBo.deviceInfoCheck!.monthCheck!.checkUser;
            if (checkUser != null) {
              return taskDayBo.deviceInfoCheck!.monthCheck!.checkUser!.name;
            } else {
              return '---';
            }
          } else if (type == '3') {
            return setBeginTime(
                '1', taskDayBo.deviceInfoCheck!.monthCheck!.checkTime);
          } else if (type == '4') {
            return setBeginTime(
                '2', taskDayBo.deviceInfoCheck!.monthCheck!.checkTime);
          } else if (type == '5') {
            return setBeginTime(
                '3', taskDayBo.deviceInfoCheck!.monthCheck!.checkTime);
          }
        } else if (taskDayBo.deviceInfoCheck!.monthCheck!.result == '3') {
          if (type == '1') {
            return '有风险→正常';
          } else if (type == '2') {
            var checkUser = taskDayBo.deviceInfoCheck!.monthCheck!.checkUser;
            if (checkUser != null) {
              return taskDayBo.deviceInfoCheck!.monthCheck!.checkUser!.name;
            } else {
              return '---';
            }
          } else if (type == '3') {
            return setBeginTime(
                '1', taskDayBo.deviceInfoCheck!.monthCheck!.checkTime);
          } else if (type == '4') {
            return setBeginTime(
                '2', taskDayBo.deviceInfoCheck!.monthCheck!.checkTime);
          } else if (type == '5') {
            return setBeginTime(
                '3', taskDayBo.deviceInfoCheck!.monthCheck!.checkTime);
          }
        } else if (taskDayBo.deviceInfoCheck!.monthCheck!.result == '6') {
          if (type == '1') {
            return '未检查';
          } else if (type == '2') {
            var checkUser = taskDayBo.deviceInfoCheck!.monthCheck!.checkUser;
            if (checkUser != null) {
              return taskDayBo.deviceInfoCheck!.monthCheck!.checkUser!.name;
            } else {
              return '---';
            }
          } else if (type == '3') {
            return setBeginTime(
                '1', taskDayBo.deviceInfoCheck!.monthCheck!.checkTime);
          } else if (type == '4') {
            return setBeginTime(
                '2', taskDayBo.deviceInfoCheck!.monthCheck!.checkTime);
          } else if (type == '5') {
            return setBeginTime(
                '3', taskDayBo.deviceInfoCheck!.monthCheck!.checkTime);
          }
        }
      } else {
        if (type == '1') {
          return '---';
        } else if (type == '2') {
          return '---';
        } else if (type == '3') {
          return '---';
        } else if (type == '4') {
          return '---';
        } else if (type == '5') {
          return '---';
        }
      }
    } else {
      if (type == '1') {
        return '---';
      } else if (type == '2') {
        return '---';
      } else if (type == '3') {
        return '---';
      } else if (type == '4') {
        return '---';
      } else if (type == '5') {
        return '---';
      }
    }
    return '';
  }

  static String? getWeekResult(type, var taskDayBo) {
    if (taskDayBo.deviceInfoCheck != null) {
      if (taskDayBo.deviceInfoCheck!.weekCheck != null) {
        if (taskDayBo.deviceInfoCheck!.weekCheck!.result == '0') {
          if (type == '1') {
            return '---';
          } else if (type == '2') {
            return '---';
          } else if (type == '3') {
            return '---';
          } else if (type == '4') {
            return '---';
          } else if (type == '5') {
            return '---';
          }
        } else if (taskDayBo.deviceInfoCheck!.weekCheck!.result == '1') {
          if (type == '1') {
            return '正常';
          } else if (type == '2') {
            var checkUser = taskDayBo.deviceInfoCheck!.weekCheck!.checkUser;
            if (checkUser != null) {
              return taskDayBo.deviceInfoCheck!.weekCheck!.checkUser!.name;
            } else {
              return '---';
            }
          } else if (type == '3') {
            return setBeginTime(
                '1', taskDayBo.deviceInfoCheck!.weekCheck!.checkTime);
          } else if (type == '4') {
            return setBeginTime(
                '2', taskDayBo.deviceInfoCheck!.weekCheck!.checkTime);
          } else if (type == '5') {
            return setBeginTime(
                '3', taskDayBo.deviceInfoCheck!.weekCheck!.checkTime);
          }
        } else if (taskDayBo.deviceInfoCheck!.weekCheck!.result == '2') {
          if (type == '1') {
            return '有风险';
          } else if (type == '2') {
            var checkUser = taskDayBo.deviceInfoCheck!.weekCheck!.checkUser;
            if (checkUser != null) {
              return taskDayBo.deviceInfoCheck!.weekCheck!.checkUser!.name;
            } else {
              return '---';
            }
          } else if (type == '3') {
            return setBeginTime(
                '1', taskDayBo.deviceInfoCheck!.weekCheck!.checkTime);
          } else if (type == '4') {
            return setBeginTime(
                '2', taskDayBo.deviceInfoCheck!.weekCheck!.checkTime);
          } else if (type == '5') {
            return setBeginTime(
                '3', taskDayBo.deviceInfoCheck!.weekCheck!.checkTime);
          }
        } else if (taskDayBo.deviceInfoCheck!.weekCheck!.result == '3') {
          if (type == '1') {
            return '有风险→正常';
          } else if (type == '2') {
            var checkUser = taskDayBo.deviceInfoCheck!.weekCheck!.checkUser;
            if (checkUser != null) {
              return taskDayBo.deviceInfoCheck!.weekCheck!.checkUser!.name;
            } else {
              return '---';
            }
          } else if (type == '3') {
            return setBeginTime(
                '1', taskDayBo.deviceInfoCheck!.weekCheck!.checkTime);
          } else if (type == '4') {
            return setBeginTime(
                '2', taskDayBo.deviceInfoCheck!.weekCheck!.checkTime);
          } else if (type == '5') {
            return setBeginTime(
                '3', taskDayBo.deviceInfoCheck!.weekCheck!.checkTime);
          }
        }
      } else {
        if (type == '1') {
          return '---';
        } else if (type == '2') {
          return '---';
        } else if (type == '3') {
          return '---';
        } else if (type == '4') {
          return '---';
        } else if (type == '5') {
          return '---';
        }
      }
    } else {
      if (type == '1') {
        return '---';
      } else if (type == '2') {
        return '---';
      } else if (type == '3') {
        return '---';
      } else if (type == '4') {
        return '---';
      } else if (type == '5') {
        return '---';
      }
    }
  }

  static String? getDayResult(type, taskDayBo) {
    if (taskDayBo.deviceInfoCheck != null) {
      if (taskDayBo.deviceInfoCheck!.dayCheck != null) {
        if (taskDayBo.deviceInfoCheck!.dayCheck!.result == '0') {
          if (type == '1') {
            return '---';
          } else if (type == '2') {
            return '---';
          } else if (type == '3') {
            return '---';
          } else if (type == '4') {
            return '---';
          } else if (type == '5') {
            return '---';
          }
        } else if (taskDayBo.deviceInfoCheck!.dayCheck!.result == '1') {
          if (type == '1') {
            return '正常';
          } else if (type == '2') {
            var checkUser = taskDayBo.deviceInfoCheck!.dayCheck!.checkUser;
            if (checkUser != null) {
              return taskDayBo.deviceInfoCheck!.dayCheck!.checkUser!.name;
            } else {
              return '---';
            }
          } else if (type == '3') {
            return setBeginTime(
                '1', taskDayBo.deviceInfoCheck!.dayCheck!.checkTime);
          } else if (type == '4') {
            return setBeginTime(
                '2', taskDayBo.deviceInfoCheck!.dayCheck!.checkTime);
          } else if (type == '5') {
            return setBeginTime(
                '3', taskDayBo.deviceInfoCheck!.dayCheck!.checkTime);
          }
        } else if (taskDayBo.deviceInfoCheck!.dayCheck!.result == '2') {
          if (type == '1') {
            return '有风险';
          } else if (type == '2') {
            var checkUser = taskDayBo.deviceInfoCheck!.dayCheck!.checkUser;
            if (checkUser != null) {
              return taskDayBo.deviceInfoCheck!.dayCheck!.checkUser!.name;
            } else {
              return '---';
            }
          } else if (type == '3') {
            return setBeginTime(
                '1', taskDayBo.deviceInfoCheck!.dayCheck!.checkTime);
          } else if (type == '4') {
            return setBeginTime(
                '2', taskDayBo.deviceInfoCheck!.dayCheck!.checkTime);
          } else if (type == '5') {
            return setBeginTime(
                '3', taskDayBo.deviceInfoCheck!.dayCheck!.checkTime);
          }
        } else if (taskDayBo.deviceInfoCheck!.dayCheck!.result == '3') {
          if (type == '1') {
            return '有风险→正常';
          } else if (type == '2') {
            var checkUser = taskDayBo.deviceInfoCheck!.dayCheck!.checkUser;
            if (checkUser != null) {
              return taskDayBo.deviceInfoCheck!.dayCheck!.checkUser!.name;
            } else {
              return '---';
            }
          } else if (type == '3') {
            return setBeginTime(
                '1', taskDayBo.deviceInfoCheck!.dayCheck!.checkTime);
          } else if (type == '4') {
            return setBeginTime(
                '2', taskDayBo.deviceInfoCheck!.dayCheck!.checkTime);
          } else if (type == '5') {
            return setBeginTime(
                '3', taskDayBo.deviceInfoCheck!.dayCheck!.checkTime);
          }
        }
      } else {
        if (type == '1') {
          return '---';
        } else if (type == '2') {
          return '---';
        } else if (type == '3') {
          return '---';
        } else if (type == '4') {
          return '---';
        } else if (type == '5') {
          return '---';
        }
      }
    } else {
      if (type == '1') {
        return '---';
      } else if (type == '2') {
        return '---';
      } else if (type == '3') {
        return '---';
      } else if (type == '4') {
        return '---';
      } else if (type == '5') {
        return '---';
      }
    }
  }

  ///使用单位：周排查、风险整改、已完成基本信息TaskDayList?
  static List<BasicInformationData> syWeekInformationData(status,
      [isVis = true, taskDayBo, Rows? rows]) {
    List<BasicInformationData> informationDataList = [];

    switch (status) {
      case '1':
        if (isVis) {
          informationDataList.add(BasicInformationData(
              Icons.account_balance_wallet_rounded,
              '设备：',
              taskDayBo!.deviceType!.name));
        }

        ///周排查
        informationDataList.add(BasicInformationData(
            Icons.policy, '设备运行状态：', getWeekResult('1', taskDayBo)));
        informationDataList.add(BasicInformationData(Icons.access_time_filled,
            '上次排查时间：', getWeekResult('3', taskDayBo)));
        informationDataList.add(BasicInformationData(
            Icons.people_alt, '上次排查人：', getWeekResult('2', taskDayBo)));
        break;
      case '2':
        if (isVis) {
          informationDataList.add(BasicInformationData(
              Icons.account_balance_wallet_rounded,
              '设备：',
              taskDayBo!.deviceType!.name));
          informationDataList.add(BasicInformationData(Icons.calendar_month,
              '排查周期：', '${taskDayBo!.weekNum.toString()}周'));
        }
        informationDataList.add(BasicInformationData(
            Icons.access_time_filled, '排查时间：', taskDayBo!.checkTime ?? '---'));

        informationDataList.add(BasicInformationData(
            Icons.people_alt,
            '排查人：',
            taskDayBo!.checkUser != null
                ? taskDayBo!.checkUser!.name ?? '---'
                : '---'));
        break;
      case '3':
        if (isVis) {
          informationDataList.add(BasicInformationData(
              Icons.account_balance_wallet_rounded,
              '设备：',
              rows!.deviceType!.name));
          informationDataList.add(BasicInformationData(
              Icons.calendar_month, '排查周期：', '${rows!.weekNum.toString()}周'));
        }

        ///已完成
        informationDataList.add(BasicInformationData(
            Icons.policy, '排查结果：', getCompletedTaskState('1', rows)));
        informationDataList.add(BasicInformationData(
            Icons.access_time_filled, '排查时间：', rows!.checkTime ?? '---'));
        informationDataList.add(BasicInformationData(Icons.people_alt, '排查人：',
            rows!.checkUser != null ? rows!.checkUser!.name ?? '---' : '---'));
        break;
    }
    return informationDataList;
  }

  ///使用单位：月调度、风险整改、已完成基本信息 TaskDayList?
  static List<BasicInformationData> syMonthInformationData(status,
      [isVis = true, taskDayBo, Rows? rows]) {
    List<BasicInformationData> informationDataList = [];

    switch (status) {
      case '1':
        if (isVis) {
          informationDataList.add(BasicInformationData(
              Icons.account_balance_wallet_rounded,
              '设备：',
              taskDayBo!.deviceType!.name));
        }

        ///周排查
        informationDataList.add(BasicInformationData(
            Icons.policy, '设备运行状态：', getMonthResult('1', taskDayBo)));
        informationDataList.add(BasicInformationData(Icons.access_time_filled,
            '上次检查时间：', getMonthResult('3', taskDayBo)));
        informationDataList.add(BasicInformationData(
            Icons.people_alt, '上次检查人：', getMonthResult('2', taskDayBo)));
        break;
      case '2':
        if (isVis) {
          informationDataList.add(BasicInformationData(
              Icons.account_balance_wallet_rounded,
              '设备：',
              taskDayBo!.deviceType!.name));

          DateTime dateTime =
              DateFormat("yyyy-MM-dd").parse(taskDayBo!.checkTime!);
          int month = dateTime.month;
          informationDataList.add(
              BasicInformationData(Icons.calendar_month, '检查月份：', '$month月'));
        }

        informationDataList.add(BasicInformationData(
            Icons.access_time_filled, '检查时间：', taskDayBo!.checkTime ?? '---'));
        informationDataList.add(BasicInformationData(
            Icons.people_alt,
            '检查人：',
            taskDayBo!.checkUser != null
                ? taskDayBo!.checkUser!.name ?? '---'
                : '---'));
        break;
      case '3':
        if (isVis) {
          informationDataList.add(BasicInformationData(
              Icons.account_balance_wallet_rounded,
              '设备：',
              rows!.deviceType!.name));
          DateTime dateTime = DateFormat("yyyy-MM-dd").parse(rows!.checkTime!);
          int month = dateTime.month;
          informationDataList.add(
              BasicInformationData(Icons.calendar_month, '检查月份：', '$month月'));
        }

        ///已完成
        informationDataList.add(BasicInformationData(
            Icons.policy, '检查结果：', getCompletedTaskState('1', rows!)));
        informationDataList.add(BasicInformationData(
            Icons.access_time_filled, '检查时间：', rows!.checkTime ?? '---'));
        informationDataList.add(BasicInformationData(Icons.people_alt, '检查人：',
            rows!.checkUser != null ? rows!.checkUser!.name ?? '---' : '---'));
        break;
    }
    return informationDataList;
  }
}

class HomeMenuItem {
  var image;
  var name;
  var isContains;
  var count;
  var isIgnoring;

  HomeMenuItem(
      {this.image, this.name, this.isContains, this.count, this.isIgnoring});
}

getUnitList() {
  var officeType = StorageUtil.getInstance().getOfficeType();
  var split = officeType.split(",");
  switch (split.length) {
    case 1:
      var unitList = [];
      unitList.add(Unit(id: split[0], name: split[0] == '1' ? '使用单位' : '生产单位'));
      return unitList;
    case 2:
      var unitList = [];
      unitList.add(Unit(id: split[0], name: '使用单位'));
      unitList.add(Unit(id: split[1], name: '生产单位'));
      return unitList;
  }
}

Future<String?> getCurrentLocation() async {
  // try {
  //   Position position = await Geolocator.getCurrentPosition(
  //       desiredAccuracy: LocationAccuracy.high,
  //       timeLimit: const Duration(seconds: 3));
  //   final placemarks =
  //       await placemarkFromCoordinates(position.latitude, position.longitude);
  //   if (placemarks.first != null) {
  //     final place = placemarks.first;
  //     var location = place.locality! + place.subLocality! + place.name!;
  //     return location;
  //   } else {
  //     return '';
  //   }
  // } catch (e) {
  //   print(e);
  //   return '';
  // }
}

Widget TitleWidget({type, image1, image2, title, String? subText}) {
  return Container(
      margin: image1 != null
          ? const EdgeInsets.only(left: 0, right: 0)
          : const EdgeInsets.only(left: 5, right: 0),
      child: Row(
        children: [
          Icon(type == '3' ? image2 : image1,
              color: ColorConst.orangeColor,
              size: type == '3'
                  ? 15
                  : image1 == null
                      ? 0
                      : 15),
          Text.rich(TextSpan(children: [
            TextSpan(text: title, style: const TextStyle(fontSize: 14)),
            if (subText!.isNotEmpty) ...[
              TextSpan(
                  text: subText,
                  style: const TextStyle(fontSize: 14, color: Colors.red)),
            ]
          ])),
        ],
      ));
}
