// ignore_for_file: must_be_immutable

import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/ui/common/data.dart';

///基本信息
class BasicInformationPage extends StatelessWidget {
  List<BasicInformationData> informationDataList = [];

  BasicInformationPage({super.key, required this.informationDataList});

  @override
  Widget build(BuildContext context) {
    return MediaQuery.removePadding(
        context: context,
        removeBottom: true,
        removeTop: true,

        ///检查项
        child: ListView.builder(
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
          padding: const EdgeInsets.only(top: 0, left: 10, bottom: 0),
          itemCount: informationDataList.length,
          itemBuilder: (BuildContext context, int index) {
            ///检查项item内容
            return buildItem(index);
          },
        ));
  }

  Container buildItem(int index) {
    return Container(
      margin: const EdgeInsets.fromLTRB(10, 0, 0, 5),
      child: Row(
        children: [
          Icon(
            informationDataList[index].equipmentIcon,
            size: 14,
            color: Colors.black54,
          ),
          const SizedBox(
            width: 5,
          ),
          Expanded(
            child: Text.rich(
                softWrap: true,
                TextSpan(children: [
                  TextSpan(
                      text: informationDataList[index].equipmentTitle,
                      style:
                          const TextStyle(fontSize: 13, color: Colors.black87)),
                  if (informationDataList[index].equipmentContent ==
                      '有风险→正常') ...[
                    const TextSpan(
                      text: '有风险',
                      style: TextStyle(
                          fontSize: 13, color: ColorConst.red1BgColor),
                    ),
                    const TextSpan(
                      text: '→',
                      style: TextStyle(fontSize: 13, color: Colors.black),
                    ),
                    const TextSpan(
                      text: '正常',
                      style:
                          TextStyle(fontSize: 13, color: ColorConst.greenColor),
                    ),
                  ] else ...[
                    TextSpan(
                      text: informationDataList[index].equipmentContent,
                      style: TextStyle(
                          fontSize: 13,
                          color: buildEquipmentContent(
                              informationDataList[index].equipmentContent)),
                    )
                  ]
                ])),
          )
        ],
      ),
    );
  }

  Color? buildEquipmentContent(var name) {
    if (name == '正常') {
      return ColorConst.greenColor;
    } else if (name == '有风险') {
      return ColorConst.red1BgColor;
    } else if (name == '未检查') {
      return ColorConst.red1BgColor;
    }
    // informationDataList[index].equipmentContent
  }
}
