import 'package:special_equipment_flutter/model/time_config.dart';

import 'day_control_list_sy_bo.dart';

/// taskWeekList : [{"id":"6e9c3da4747941fdb387a7eee123b103","createDate":"2023-10-21 01:00:00","updateDate":"2023-10-21 01:00:00","beginTime":"2023-10-21 00:00:00","endTime":"2023-10-21 23:59:59","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240","unitType":"1","name":"锅炉","sort":"1"},"device":{"id":"a713d6706cb94c88949ea2eda4fd7c80","name":"测试锅炉1","code":"GL001","address":"测试地址1"},"userids":"a3c979671d544217981fd5189576571e,8affd75130794659956ce53b7de3a299,","office":{"id":"e51b38d54a614d3d81acc86f43b2f4ad","name":"安泰源特种设备检测集团有限公司","sort":30,"hasChildren":false,"parentId":"0"},"taskState":"0"},{"id":"9432fde513b846f19deca57053033815","createDate":"2023-10-21 01:00:00","updateDate":"2023-10-21 01:00:00","beginTime":"2023-10-21 00:00:00","endTime":"2023-10-21 23:59:59","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240","unitType":"1","name":"锅炉","sort":"1"},"device":{"id":"c573aa5959f349f68673036eddd34c62","name":"1号锅炉","code":"GL001","address":"厂房北侧"},"userids":"a3c979671d544217981fd5189576571e,8affd75130794659956ce53b7de3a299,","office":{"id":"e51b38d54a614d3d81acc86f43b2f4ad","name":"安泰源特种设备检测集团有限公司","sort":30,"hasChildren":false,"parentId":"0"},"taskState":"0"},{"id":"b212b0f3bb5b4e3088382cd70e4453a7","createDate":"2023-10-21 01:00:00","updateDate":"2023-10-21 01:00:00","beginTime":"2023-10-21 00:00:00","endTime":"2023-10-21 23:59:59","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240","unitType":"1","name":"锅炉","sort":"1"},"device":{"id":"6ed977b26d274df8b4c25c301464884a","name":"测试锅炉2","code":"GL002","address":"测试地址2"},"userids":"a3c979671d544217981fd5189576571e,8affd75130794659956ce53b7de3a299,","office":{"id":"e51b38d54a614d3d81acc86f43b2f4ad","name":"安泰源特种设备检测集团有限公司","sort":30,"hasChildren":false,"parentId":"0"},"taskState":"0"},{"id":"e786ec5f6df84bfda36394427cb1705d","createDate":"2023-10-21 01:00:00","updateDate":"2023-10-21 01:00:00","beginTime":"2023-10-21 00:00:00","endTime":"2023-10-21 23:59:59","deviceType":{"id":"99648d6e69c9463d823fac8b7888a240","unitType":"1","name":"锅炉","sort":"1"},"device":{"id":"941b6bcad848471ca00391b5cb82903d","name":"测试锅炉3","code":"GL003","address":"测试地址3"},"userids":"a3c979671d544217981fd5189576571e,8affd75130794659956ce53b7de3a299,","office":{"id":"e51b38d54a614d3d81acc86f43b2f4ad","name":"安泰源特种设备检测集团有限公司","sort":30,"hasChildren":false,"parentId":"0"},"taskState":"0"},{"id":"ea9c2ec756114b068f87bcbab358dd63","createDate":"2023-10-21 01:00:00","updateDate":"2023-10-21 01:00:00","beginTime":"2023-10-21 00:00:00","endTime":"2023-10-21 23:59:59","deviceType":{"id":"779d6023cd4148b49288eb3e3616a7e3","unitType":"1","name":"电梯","sort":"5"},"device":{"id":"0081c396754e4e75af778848ffedacea","name":"3号楼西1电梯","code":"DT001","address":"楼西1电梯"},"userids":"8affd75130794659956ce53b7de3a299,a3c979671d544217981fd5189576571e,","office":{"id":"e51b38d54a614d3d81acc86f43b2f4ad","name":"安泰源特种设备检测集团有限公司","sort":30,"hasChildren":false,"parentId":"0"},"taskState":"0"}]

class WeekControlListSyBo {
  WeekControlListSyBo({
    List<TaskWeekList>? taskWeekList,
  }) {
    _taskWeekList = taskWeekList;
  }

  WeekControlListSyBo.fromJson(dynamic json) {
    if (json['taskWeekList'] != null) {
      _taskWeekList = [];
      json['taskWeekList'].forEach((v) {
        _taskWeekList?.add(TaskWeekList.fromJson(v));
      });
    }
  }

  List<TaskWeekList>? _taskWeekList;

  WeekControlListSyBo copyWith({
    List<TaskWeekList>? taskWeekList,
  }) =>
      WeekControlListSyBo(
        taskWeekList: taskWeekList ?? _taskWeekList,
      );

  List<TaskWeekList>? get taskWeekList => _taskWeekList;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_taskWeekList != null) {
      map['taskWeekList'] = _taskWeekList?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

/// id : "6e9c3da4747941fdb387a7eee123b103"
/// createDate : "2023-10-21 01:00:00"
/// updateDate : "2023-10-21 01:00:00"
/// beginTime : "2023-10-21 00:00:00"
/// endTime : "2023-10-21 23:59:59"
/// deviceType : {"id":"99648d6e69c9463d823fac8b7888a240","unitType":"1","name":"锅炉","sort":"1"}
/// device : {"id":"a713d6706cb94c88949ea2eda4fd7c80","name":"测试锅炉1","code":"GL001","address":"测试地址1"}
/// userids : "a3c979671d544217981fd5189576571e,8affd75130794659956ce53b7de3a299,"
/// office : {"id":"e51b38d54a614d3d81acc86f43b2f4ad","name":"安泰源特种设备检测集团有限公司","sort":30,"hasChildren":false,"parentId":"0"}
/// taskState : "0"

class TaskWeekList {
  TaskWeekList({
    String? id,
    String? createDate,
    String? updateDate,
    String? beginTime,
    String? endTime,
    DeviceType? deviceType,
    Device? device,
    String? userids,
    Office? office,
    String? taskState,
    DeviceInfoCheck? deviceInfoCheck,
    CheckUsers? checkUser,
    String? allow,
    TimeConfig? timeConfig,
    String? checkTime,
    int? weekNum,
  }) {
    _id = id;
    _createDate = createDate;
    _updateDate = updateDate;
    _beginTime = beginTime;
    _endTime = endTime;
    _deviceType = deviceType;
    _device = device;
    _userids = userids;
    _office = office;
    _taskState = taskState;
    _deviceInfoCheck = deviceInfoCheck;
    _checkUser = checkUser;
    _timeConfig = timeConfig;
    _allow = allow;
    _checkTime = checkTime;
    _weekNum = weekNum;
  }

  TaskWeekList.fromJson(dynamic json) {
    _id = json['id'];
    _createDate = json['createDate'];
    _updateDate = json['updateDate'];
    _beginTime = json['beginTime'];
    _endTime = json['endTime'];
    _deviceType = json['deviceType'] != null
        ? DeviceType.fromJson(json['deviceType'])
        : null;
    _device = json['device'] != null ? Device.fromJson(json['device']) : null;
    _userids = json['userids'];
    _office = json['office'] != null ? Office.fromJson(json['office']) : null;
    _taskState = json['taskState'];
    _deviceInfoCheck = json['deviceInfoCheck'] != null
        ? DeviceInfoCheck.fromJson(json['deviceInfoCheck'])
        : null;
    _checkUser = json['checkUser'] != null
        ? CheckUsers.fromJson(json['checkUser'])
        : null;
    _timeConfig = json['timeConfig'] != null
        ? TimeConfig.fromJson(json['timeConfig'])
        : null;
    _allow = json['allow'];
    _checkTime = json['checkTime'];
    _weekNum = json['weekNum'];
  }

  String? _id;
  String? _createDate;
  String? _updateDate;
  String? _beginTime;
  String? _endTime;
  DeviceType? _deviceType;
  Device? _device;
  String? _userids;
  Office? _office;
  String? _taskState;
  DeviceInfoCheck? _deviceInfoCheck;
  CheckUsers? _checkUser;
  TimeConfig? _timeConfig;
  String? _allow;
  String? _checkTime;
  int? _weekNum;

  TaskWeekList copyWith({
    String? id,
    String? createDate,
    String? updateDate,
    String? beginTime,
    String? endTime,
    DeviceType? deviceType,
    Device? device,
    String? userids,
    Office? office,
    String? taskState,
    DeviceInfoCheck? deviceInfoCheck,
    CheckUsers? checkUser,
    TimeConfig? timeConfig,
    String? allow,
    String? checkTime,
    int? weekNum,
  }) =>
      TaskWeekList(
        id: id ?? _id,
        createDate: createDate ?? _createDate,
        updateDate: updateDate ?? _updateDate,
        beginTime: beginTime ?? _beginTime,
        endTime: endTime ?? _endTime,
        deviceType: deviceType ?? _deviceType,
        device: device ?? _device,
        userids: userids ?? _userids,
        office: office ?? _office,
        taskState: taskState ?? _taskState,
        deviceInfoCheck: deviceInfoCheck ?? _deviceInfoCheck,
        checkUser: checkUser ?? _checkUser,
        timeConfig: timeConfig ?? _timeConfig,
        allow: allow ?? _allow,
        checkTime: checkTime ?? _checkTime,
        weekNum: weekNum ?? _weekNum,
      );

  String? get id => _id;

  String? get createDate => _createDate;

  String? get updateDate => _updateDate;

  String? get beginTime => _beginTime;

  String? get endTime => _endTime;

  DeviceType? get deviceType => _deviceType;

  Device? get device => _device;

  String? get userids => _userids;

  Office? get office => _office;

  String? get taskState => _taskState;

  DeviceInfoCheck? get deviceInfoCheck => _deviceInfoCheck;

  CheckUsers? get checkUser => _checkUser;

  TimeConfig? get timeConfig => _timeConfig;

  String? get allow => _allow;

  String? get checkTime => _checkTime;

  int? get weekNum => _weekNum;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['createDate'] = _createDate;
    map['updateDate'] = _updateDate;
    map['beginTime'] = _beginTime;
    map['endTime'] = _endTime;
    if (_deviceType != null) {
      map['deviceType'] = _deviceType?.toJson();
    }
    if (_device != null) {
      map['device'] = _device?.toJson();
    }
    map['userids'] = _userids;
    if (_office != null) {
      map['office'] = _office?.toJson();
    }
    map['taskState'] = _taskState;
    if (_deviceInfoCheck != null) {
      map['deviceInfoCheck'] = _deviceInfoCheck?.toJson();
    }
    if (_checkUser != null) {
      map['checkUser'] = _checkUser?.toJson();
    }
    if (_timeConfig != null) {
      map['timeConfig'] = _timeConfig?.toJson();
    }
    map['allow'] = _allow;
    map['checkTime'] = _checkTime;
    map['weekNum'] = _weekNum;
    return map;
  }
}

/// id : "e51b38d54a614d3d81acc86f43b2f4ad"
/// name : "安泰源特种设备检测集团有限公司"
/// sort : 30
/// hasChildren : false
/// parentId : "0"

class Office {
  Office({
    String? id,
    String? name,
    num? sort,
    bool? hasChildren,
    String? parentId,
  }) {
    _id = id;
    _name = name;
    _sort = sort;
    _hasChildren = hasChildren;
    _parentId = parentId;
  }

  Office.fromJson(dynamic json) {
    _id = json['id'];
    _name = json['name'];
    _sort = json['sort'];
    _hasChildren = json['hasChildren'];
    _parentId = json['parentId'];
  }

  String? _id;
  String? _name;
  num? _sort;
  bool? _hasChildren;
  String? _parentId;

  Office copyWith({
    String? id,
    String? name,
    num? sort,
    bool? hasChildren,
    String? parentId,
  }) =>
      Office(
        id: id ?? _id,
        name: name ?? _name,
        sort: sort ?? _sort,
        hasChildren: hasChildren ?? _hasChildren,
        parentId: parentId ?? _parentId,
      );

  String? get id => _id;

  String? get name => _name;

  num? get sort => _sort;

  bool? get hasChildren => _hasChildren;

  String? get parentId => _parentId;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['name'] = _name;
    map['sort'] = _sort;
    map['hasChildren'] = _hasChildren;
    map['parentId'] = _parentId;
    return map;
  }
}

class DeviceInfoCheck {
  DeviceInfoCheck({
    WeekCheck? weekCheck,
  }) {
    _weekCheck = weekCheck;
  }

  DeviceInfoCheck.fromJson(dynamic json) {
    _weekCheck = json['weekCheck'] != null
        ? WeekCheck.fromJson(json['weekCheck'])
        : null;
  }

  WeekCheck? _weekCheck;

  DeviceInfoCheck copyWith({
    WeekCheck? weekCheck,
  }) =>
      DeviceInfoCheck(
        weekCheck: weekCheck ?? _weekCheck,
      );

  WeekCheck? get weekCheck => _weekCheck;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_weekCheck != null) {
      map['weekCheck'] = _weekCheck?.toJson();
    }
    return map;
  }
}

/// result : "3"
/// checkTime : "2023-10-23 00:00:00"
/// checkUser : {"id":"8affd75130794659956ce53b7de3a299","name":"安泰安全员02","loginFlag":"1","admin":false,"roleNames":""}
/// taskState : "3"

class WeekCheck {
  WeekCheck({
    String? result,
    String? checkTime,
    CheckUsers? checkUser,
    String? taskState,
  }) {
    _result = result;
    _checkTime = checkTime;
    _checkUser = checkUser;
    _taskState = taskState;
  }

  WeekCheck.fromJson(dynamic json) {
    _result = json['result'];
    _checkTime = json['checkTime'];
    _checkUser = json['checkUser'] != null
        ? CheckUsers.fromJson(json['checkUser'])
        : null;
    _taskState = json['taskState'];
  }

  String? _result;
  String? _checkTime;
  CheckUsers? _checkUser;
  String? _taskState;

  WeekCheck copyWith({
    String? result,
    String? checkTime,
    CheckUsers? checkUser,
    String? taskState,
  }) =>
      WeekCheck(
        result: result ?? _result,
        checkTime: checkTime ?? _checkTime,
        checkUser: checkUser ?? _checkUser,
        taskState: taskState ?? _taskState,
      );

  String? get result => _result;

  String? get checkTime => _checkTime;

  CheckUsers? get checkUser => _checkUser;

  String? get taskState => _taskState;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['result'] = _result;
    map['checkTime'] = _checkTime;
    if (_checkUser != null) {
      map['checkUser'] = _checkUser?.toJson();
    }
    map['taskState'] = _taskState;
    return map;
  }
}
