class VersionBo {
  VersionBo({
    this.apkVersion,
  });

  VersionBo.fromJson(dynamic json) {
    apkVersion = json['apkVersion'] != null
        ? ApkVersion.fromJson(json['apkVersion'])
        : null;
  }

  ApkVersion? apkVersion;

  VersionBo copyWith({
    ApkVersion? apkVersion,
  }) =>
      VersionBo(
        apkVersion: apkVersion ?? this.apkVersion,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (apkVersion != null) {
      map['apkVersion'] = apkVersion?.toJson();
    }
    return map;
  }
}

class ApkVersion {
  ApkVersion({
    this.id,
    this.remarks,
    this.createBy,
    this.createDate,
    this.updateBy,
    this.updateDate,
    this.verionCode,
    this.versionName,
    this.updateLog,
    this.apkUrl,
    this.apkSize,
  });

  ApkVersion.fromJson(dynamic json) {
    id = json['id'];
    remarks = json['remarks'];
    createBy =
        json['createBy'] != null ? CreateBy.fromJson(json['createBy']) : null;
    createDate = json['createDate'];
    updateBy =
        json['updateBy'] != null ? UpdateBy.fromJson(json['updateBy']) : null;
    updateDate = json['updateDate'];
    verionCode = json['verionCode'];
    versionName = json['versionName'];
    updateLog = json['updateLog'];
    apkUrl = json['apkUrl'];
    apkSize = json['apkSize'];
  }

  String? id;
  String? remarks;
  CreateBy? createBy;
  String? createDate;
  UpdateBy? updateBy;
  String? updateDate;
  String? verionCode;
  String? versionName;
  String? updateLog;
  String? apkUrl;
  String? apkSize;

  ApkVersion copyWith({
    String? id,
    String? remarks,
    CreateBy? createBy,
    String? createDate,
    UpdateBy? updateBy,
    String? updateDate,
    String? verionCode,
    String? versionName,
    String? updateLog,
    String? apkUrl,
    String? apkSize,
  }) =>
      ApkVersion(
        id: id ?? this.id,
        remarks: remarks ?? this.remarks,
        createBy: createBy ?? this.createBy,
        createDate: createDate ?? this.createDate,
        updateBy: updateBy ?? this.updateBy,
        updateDate: updateDate ?? this.updateDate,
        verionCode: verionCode ?? this.verionCode,
        versionName: versionName ?? this.versionName,
        updateLog: updateLog ?? this.updateLog,
        apkUrl: apkUrl ?? this.apkUrl,
        apkSize: apkSize ?? this.apkSize,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['remarks'] = remarks;
    if (createBy != null) {
      map['createBy'] = createBy?.toJson();
    }
    map['createDate'] = createDate;
    if (updateBy != null) {
      map['updateBy'] = updateBy?.toJson();
    }
    map['updateDate'] = updateDate;
    map['verionCode'] = verionCode;
    map['versionName'] = versionName;
    map['updateLog'] = updateLog;
    map['apkUrl'] = apkUrl;
    map['apkSize'] = apkSize;
    return map;
  }
}

class UpdateBy {
  UpdateBy({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  UpdateBy.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  UpdateBy copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      UpdateBy(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}

class CreateBy {
  CreateBy({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  CreateBy.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  CreateBy copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      CreateBy(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}
