class UserList {
  UserList({
    this.total,
    this.rows,
  });

  UserList.fromJson(dynamic json) {
    total = json['total'];
    if (json['rows'] != null) {
      rows = [];
      json['rows'].forEach((v) {
        rows?.add(RowUserLists.fromJson(v));
      });
    }
  }

  num? total;
  List<RowUserLists>? rows;

  UserList copyWith({
    num? total,
    List<RowUserLists>? rows,
  }) =>
      UserList(
        total: total ?? this.total,
        rows: rows ?? this.rows,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['total'] = total;
    if (rows != null) {
      map['rows'] = rows?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class RowUserLists {
  RowUserLists({
    this.id,
    this.office,
    this.loginName,
    this.name,
    this.mobile,
    this.loginFlag,
    this.roleDtoList,
    this.userRoleList,
    this.admin,
    this.roleNames,
  });

  RowUserLists.fromJson(dynamic json) {
    id = json['id'];
    office = json['office'] != null ? Office.fromJson(json['office']) : null;
    loginName = json['loginName'];
    name = json['name'];
    mobile = json['mobile'];
    loginFlag = json['loginFlag'];
    if (json['roleDtoList'] != null) {
      roleDtoList = [];
      json['roleDtoList'].forEach((v) {
        roleDtoList?.add(RoleDtoLists.fromJson(v));
      });
    }
    if (json['userRoleList'] != null) {
      userRoleList = [];
      json['userRoleList'].forEach((v) {
        userRoleList?.add(UserRoleLists.fromJson(v));
      });
    }
    admin = json['admin'];
    roleNames = json['roleNames'];
  }

  String? id;
  Office? office;
  String? loginName;
  String? name;
  String? mobile;
  String? loginFlag;
  List<RoleDtoLists>? roleDtoList = [];
  List<UserRoleLists>? userRoleList;
  bool? admin;
  String? roleNames;

  RowUserLists copyWith({
    String? id,
    Office? office,
    String? loginName,
    String? name,
    String? mobile,
    String? loginFlag,
    List<RoleDtoLists>? roleDtoList,
    List<UserRoleLists>? userRoleList,
    bool? admin,
    String? roleNames,
  }) =>
      RowUserLists(
        id: id ?? this.id,
        office: office ?? this.office,
        loginName: loginName ?? this.loginName,
        name: name ?? this.name,
        mobile: mobile ?? this.mobile,
        loginFlag: loginFlag ?? this.loginFlag,
        roleDtoList: roleDtoList ?? this.roleDtoList,
        userRoleList: userRoleList ?? this.userRoleList,
        admin: admin ?? this.admin,
        roleNames: roleNames ?? this.roleNames,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    if (office != null) {
      map['office'] = office?.toJson();
    }
    map['loginName'] = loginName;
    map['name'] = name;
    map['mobile'] = mobile;
    map['loginFlag'] = loginFlag;
    if (roleDtoList != null) {
      map['roleDtoList'] = roleDtoList?.map((v) => v.toJson()).toList();
    }
    if (userRoleList != null) {
      map['userRoleList'] = userRoleList?.map((v) => v.toJson()).toList();
    }
    map['admin'] = admin;
    map['roleNames'] = roleNames;
    return map;
  }
}

class UserRoleLists {
  UserRoleLists({
    this.id,
    this.remarks,
    this.name,
    this.enname,
    this.roleType,
    this.sysData,
    this.useable,
    this.dataRuleIds,
    this.menuIds,
  });

  UserRoleLists.fromJson(dynamic json) {
    id = json['id'];
    remarks = json['remarks'];
    name = json['name'];
    enname = json['enname'];
    roleType = json['roleType'];
    sysData = json['sysData'];
    useable = json['useable'];
    dataRuleIds = json['dataRuleIds'];
    menuIds = json['menuIds'];
  }

  String? id;
  String? remarks;
  String? name;
  String? enname;
  String? roleType;
  String? sysData;
  String? useable;
  String? dataRuleIds;
  String? menuIds;

  UserRoleLists copyWith({
    String? id,
    String? remarks,
    String? name,
    String? enname,
    String? roleType,
    String? sysData,
    String? useable,
    String? dataRuleIds,
    String? menuIds,
  }) =>
      UserRoleLists(
        id: id ?? this.id,
        remarks: remarks ?? this.remarks,
        name: name ?? this.name,
        enname: enname ?? this.enname,
        roleType: roleType ?? this.roleType,
        sysData: sysData ?? this.sysData,
        useable: useable ?? this.useable,
        dataRuleIds: dataRuleIds ?? this.dataRuleIds,
        menuIds: menuIds ?? this.menuIds,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['remarks'] = remarks;
    map['name'] = name;
    map['enname'] = enname;
    map['roleType'] = roleType;
    map['sysData'] = sysData;
    map['useable'] = useable;
    map['dataRuleIds'] = dataRuleIds;
    map['menuIds'] = menuIds;
    return map;
  }
}

class RoleDtoLists {
  RoleDtoLists({
    this.roleId,
    this.name,
    this.userDtoList,
    this.check,
  });

  RoleDtoLists.fromJson(dynamic json) {
    roleId = json['roleId'];
    name = json['name'];
    if (json['userDtoList'] != null) {
      userDtoList = [];
      json['userDtoList'].forEach((v) {
        userDtoList?.add(UserDtoLists.fromJson(v));
      });
    }
    check = json['check'];
  }

  String? roleId;
  String? name;
  List<UserDtoLists>? userDtoList = [];
  bool? check;

  RoleDtoLists copyWith({
    String? roleId,
    String? name,
    List<UserDtoLists>? userDtoList,
    bool? check,
  }) =>
      RoleDtoLists(
        roleId: roleId ?? this.roleId,
        name: name ?? this.name,
        userDtoList: userDtoList ?? this.userDtoList,
        check: check ?? this.check,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['roleId'] = roleId;
    map['name'] = name;
    if (userDtoList != null) {
      map['userDtoList'] = userDtoList?.map((v) => v.toJson()).toList();
    }
    map['check'] = check;
    return map;
  }
}

class UserDtoLists {
  UserDtoLists({
    this.deviceTypeId,
    this.unitType,
    this.name,
    this.sort,
    this.check,
  });

  UserDtoLists.fromJson(dynamic json) {
    deviceTypeId = json['deviceTypeId'];
    unitType = json['unitType'];
    name = json['name'];
    sort = json['sort'];
    check = json['check'];
  }

  String? deviceTypeId;
  String? unitType;
  String? name;
  String? sort;
  bool? check;

  UserDtoLists copyWith({
    String? deviceTypeId,
    String? unitType,
    String? name,
    String? sort,
    bool? check,
  }) =>
      UserDtoLists(
        deviceTypeId: deviceTypeId ?? this.deviceTypeId,
        unitType: unitType ?? this.unitType,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        check: check ?? this.check,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['deviceTypeId'] = deviceTypeId;
    map['unitType'] = unitType;
    map['name'] = name;
    map['sort'] = sort;
    map['check'] = check;
    return map;
  }
}

class Office {
  Office({
    this.id,
    this.parentIds,
    this.name,
    this.sort,
    this.hasChildren,
    this.type,
    this.parentId,
  });

  Office.fromJson(dynamic json) {
    id = json['id'];
    parentIds = json['parentIds'];
    name = json['name'];
    sort = json['sort'];
    hasChildren = json['hasChildren'];
    type = json['type'];
    parentId = json['parentId'];
  }

  String? id;
  String? parentIds;
  String? name;
  num? sort;
  bool? hasChildren;
  String? type;
  String? parentId;

  Office copyWith({
    String? id,
    String? parentIds,
    String? name,
    num? sort,
    bool? hasChildren,
    String? type,
    String? parentId,
  }) =>
      Office(
        id: id ?? this.id,
        parentIds: parentIds ?? this.parentIds,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        hasChildren: hasChildren ?? this.hasChildren,
        type: type ?? this.type,
        parentId: parentId ?? this.parentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['parentIds'] = parentIds;
    map['name'] = name;
    map['sort'] = sort;
    map['hasChildren'] = hasChildren;
    map['type'] = type;
    map['parentId'] = parentId;
    return map;
  }
}
