class UnitBo {
  UnitBo({
    this.id,
    this.code,
    this.name,
    this.address,
    this.type,
    this.area,
    this.officeDtoList,
  });

  UnitBo.fromJson(dynamic json) {
    id = json['id'];
    code = json['code'];
    name = json['name'];
    address = json['address'];
    type = json['type'];
    area = json['area'] != null ? UnitArea.fromJson(json['area']) : null;
    if (json['officeDtoList'] != null) {
      officeDtoList = [];
      json['officeDtoList'].forEach((v) {
        officeDtoList?.add(OfficeDtoUnitList.fromJson(v));
      });
    }
  }

  String? id;
  String? code;
  String? name;
  String? address;
  String? type;
  UnitArea? area;
  List<OfficeDtoUnitList>? officeDtoList;

  UnitBo copyWith({
    String? id,
    String? code,
    String? name,
    String? address,
    String? type,
    UnitArea? area,
    List<OfficeDtoUnitList>? officeDtoList,
  }) =>
      UnitBo(
        id: id ?? this.id,
        code: code ?? this.code,
        name: name ?? this.name,
        address: address ?? this.address,
        type: type ?? this.type,
        area: area ?? this.area,
        officeDtoList: officeDtoList ?? this.officeDtoList,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['code'] = code;
    map['name'] = name;
    map['address'] = address;
    map['type'] = type;
    if (area != null) {
      map['area'] = area?.toJson();
    }
    if (officeDtoList != null) {
      map['officeDtoList'] = officeDtoList?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class OfficeDtoUnitList {
  OfficeDtoUnitList({
    this.deviceTypeId,
    this.unitType,
    this.id,
  });

  OfficeDtoUnitList.fromJson(dynamic json) {
    deviceTypeId = json['deviceTypeId'];
    unitType = json['unitType'];
    id = json['id'];
  }

  String? deviceTypeId;
  String? unitType;
  String? id;

  OfficeDtoUnitList copyWith({
    String? deviceTypeId,
    String? unitType,
    String? id,
  }) =>
      OfficeDtoUnitList(
        deviceTypeId: deviceTypeId ?? this.deviceTypeId,
        unitType: unitType ?? this.unitType,
        id: id ?? this.id,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['deviceTypeId'] = deviceTypeId;
    map['unitType'] = unitType;
    map['id'] = id;
    return map;
  }
}

class UnitArea {
  UnitArea({
    this.id,
  });

  UnitArea.fromJson(dynamic json) {
    id = json['id'];
  }

  String? id;

  UnitArea copyWith({
    String? id,
  }) =>
      UnitArea(
        id: id ?? this.id,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    return map;
  }
}
