/// timeConfig : {"id":"06f39650f6714f2981db1e134bd2f8d5","remarks":"","weekBeginDay":4,"weekEndDay":7,"monthBeginDay":25,"monthEndDay":31}
class TimeConfig {
  TimeConfig({
    String? id,
    String? remarks,
    int? weekBeginDay,
    int? weekEndDay,
    int? monthBeginDay,
    int? monthEndDay,
  }) {
    _id = id;
    _remarks = remarks;
    _weekBeginDay = weekBeginDay;
    _weekEndDay = weekEndDay;
    _monthBeginDay = monthBeginDay;
    _monthEndDay = monthEndDay;
  }

  TimeConfig.fromJson(dynamic json) {
    _id = json['id'];
    _remarks = json['remarks'];
    _weekBeginDay = json['weekBeginDay'];
    _weekEndDay = json['weekEndDay'];
    _monthBeginDay = json['monthBeginDay'];
    _monthEndDay = json['monthEndDay'];
  }

  String? _id;
  String? _remarks;
  int? _weekBeginDay;
  int? _weekEndDay;
  int? _monthBeginDay;
  int? _monthEndDay;

  TimeConfig copyWith({
    String? id,
    String? remarks,
    int? weekBeginDay,
    int? weekEndDay,
    int? monthBeginDay,
    int? monthEndDay,
  }) =>
      TimeConfig(
        id: id ?? _id,
        remarks: remarks ?? _remarks,
        weekBeginDay: weekBeginDay ?? _weekBeginDay,
        weekEndDay: weekEndDay ?? _weekEndDay,
        monthBeginDay: monthBeginDay ?? _monthBeginDay,
        monthEndDay: monthEndDay ?? _monthEndDay,
      );

  String? get id => _id;

  String? get remarks => _remarks;

  int? get weekBeginDay => _weekBeginDay;

  int? get weekEndDay => _weekEndDay;

  int? get monthBeginDay => _monthBeginDay;

  int? get monthEndDay => _monthEndDay;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['remarks'] = _remarks;
    map['weekBeginDay'] = _weekBeginDay;
    map['weekEndDay'] = _weekEndDay;
    map['monthBeginDay'] = _monthBeginDay;
    map['monthEndDay'] = _monthEndDay;
    return map;
  }
}
