class TestQuestion {
  List<Question>? question;

  TestQuestion({question});

  TestQuestion.fromJson(Map<String, dynamic> json) {
    if (json['question'] != null) {
      question = <Question>[];
      json['question'].forEach((v) {
        question!.add(Question.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (question != null) {
      data['question'] = question!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Question {
  int? id;
  String? type;
  String? name;
  String? title;
  String? image;
  List<Option>? option;

  Question({id, type, name, title, image, option});

  Question.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    type = json['type'];
    name = json['name'];
    title = json['title'];
    image = json['image'];
    if (json['option'] != null) {
      option = <Option>[];
      json['option'].forEach((v) {
        option!.add(Option.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['type'] = type;
    data['name'] = name;
    data['title'] = title;
    data['image'] = image;
    if (option != null) {
      data['option'] = option!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Option {
  String? answer;
  bool? isSelected;
  String? id;

  Option({answer, isSelected, id});

  Option.fromJson(Map<String, dynamic> json) {
    answer = json['answer'];
    isSelected = json['isSelected'];
    id = json['id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['answer'] = answer;
    data['isSelected'] = isSelected;
    data['id'] = id;
    return data;
  }
}

Map<String, dynamic> testQuestionJson = {
  "question": [
    {
      "id": 1001,
      "type": "1",
      "name": "多选",
      "title": "休克早期的临床表现是",
      "image":
          "https://img.qingwk.com/images/resource/f14231625/2019/05/05/19531_1303148556_fd.jpg",
      "option": [
        {"answer": "精神紧张，烦躁不安，心率增快，尿量减少", "isSelected": false, "id": "A"},
        {"answer": "表情淡漠，感觉迟钝，脉搏减慢", "isSelected": false, "id": "B"},
        {"answer": "血压下降，出冷汗，无尿", "isSelected": false, "id": "C"},
        {"answer": "表情淡漠，皮肤出现瘀斑，血压下降", "isSelected": false, "id": "D"},
        {"answer": "出冷汗，软弱无力，血压下降，皮肤发绀", "isSelected": false, "id": "E"}
      ]
    },
    {
      "id": 1002,
      "type": "0",
      "name": "单选",
      "title": "护理评估腹泻患儿重度脱水的主要依据,错误的是：（）",
      "image":
          "https://pic12.photophoto.cn/20171010/chuangyihuiseduojiaojihetuxingsucai-28744986_1.jpg",
      "option": [
        {"answer": "四肢厥冷", "isSelected": false, "id": "A"},
        {"answer": "皮肤发花", "isSelected": false, "id": "B"},
        {"answer": "血压轻度升高", "isSelected": false, "id": "C"},
        {"answer": "少尿或无尿等休克症状", "isSelected": false, "id": "D"}
      ]
    },
    {
      "id": 1003,
      "type": "3",
      "name": "判断",
      "title":
          "糖尿病酮症酸中毒患者早期酮症阶段仅有多尿、多饮、疲乏等，继之出现食欲不振、恶心、呕吐、头痛、嗜睡、呼吸深大（Kussmaul呼吸)，呼气中出现烂苹果味;后期脱水明显，尿少、皮肤干燥、血压下降、休克、昏迷，以至死亡。（）",
      "image":
          "https://img.qingwk.com/images/resource/f16733122/2019/02/24/202988_67998812894_fd.jpg",
      "option": [
        {"answer": "是", "isSelected": false, "id": "A"},
        {"answer": "否", "isSelected": false, "id": "B"}
      ]
    },
    {
      "id": 1004,
      "type": "3",
      "name": "判断",
      "title": "贫血的临床表现主要是缺氧的病理生理改变所引起。（)",
      "image":
          "https://tp.tucengyun.com/wp-content/uploads/2021/03/20210304132545488.jpg",
      "option": [
        {"answer": "是", "isSelected": false, "id": "A"},
        {"answer": "否", "isSelected": false, "id": "B"}
      ]
    }
  ]
};
