class SyDeviceListBo {
  SyDeviceListBo({
    this.total,
    this.rows,
  });

  SyDeviceListBo.fromJson(dynamic json) {
    total = json['total'];
    if (json['rows'] != null) {
      rows = [];
      json['rows'].forEach((v) {
        rows?.add(RowLists.fromJson(v));
      });
    }
  }

  num? total;
  List<RowLists>? rows;

  SyDeviceListBo copyWith({
    num? total,
    List<RowLists>? rows,
  }) =>
      SyDeviceListBo(
        total: total ?? this.total,
        rows: rows ?? this.rows,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['total'] = total;
    if (rows != null) {
      map['rows'] = rows?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class RowLists {
  RowLists({
    this.id,
    this.remarks,
    this.createBy,
    this.createDate,
    this.updateBy,
    this.updateDate,
    this.name,
    this.code,
    this.address,
    this.deviceType,
    this.office,
    this.user,
    this.curType,
    this.dayBeginDate,
    this.weekBeginDate,
    this.monthBeginDate,
  });

  RowLists.fromJson(dynamic json) {
    id = json['id'];
    remarks = json['remarks'];
    createBy =
        json['createBy'] != null ? CreateBy.fromJson(json['createBy']) : null;
    createDate = json['createDate'];
    updateBy =
        json['updateBy'] != null ? UpdateBy.fromJson(json['updateBy']) : null;
    updateDate = json['updateDate'];
    name = json['name'];
    code = json['code'];
    address = json['address'];
    deviceType = json['deviceType'] != null
        ? DeviceType.fromJson(json['deviceType'])
        : null;
    office = json['office'] != null ? Office.fromJson(json['office']) : null;
    user = json['user'] != null ? User.fromJson(json['user']) : null;
    curType = json['curType'];
    dayBeginDate = json['dayBeginDate'];
    weekBeginDate = json['weekBeginDate'];
    monthBeginDate = json['monthBeginDate'];
  }

  String? id;
  String? remarks;
  CreateBy? createBy;
  String? createDate;
  UpdateBy? updateBy;
  String? updateDate;
  String? name;
  String? code;
  String? address;
  DeviceType? deviceType;
  Office? office;
  User? user;
  String? curType;
  String? dayBeginDate;
  String? weekBeginDate;
  String? monthBeginDate;
  bool? isChecked = false;

  RowLists copyWith({
    String? id,
    String? remarks,
    CreateBy? createBy,
    String? createDate,
    UpdateBy? updateBy,
    String? updateDate,
    String? name,
    String? code,
    String? address,
    DeviceType? deviceType,
    Office? office,
    User? user,
    String? curType,
    String? dayBeginDate,
    String? weekBeginDate,
    String? monthBeginDate,
  }) =>
      RowLists(
        id: id ?? this.id,
        remarks: remarks ?? this.remarks,
        createBy: createBy ?? this.createBy,
        createDate: createDate ?? this.createDate,
        updateBy: updateBy ?? this.updateBy,
        updateDate: updateDate ?? this.updateDate,
        name: name ?? this.name,
        code: code ?? this.code,
        address: address ?? this.address,
        deviceType: deviceType ?? this.deviceType,
        office: office ?? this.office,
        user: user ?? this.user,
        curType: curType ?? this.curType,
        dayBeginDate: dayBeginDate ?? this.dayBeginDate,
        weekBeginDate: weekBeginDate ?? this.weekBeginDate,
        monthBeginDate: monthBeginDate ?? this.monthBeginDate,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['remarks'] = remarks;
    if (createBy != null) {
      map['createBy'] = createBy?.toJson();
    }
    map['createDate'] = createDate;
    if (updateBy != null) {
      map['updateBy'] = updateBy?.toJson();
    }
    map['updateDate'] = updateDate;
    map['name'] = name;
    map['code'] = code;
    map['address'] = address;
    if (deviceType != null) {
      map['deviceType'] = deviceType?.toJson();
    }
    if (office != null) {
      map['office'] = office?.toJson();
    }
    if (user != null) {
      map['user'] = user?.toJson();
    }
    map['curType'] = curType;
    map['dayBeginDate'] = dayBeginDate;
    map['weekBeginDate'] = weekBeginDate;
    map['monthBeginDate'] = monthBeginDate;
    return map;
  }
}

class User {
  User({
    this.id,
    this.name,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  User.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? name;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  User copyWith({
    String? id,
    String? name,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      User(
        id: id ?? this.id,
        name: name ?? this.name,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}

class Office {
  Office({
    this.id,
    this.name,
    this.sort,
    this.hasChildren,
    this.parentId,
  });

  Office.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
    sort = json['sort'];
    hasChildren = json['hasChildren'];
    parentId = json['parentId'];
  }

  String? id;
  String? name;
  num? sort;
  bool? hasChildren;
  String? parentId;

  Office copyWith({
    String? id,
    String? name,
    num? sort,
    bool? hasChildren,
    String? parentId,
  }) =>
      Office(
        id: id ?? this.id,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        hasChildren: hasChildren ?? this.hasChildren,
        parentId: parentId ?? this.parentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['sort'] = sort;
    map['hasChildren'] = hasChildren;
    map['parentId'] = parentId;
    return map;
  }
}

class DeviceType {
  DeviceType({
    this.id,
    this.unitType,
    this.name,
  });

  DeviceType.fromJson(dynamic json) {
    id = json['id'];
    unitType = json['unitType'];
    name = json['name'];
  }

  String? id;
  String? unitType;
  String? name;

  DeviceType copyWith({
    String? id,
    String? unitType,
    String? name,
  }) =>
      DeviceType(
        id: id ?? this.id,
        unitType: unitType ?? this.unitType,
        name: name ?? this.name,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['unitType'] = unitType;
    map['name'] = name;
    return map;
  }
}

class UpdateBy {
  UpdateBy({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  UpdateBy.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  UpdateBy copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      UpdateBy(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}

class CreateBy {
  CreateBy({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  CreateBy.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  CreateBy copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      CreateBy(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}
