class RoleBo {
  RoleBo({
    this.list,
  });

  RoleBo.fromJson(dynamic json) {
    if (json['list'] != null) {
      list = [];
      json['list'].forEach((v) {
        list?.add(UserData.fromJson(v));
      });
    }
  }

  List<UserData>? list;

  RoleBo copyWith({
    List<UserData>? list,
  }) =>
      RoleBo(
        list: list ?? this.list,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (list != null) {
      map['list'] = list?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class UserData {
  UserData({
    this.userName,
    this.roleId,
    this.roleName,
    this.roleEnName,
    this.deviceTypeId,
    this.officeId,
  });

  UserData.fromJson(dynamic json) {
    userName = json['userName'];
    roleId = json['roleId'];
    roleName = json['roleName'];
    roleEnName = json['roleEnName'];
    deviceTypeId = json['deviceTypeId'];
    officeId = json['officeId'];
  }

  String? userName;
  String? roleId;
  String? roleName;
  String? roleEnName;
  String? deviceTypeId;
  String? officeId;

  UserData copyWith({
    String? userName,
    String? roleId,
    String? roleName,
    String? roleEnName,
    String? deviceTypeId,
    String? officeId,
  }) =>
      UserData(
        userName: userName ?? this.userName,
        roleId: roleId ?? this.roleId,
        roleName: roleName ?? this.roleName,
        roleEnName: roleEnName ?? this.roleEnName,
        deviceTypeId: deviceTypeId ?? this.deviceTypeId,
        officeId: officeId ?? this.officeId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['userName'] = userName;
    map['roleId'] = roleId;
    map['roleName'] = roleName;
    map['roleEnName'] = roleEnName;
    map['deviceTypeId'] = deviceTypeId;
    map['officeId'] = officeId;
    return map;
  }
}
