import 'package:special_equipment_flutter/model/role_bo.dart';

class OfficeDevice {
  OfficeDevice({
    this.office,
  });

  OfficeDevice.fromJson(dynamic json) {
    office = json['office'] != null ? Office.fromJson(json['office']) : null;
  }

  Office? office;

  OfficeDevice copyWith({
    Office? office,
  }) =>
      OfficeDevice(
        office: office ?? this.office,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (office != null) {
      map['office'] = office?.toJson();
    }
    return map;
  }
}

class Office {
  Office({
    this.id,
    this.createBy,
    this.createDate,
    this.updateBy,
    this.updateDate,
    this.parentIds,
    this.name,
    this.sort,
    this.hasChildren,
    this.area,
    this.code,
    this.type,
    this.grade,
    this.address,
    this.useable,
    this.officeDtoList,
    this.parentId,
  });

  Office.fromJson(dynamic json) {
    id = json['id'];
    createBy =
        json['createBy'] != null ? CreateBy.fromJson(json['createBy']) : null;
    createDate = json['createDate'];
    updateBy =
        json['updateBy'] != null ? UpdateBy.fromJson(json['updateBy']) : null;
    updateDate = json['updateDate'];
    parentIds = json['parentIds'];
    name = json['name'];
    sort = json['sort'];
    hasChildren = json['hasChildren'];
    area = json['area'] != null ? Area.fromJson(json['area']) : null;
    code = json['code'];
    type = json['type'];
    grade = json['grade'];
    address = json['address'];
    useable = json['useable'];
    if (json['officeDtoList'] != null) {
      officeDtoList = [];
      json['officeDtoList'].forEach((v) {
        officeDtoList?.add(OfficeDtoLists.fromJson(v));
      });
    }
    parentId = json['parentId'];
  }

  String? id;
  CreateBy? createBy;
  String? createDate;
  UpdateBy? updateBy;
  String? updateDate;
  String? parentIds;
  String? name;
  num? sort;
  bool? hasChildren;
  Area? area;
  String? code;
  String? type;
  String? grade;
  String? address;
  String? useable;
  List<OfficeDtoLists>? officeDtoList;
  String? parentId;

  Office copyWith({
    String? id,
    CreateBy? createBy,
    String? createDate,
    UpdateBy? updateBy,
    String? updateDate,
    String? parentIds,
    String? name,
    num? sort,
    bool? hasChildren,
    Area? area,
    String? code,
    String? type,
    String? grade,
    String? address,
    String? useable,
    List<OfficeDtoLists>? officeDtoList,
    String? parentId,
  }) =>
      Office(
        id: id ?? this.id,
        createBy: createBy ?? this.createBy,
        createDate: createDate ?? this.createDate,
        updateBy: updateBy ?? this.updateBy,
        updateDate: updateDate ?? this.updateDate,
        parentIds: parentIds ?? this.parentIds,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        hasChildren: hasChildren ?? this.hasChildren,
        area: area ?? this.area,
        code: code ?? this.code,
        type: type ?? this.type,
        grade: grade ?? this.grade,
        address: address ?? this.address,
        useable: useable ?? this.useable,
        officeDtoList: officeDtoList ?? this.officeDtoList,
        parentId: parentId ?? this.parentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    if (createBy != null) {
      map['createBy'] = createBy?.toJson();
    }
    map['createDate'] = createDate;
    if (updateBy != null) {
      map['updateBy'] = updateBy?.toJson();
    }
    map['updateDate'] = updateDate;
    map['parentIds'] = parentIds;
    map['name'] = name;
    map['sort'] = sort;
    map['hasChildren'] = hasChildren;
    if (area != null) {
      map['area'] = area?.toJson();
    }
    map['code'] = code;
    map['type'] = type;
    map['grade'] = grade;
    map['address'] = address;
    map['useable'] = useable;
    if (officeDtoList != null) {
      map['officeDtoList'] = officeDtoList?.map((v) => v.toJson()).toList();
    }
    map['parentId'] = parentId;
    return map;
  }
}

class OfficeDtoLists {
  OfficeDtoLists({
    this.id,
    this.officeId,
    this.deviceTypeId,
    this.unitType,
    this.name,
    this.sort,
    this.delFlag,
    this.curType,
  });

  OfficeDtoLists.fromJson(dynamic json) {
    id = json['id'];
    officeId = json['officeId'];
    deviceTypeId = json['deviceTypeId'];
    unitType = json['unitType'];
    name = json['name'];
    sort = json['sort'];
    delFlag = json['delFlag'];
    curType = json['curType'];
  }

  String? id;
  String? officeId;
  String? deviceTypeId;
  String? unitType;
  String? name;
  String? sort;
  String? delFlag;
  String? curType;
  String? deviceCount = '';
  bool? isChecked = false;
  String? safetyOfficer = '';
  String? safetyDirector = '';
  List<UserData>? list = [];

  OfficeDtoLists copyWith({
    String? id,
    String? officeId,
    String? deviceTypeId,
    String? unitType,
    String? name,
    String? sort,
    String? delFlag,
    String? curType,
  }) =>
      OfficeDtoLists(
        id: id ?? this.id,
        officeId: officeId ?? this.officeId,
        deviceTypeId: deviceTypeId ?? this.deviceTypeId,
        unitType: unitType ?? this.unitType,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        delFlag: delFlag ?? this.delFlag,
        curType: curType ?? this.curType,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['officeId'] = officeId;
    map['deviceTypeId'] = deviceTypeId;
    map['unitType'] = unitType;
    map['name'] = name;
    map['sort'] = sort;
    map['delFlag'] = delFlag;
    map['curType'] = curType;
    return map;
  }
}

class Area {
  Area({
    this.id,
    this.parentIds,
    this.name,
    this.sort,
    this.hasChildren,
    this.parentId,
  });

  Area.fromJson(dynamic json) {
    id = json['id'];
    parentIds = json['parentIds'];
    name = json['name'];
    sort = json['sort'];
    hasChildren = json['hasChildren'];
    parentId = json['parentId'];
  }

  String? id;
  String? parentIds;
  String? name;
  num? sort;
  bool? hasChildren;
  String? parentId;

  Area copyWith({
    String? id,
    String? parentIds,
    String? name,
    num? sort,
    bool? hasChildren,
    String? parentId,
  }) =>
      Area(
        id: id ?? this.id,
        parentIds: parentIds ?? this.parentIds,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        hasChildren: hasChildren ?? this.hasChildren,
        parentId: parentId ?? this.parentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['parentIds'] = parentIds;
    map['name'] = name;
    map['sort'] = sort;
    map['hasChildren'] = hasChildren;
    map['parentId'] = parentId;
    return map;
  }
}

class UpdateBy {
  UpdateBy({
    this.id,
    this.loginFlag,
    this.admin,
    this.roleNames,
  });

  UpdateBy.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    admin = json['admin'];
    roleNames = json['roleNames'];
  }

  String? id;
  String? loginFlag;
  bool? admin;
  String? roleNames;

  UpdateBy copyWith({
    String? id,
    String? loginFlag,
    bool? admin,
    String? roleNames,
  }) =>
      UpdateBy(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        admin: admin ?? this.admin,
        roleNames: roleNames ?? this.roleNames,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['admin'] = admin;
    map['roleNames'] = roleNames;
    return map;
  }
}

class CreateBy {
  CreateBy({
    this.id,
    this.loginFlag,
    this.admin,
    this.roleNames,
  });

  CreateBy.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    admin = json['admin'];
    roleNames = json['roleNames'];
  }

  String? id;
  String? loginFlag;
  bool? admin;
  String? roleNames;

  CreateBy copyWith({
    String? id,
    String? loginFlag,
    bool? admin,
    String? roleNames,
  }) =>
      CreateBy(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        admin: admin ?? this.admin,
        roleNames: roleNames ?? this.roleNames,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['admin'] = admin;
    map['roleNames'] = roleNames;
    return map;
  }
}
