import 'package:special_equipment_flutter/model/day_submit_bo.dart';

class MonthSubmitBo {
  MonthSubmitBo({
    required this.id,
    required this.result,
    required this.checkTime,
    required this.taskState,
    required this.prictures,
    required this.checkUser,
    required this.taskMonthCheckList,
  });

  late final String id;
  late final String result;
  late final String checkTime;
  late final String taskState;
  late final String prictures;
  late final CheckUser checkUser;
  late final List<TaskMonthCheckLists> taskMonthCheckList;

  MonthSubmitBo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    result = json['result'];
    checkTime = json['checkTime'];
    taskState = json['taskState'];
    prictures = json['prictures'];
    checkUser = CheckUser.fromJson(json['checkUser']);
    taskMonthCheckList = List.from(json['taskMonthCheckList'])
        .map((e) => TaskMonthCheckLists.fromJson(e))
        .toList();
  }

  Map<String, dynamic> toJson() {
    final _data = <String, dynamic>{};
    _data['id'] = id;
    _data['result'] = result;
    _data['checkTime'] = checkTime;
    _data['taskState'] = taskState;
    _data['prictures'] = prictures;
    _data['checkUser'] = checkUser.toJson();
    _data['taskMonthCheckList'] =
        taskMonthCheckList.map((e) => e.toJson()).toList();
    return _data;
  }
}

class TaskMonthCheckLists {
  TaskMonthCheckLists({
    required this.id,
    required this.name,
    required this.result,
    required this.sort,
    required this.riskContent,
    required this.taskMonth,
    required this.deviceRiskParent,
    required this.deviceRisk,
    required this.rectHave,
    required this.rectContent,
    required this.rectUserName,
    required this.rectTime,
  });

  late final String id;
  late final String name;
  late final String result;
  late final int sort;
  late final String riskContent;
  late final String rectHave;
  late final String rectContent;
  late final String rectUserName;
  late final String rectTime;
  late final TaskMonths taskMonth;
  late final DeviceRiskParents deviceRiskParent;
  late final DeviceRisks deviceRisk;

  TaskMonthCheckLists.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    result = json['result'];
    sort = json['sort'];
    riskContent = json['riskContent'];
    rectHave = json['rectHave'];
    rectContent = json['rectContent'];
    rectUserName = json['rectUserName'];
    rectTime = json['rectTime'];
    taskMonth = TaskMonths.fromJson(json['taskMonth']);
    deviceRiskParent = DeviceRiskParents.fromJson(json['deviceRiskParent']);
    deviceRisk = DeviceRisks.fromJson(json['deviceRisk']);
  }

  Map<String, dynamic> toJson() {
    final _data = <String, dynamic>{};
    _data['id'] = id;
    _data['name'] = name;
    _data['result'] = result;
    _data['sort'] = sort;
    _data['riskContent'] = riskContent;
    _data['rectHave'] = rectHave;
    _data['rectContent'] = rectContent;
    _data['rectUserName'] = rectUserName;
    _data['rectTime'] = rectTime;
    _data['taskMonth'] = taskMonth.toJson();
    _data['deviceRiskParent'] = deviceRiskParent.toJson();
    _data['deviceRisk'] = deviceRisk.toJson();
    return _data;
  }
}

class TaskMonths {
  TaskMonths({
    required this.id,
  });

  late final String id;

  TaskMonths.fromJson(Map<String, dynamic> json) {
    id = json['id'];
  }

  Map<String, dynamic> toJson() {
    final _data = <String, dynamic>{};
    _data['id'] = id;
    return _data;
  }
}
