class LoginBo {
  LoginBo({
    this.username,
    this.userId,
    this.name,
    this.mobileLogin,
    this.jsessionid,
    this.user,
  });

  LoginBo.fromJson(dynamic json) {
    username = json['username'];
    userId = json['userId'];
    name = json['name'];
    mobileLogin = json['mobileLogin'];
    jsessionid = json['JSESSIONID'];
    user = json['user'] != null ? User.fromJson(json['user']) : null;
  }

  String? username;
  String? userId;
  String? name;
  bool? mobileLogin;
  String? jsessionid;
  User? user;

  LoginBo copyWith({
    String? username,
    String? userId,
    String? name,
    bool? mobileLogin,
    String? jsessionid,
    User? user,
  }) =>
      LoginBo(
        username: username ?? this.username,
        userId: userId ?? this.userId,
        name: name ?? this.name,
        mobileLogin: mobileLogin ?? this.mobileLogin,
        jsessionid: jsessionid ?? this.jsessionid,
        user: user ?? this.user,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['username'] = username;
    map['userId'] = userId;
    map['name'] = name;
    map['mobileLogin'] = mobileLogin;
    map['JSESSIONID'] = jsessionid;
    if (user != null) {
      map['user'] = user?.toJson();
    }
    return map;
  }
}

class User {
  User({
    this.id,
    this.office,
    this.loginName,
    this.no,
    this.name,
    this.email,
    this.mobile,
    this.loginFlag,
    this.photo,
    this.roleNames,
    this.admin,
  });

  User.fromJson(dynamic json) {
    id = json['id'];
    office = json['office'] != null ? Office.fromJson(json['office']) : null;
    loginName = json['loginName'];
    no = json['no'];
    name = json['name'];
    email = json['email'];
    mobile = json['mobile'];
    loginFlag = json['loginFlag'];
    photo = json['photo'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  Office? office;
  String? loginName;
  String? no;
  String? name;
  String? email;
  String? mobile;
  String? loginFlag;
  String? photo;
  String? roleNames;
  bool? admin;

  User copyWith({
    String? id,
    Office? office,
    String? loginName,
    String? no,
    String? name,
    String? email,
    String? mobile,
    String? loginFlag,
    String? photo,
    String? roleNames,
    bool? admin,
  }) =>
      User(
        id: id ?? this.id,
        office: office ?? this.office,
        loginName: loginName ?? this.loginName,
        no: no ?? this.no,
        name: name ?? this.name,
        email: email ?? this.email,
        mobile: mobile ?? this.mobile,
        loginFlag: loginFlag ?? this.loginFlag,
        photo: photo ?? this.photo,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    if (office != null) {
      map['office'] = office?.toJson();
    }
    map['loginName'] = loginName;
    map['no'] = no;
    map['name'] = name;
    map['email'] = email;
    map['mobile'] = mobile;
    map['loginFlag'] = loginFlag;
    map['photo'] = photo;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}

class Office {
  Office({
    this.id,
    this.parentIds,
    this.name,
    this.sort,
    this.hasChildren,
    this.type,
    this.parentId,
  });

  Office.fromJson(dynamic json) {
    id = json['id'];
    parentIds = json['parentIds'];
    name = json['name'];
    sort = json['sort'];
    hasChildren = json['hasChildren'];
    type = json['type'];
    parentId = json['parentId'];
  }

  String? id;
  String? parentIds;
  String? name;
  num? sort;
  bool? hasChildren;
  String? type;
  String? parentId;

  Office copyWith({
    String? id,
    String? parentIds,
    String? name,
    num? sort,
    bool? hasChildren,
    String? type,
    String? parentId,
  }) =>
      Office(
        id: id ?? this.id,
        parentIds: parentIds ?? this.parentIds,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        hasChildren: hasChildren ?? this.hasChildren,
        type: type ?? this.type,
        parentId: parentId ?? this.parentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['parentIds'] = parentIds;
    map['name'] = name;
    map['sort'] = sort;
    map['hasChildren'] = hasChildren;
    map['type'] = type;
    map['parentId'] = parentId;
    return map;
  }
}
