class FindCountBo {
  FindCountBo({
    this.list,
  });

  FindCountBo.fromJson(dynamic json) {
    if (json['list'] != null) {
      list = [];
      json['list'].forEach((v) {
        list?.add(CountData.fromJson(v));
      });
    }
  }

  List<CountData>? list;

  FindCountBo copyWith({
    List<CountData>? list,
  }) =>
      FindCountBo(
        list: list ?? this.list,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (list != null) {
      map['list'] = list?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class CountData {
  CountData({
    this.deviceTypeId,
    this.count,
  });

  CountData.fromJson(dynamic json) {
    deviceTypeId = json['deviceTypeId'];
    count = json['count'];
  }

  String? deviceTypeId;
  int? count;

  CountData copyWith({
    String? deviceTypeId,
    int? count,
  }) =>
      CountData(
        deviceTypeId: deviceTypeId ?? this.deviceTypeId,
        count: count ?? this.count,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['deviceTypeId'] = deviceTypeId;
    map['count'] = count;
    return map;
  }
}
