class FindChargeListBo {
  FindChargeListBo({
    this.list,
  });

  FindChargeListBo.fromJson(dynamic json) {
    if (json['list'] != null) {
      list = [];
      json['list'].forEach((v) {
        list?.add(ChargeUserList.fromJson(v));
      });
    }
  }

  String? chargeNames = '';
  List<ChargeUserList>? list;

  FindChargeListBo copyWith({
    List<ChargeUserList>? list,
  }) =>
      FindChargeListBo(
        list: list ?? this.list,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (list != null) {
      map['list'] = list?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class ChargeUserList {
  ChargeUserList({
    this.id,
    this.office,
    this.loginName,
    this.name,
    this.mobile,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  ChargeUserList.fromJson(dynamic json) {
    id = json['id'];
    office = json['office'] != null ? Office.fromJson(json['office']) : null;
    loginName = json['loginName'];
    name = json['name'];
    mobile = json['mobile'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  Office? office;
  String? loginName;
  String? name;
  String? mobile;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  ChargeUserList copyWith({
    String? id,
    Office? office,
    String? loginName,
    String? name,
    String? mobile,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      ChargeUserList(
        id: id ?? this.id,
        office: office ?? this.office,
        loginName: loginName ?? this.loginName,
        name: name ?? this.name,
        mobile: mobile ?? this.mobile,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    if (office != null) {
      map['office'] = office?.toJson();
    }
    map['loginName'] = loginName;
    map['name'] = name;
    map['mobile'] = mobile;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}

class Office {
  Office({
    this.id,
    this.parentIds,
    this.name,
    this.sort,
    this.hasChildren,
    this.type,
    this.parentId,
  });

  Office.fromJson(dynamic json) {
    id = json['id'];
    parentIds = json['parentIds'];
    name = json['name'];
    sort = json['sort'];
    hasChildren = json['hasChildren'];
    type = json['type'];
    parentId = json['parentId'];
  }

  String? id;
  String? parentIds;
  String? name;
  num? sort;
  bool? hasChildren;
  String? type;
  String? parentId;

  Office copyWith({
    String? id,
    String? parentIds,
    String? name,
    num? sort,
    bool? hasChildren,
    String? type,
    String? parentId,
  }) =>
      Office(
        id: id ?? this.id,
        parentIds: parentIds ?? this.parentIds,
        name: name ?? this.name,
        sort: sort ?? this.sort,
        hasChildren: hasChildren ?? this.hasChildren,
        type: type ?? this.type,
        parentId: parentId ?? this.parentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['parentIds'] = parentIds;
    map['name'] = name;
    map['sort'] = sort;
    map['hasChildren'] = hasChildren;
    map['type'] = type;
    map['parentId'] = parentId;
    return map;
  }
}
