class UnitPersonListBo {
  UnitPersonListBo({
    this.userList,
  });

  UnitPersonListBo.fromJson(dynamic json) {
    if (json['userList'] != null) {
      userList = [];
      json['userList'].forEach((v) {
        userList?.add(UserLists.fromJson(v));
      });
    }
  }

  List<UserLists>? userList;

  UnitPersonListBo copyWith({
    List<UserLists>? userList,
  }) =>
      UnitPersonListBo(
        userList: userList ?? this.userList,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (userList != null) {
      map['userList'] = userList?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class UserLists {
  UserLists({
    this.id,
    this.name,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  UserLists.fromJson(dynamic json) {
    id = json['id'];
    name = json['name'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? name;
  String? loginFlag;
  String? roleNames;
  bool? admin;
  bool? isChecked = false;
  bool? isUserSafetyDirectorChecked = true;
  bool? isUserSafetyOfficerChecked = true;

  UserLists copyWith({
    String? id,
    String? name,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      UserLists(
        id: id ?? this.id,
        name: name ?? this.name,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}
