class TestQuestionsBo {
  TestQuestionsBo({
    this.data,
  });

  TestQuestionsBo.fromJson(dynamic json) {
    data = json['data'] != null ? DataTest.fromJson(json['data']) : null;
  }

  DataTest? data;

  TestQuestionsBo copyWith({
    DataTest? data,
  }) =>
      TestQuestionsBo(
        data: data ?? this.data,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (data != null) {
      map['data'] = data?.toJson();
    }
    return map;
  }
}

class DataTest {
  DataTest({
    this.id,
    this.createBy,
    this.createDate,
    this.updateBy,
    this.updateDate,
    this.name,
    this.questionNum,
    this.user,
    this.adopt,
    this.unit,
    this.examDate,
    this.dxNum,
    this.pdNum,
    this.examQuestionList,
  });

  DataTest.fromJson(dynamic json) {
    id = json['id'];
    createBy =
        json['createBy'] != null ? CreateBy.fromJson(json['createBy']) : null;
    createDate = json['createDate'];
    updateBy =
        json['updateBy'] != null ? UpdateBy.fromJson(json['updateBy']) : null;
    updateDate = json['updateDate'];
    name = json['name'];
    questionNum = json['questionNum'];
    user = json['user'] != null ? User.fromJson(json['user']) : null;
    adopt = json['adopt'];
    unit = json['unit'] != null ? Unit.fromJson(json['unit']) : null;
    examDate = json['examDate'];
    dxNum = json['dxNum'];
    pdNum = json['pdNum'];
    if (json['examQuestionList'] != null) {
      examQuestionList = [];
      json['examQuestionList'].forEach((v) {
        examQuestionList?.add(ExamQuestionTestList.fromJson(v));
      });
    }
  }

  String? id;
  CreateBy? createBy;
  String? createDate;
  UpdateBy? updateBy;
  String? updateDate;
  String? name;
  num? questionNum;
  User? user;
  String? adopt;
  Unit? unit;
  String? examDate;
  num? dxNum;
  num? pdNum;
  List<ExamQuestionTestList>? examQuestionList;

  DataTest copyWith({
    String? id,
    CreateBy? createBy,
    String? createDate,
    UpdateBy? updateBy,
    String? updateDate,
    String? name,
    num? questionNum,
    User? user,
    String? adopt,
    Unit? unit,
    String? examDate,
    num? dxNum,
    num? pdNum,
    List<ExamQuestionTestList>? examQuestionList,
  }) =>
      DataTest(
        id: id ?? this.id,
        createBy: createBy ?? this.createBy,
        createDate: createDate ?? this.createDate,
        updateBy: updateBy ?? this.updateBy,
        updateDate: updateDate ?? this.updateDate,
        name: name ?? this.name,
        questionNum: questionNum ?? this.questionNum,
        user: user ?? this.user,
        adopt: adopt ?? this.adopt,
        unit: unit ?? this.unit,
        examDate: examDate ?? this.examDate,
        dxNum: dxNum ?? this.dxNum,
        pdNum: pdNum ?? this.pdNum,
        examQuestionList: examQuestionList ?? this.examQuestionList,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    if (createBy != null) {
      map['createBy'] = createBy?.toJson();
    }
    map['createDate'] = createDate;
    if (updateBy != null) {
      map['updateBy'] = updateBy?.toJson();
    }
    map['updateDate'] = updateDate;
    map['name'] = name;
    map['questionNum'] = questionNum;
    if (user != null) {
      map['user'] = user?.toJson();
    }
    map['adopt'] = adopt;
    if (unit != null) {
      map['unit'] = unit?.toJson();
    }
    map['examDate'] = examDate;
    map['dxNum'] = dxNum;
    map['pdNum'] = pdNum;
    if (examQuestionList != null) {
      map['examQuestionList'] =
          examQuestionList?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

class ExamQuestionTestList {
  ExamQuestionTestList({
    this.id,
    this.content,
    this.answer,
    this.type,
    this.questionType,
    this.detailId,
    this.sort,
    this.examQuestionOptionList,
    this.result,
  });

  ExamQuestionTestList.fromJson(dynamic json) {
    id = json['id'];
    content = json['content'];
    answer = json['answer'];
    type = json['type'];
    questionType = json['questionType'];
    detailId = json['detailId'];
    sort = json['sort'];
    if (json['examQuestionOptionList'] != null) {
      examQuestionOptionList = [];
      json['examQuestionOptionList'].forEach((v) {
        examQuestionOptionList?.add(ExamQuestionTestOptionList.fromJson(v));
      });
    }
    result = json['result'];
  }

  String? id;
  String? content;
  String? answer;
  String? type;
  String? questionType;
  String? detailId;
  int? sort;
  List<ExamQuestionTestOptionList>? examQuestionOptionList;
  String? result = '';

  ExamQuestionTestList copyWith({
    String? id,
    String? content,
    String? answer,
    String? type,
    String? questionType,
    String? detailId,
    int? sort,
    List<ExamQuestionTestOptionList>? examQuestionOptionList,
    String? result,
  }) =>
      ExamQuestionTestList(
        id: id ?? this.id,
        content: content ?? this.content,
        answer: answer ?? this.answer,
        type: type ?? this.type,
        questionType: questionType ?? this.questionType,
        detailId: detailId ?? this.detailId,
        sort: sort ?? this.sort,
        examQuestionOptionList:
            examQuestionOptionList ?? this.examQuestionOptionList,
        result: result ?? this.result,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['content'] = content;
    map['answer'] = answer;
    map['type'] = type;
    map['questionType'] = questionType;
    map['detailId'] = detailId;
    map['sort'] = sort;
    if (examQuestionOptionList != null) {
      map['examQuestionOptionList'] =
          examQuestionOptionList?.map((v) => v.toJson()).toList();
    }
    map['result'] = result;
    return map;
  }
}

class ExamQuestionTestOptionList {
  ExamQuestionTestOptionList({
    this.id,
    this.content,
    this.options,
    this.question,
  });

  ExamQuestionTestOptionList.fromJson(dynamic json) {
    id = json['id'];
    content = json['content'];
    options = json['options'];
    question =
        json['question'] != null ? Question.fromJson(json['question']) : null;
  }

  String? id;
  String? content;
  String? options;
  Question? question;
  bool? isSelected = false;
  String? flag = '';

  ExamQuestionTestOptionList copyWith({
    String? id,
    String? content,
    String? options,
    Question? question,
  }) =>
      ExamQuestionTestOptionList(
        id: id ?? this.id,
        content: content ?? this.content,
        options: options ?? this.options,
        question: question ?? this.question,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['content'] = content;
    map['options'] = options;
    if (question != null) {
      map['question'] = question?.toJson();
    }
    return map;
  }
}

class Question {
  Question({
    this.id,
  });

  Question.fromJson(dynamic json) {
    id = json['id'];
  }

  String? id;

  Question copyWith({
    String? id,
  }) =>
      Question(
        id: id ?? this.id,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    return map;
  }
}

class Unit {
  Unit({
    this.id,
    this.sort,
    this.hasChildren,
    this.parentId,
  });

  Unit.fromJson(dynamic json) {
    id = json['id'];
    sort = json['sort'];
    hasChildren = json['hasChildren'];
    parentId = json['parentId'];
  }

  String? id;
  num? sort;
  bool? hasChildren;
  String? parentId;

  Unit copyWith({
    String? id,
    num? sort,
    bool? hasChildren,
    String? parentId,
  }) =>
      Unit(
        id: id ?? this.id,
        sort: sort ?? this.sort,
        hasChildren: hasChildren ?? this.hasChildren,
        parentId: parentId ?? this.parentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['sort'] = sort;
    map['hasChildren'] = hasChildren;
    map['parentId'] = parentId;
    return map;
  }
}

class User {
  User({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  User.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  User copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      User(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}

class UpdateBy {
  UpdateBy({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  UpdateBy.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  UpdateBy copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      UpdateBy(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}

class CreateBy {
  CreateBy({
    this.id,
    this.loginFlag,
    this.roleNames,
    this.admin,
  });

  CreateBy.fromJson(dynamic json) {
    id = json['id'];
    loginFlag = json['loginFlag'];
    roleNames = json['roleNames'];
    admin = json['admin'];
  }

  String? id;
  String? loginFlag;
  String? roleNames;
  bool? admin;

  CreateBy copyWith({
    String? id,
    String? loginFlag,
    String? roleNames,
    bool? admin,
  }) =>
      CreateBy(
        id: id ?? this.id,
        loginFlag: loginFlag ?? this.loginFlag,
        roleNames: roleNames ?? this.roleNames,
        admin: admin ?? this.admin,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['loginFlag'] = loginFlag;
    map['roleNames'] = roleNames;
    map['admin'] = admin;
    return map;
  }
}
